/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure;

import com.pixelmonmod.pixelmon.config.PixelmonConfig;
import com.pixelmonmod.pixelmon.config.PixelmonGen;
import com.pixelmonmod.pixelmon.structure.StructureData;
import com.pixelmonmod.pixelmon.structure.filter.AbstractImportFilter;
import com.pixelmonmod.pixelmon.structure.filter.ImportFilterWool2Apricorn;
import com.pixelmonmod.pixelmon.structure.filter.TileFilter;
import com.pixelmonmod.pixelmon.structure.filter.TilePokechestFilter;
import com.pixelmonmod.pixelmon.structure.generation.AbstractStructureModifier;
import com.pixelmonmod.pixelmon.structure.generation.criteria.AbstractSpawnCriteria;
import com.pixelmonmod.pixelmon.structure.generation.criteria.SpawnCriteriaAvoidSea;
import com.pixelmonmod.pixelmon.structure.generation.criteria.SpawnCriteriaFlatArea;
import com.pixelmonmod.pixelmon.structure.generation.criteria.SpawnCriteriaMinDistance;
import com.pixelmonmod.pixelmon.structure.generation.criteria.SpawnCriteriaMinMaxY;
import com.pixelmonmod.pixelmon.structure.generation.criteria.SpawnCriteriaNoOverlap;
import com.pixelmonmod.pixelmon.structure.generation.criteria.SpawnCriteriaNotInWater;
import com.pixelmonmod.pixelmon.structure.generation.criteria.SpawnCriteriaSpecificBiome;
import com.pixelmonmod.pixelmon.structure.generation.groundhelper.GroundHelperFlatArea;
import com.pixelmonmod.pixelmon.structure.generation.groundhelper.GroundHelperFlatAreaBottomLayer;
import com.pixelmonmod.pixelmon.structure.generation.groundhelper.GroundHelperSurfacePoint;
import com.pixelmonmod.pixelmon.structure.generation.specialgen.SpecialGenExtendPillar;
import com.pixelmonmod.pixelmon.structure.generation.specialgen.SpecialGenFixGrass;
import com.pixelmonmod.pixelmon.structure.generation.specialgen.SpecialGenPostPlacement;
import com.pixelmonmod.pixelmon.structure.generation.specialgen.SpecialGenRandomMeta;
import com.pixelmonmod.pixelmon.structure.generation.specialgen.SpecialGenRandomMetaPerEach;
import com.pixelmonmod.pixelmon.structure.generation.specialgen.SpecialGenVines;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import java.util.Set;
import net.minecraft.world.biome.BiomeGenBase;

public class StructureRegistry {
    public static HashMap<BiomeGenBase, ArrayList<StructureData>> structuresByBiome = new HashMap();
    public static HashMap<String, StructureData> structuresByName = new HashMap();
    public static HashMap<String, StructureData> arenasByName = new HashMap();
    private static HashMap<String, Class<? extends AbstractStructureModifier>> modifiersByName = new HashMap();
    private static ArrayList<Class<? extends AbstractSpawnCriteria>> spawnCriteriaToStatusCodes = new ArrayList();
    private static HashMap<String, AbstractImportFilter> filtersByName = new HashMap();
    private static HashMap<String, Class<? extends TileFilter>> tileFiltersByName = new HashMap();

    public static void loadStructures(Side side) {
        String standalone = "/com/pixelmonmod/pixelmon/structure/standAlone/";
        StructureRegistry.loadAllOf("pokecenter", standalone, StructureType.standAlone);
        if (PixelmonConfig.spawnBirdShrines) {
            StructureRegistry.loadAllOf("shrine", standalone, StructureType.standAlone);
        }
        if (PixelmonConfig.spawnGemShrines) {
            StructureRegistry.loadAllOf("gem", standalone + "gem/", StructureType.standAlone);
        }
        StructureRegistry.loadAllOf("arena", "/com/pixelmonmod/pixelmon/structure/battleDimension/", StructureType.arena);
        PixelmonGen.postStructureInit();
    }

    private static void loadAllOf(String mainFilename, String path, StructureType type) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        int i = 1;
        while (StructureRegistry.class.getResourceAsStream(path + mainFilename + i + ".data") != null) {
            StructureRegistry.load(mainFilename + i, path, type);
            ++i;
        }
    }

    private static void addBiomeStructureEntry(BiomeGenBase biome, StructureData data) {
        ArrayList<StructureData> list = null;
        list = structuresByBiome.get(biome);
        if (list == null) {
            list = new ArrayList();
            structuresByBiome.put(biome, list);
        }
        list.add(data);
    }

    private static void load(String filename, String path, StructureType type) {
        StructureData data;
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        if ((data = new StructureData(filename, path)) != null) {
            if (type == StructureType.standAlone) {
                if (data.biomes != null) {
                    for (BiomeGenBase biome : data.biomes) {
                        StructureRegistry.addBiomeStructureEntry(biome, data);
                    }
                }
                if (data.simpleName != null) {
                    StructureData d = structuresByName.get(data.simpleName);
                    if (d != null) {
                        throw new IllegalArgumentException(String.format("The name %s specified by %s is already in use by %s!", data.simpleName, data.path, d.path));
                    }
                    structuresByName.put(data.simpleName, data);
                }
            } else {
                arenasByName.put(data.simpleName, data);
            }
        }
    }

    public static StructureData getScatteredStructureFromBiome(Random random, BiomeGenBase biomeGenForCoords) {
        ArrayList<StructureData> possibleStructures = null;
        possibleStructures = structuresByBiome.get(biomeGenForCoords);
        if (possibleStructures != null && !possibleStructures.isEmpty()) {
            return possibleStructures.get(random.nextInt(possibleStructures.size()));
        }
        return null;
    }

    public static StructureData getScatteredStructureFromName(String name) {
        return CommonHelper.getIgnoreCase(structuresByName, name);
    }

    public static void registerModifierType(Class<? extends AbstractStructureModifier> modifierClass, String name) {
        Class<? extends AbstractStructureModifier> c = CommonHelper.getIgnoreCase(modifiersByName, name);
        if (c != null) {
            throw new IllegalArgumentException(String.format("The name \"%s\" is already in use by %s", name, c.getName()));
        }
        modifiersByName.put(name, modifierClass);
        if (AbstractSpawnCriteria.class.isAssignableFrom(modifierClass)) {
            spawnCriteriaToStatusCodes.add(modifierClass);
        }
    }

    public static void registerImportFilter(AbstractImportFilter filter, String name) {
        AbstractImportFilter f = CommonHelper.getIgnoreCase(filtersByName, name);
        if (f != null) {
            throw new IllegalArgumentException(String.format("The name \"%s\" is already in use by %s", name, f));
        }
        filtersByName.put(name, filter);
    }

    public static void registerTileFilter(Class<? extends TileFilter> filterClass, String name) {
        Class<? extends TileFilter> c = CommonHelper.getIgnoreCase(tileFiltersByName, name);
        if (c != null) {
            throw new IllegalArgumentException(String.format("The name \"%s\" is already in use by %s", name, c));
        }
        tileFiltersByName.put(name, filterClass);
    }

    public static Class<? extends AbstractStructureModifier> getModifierTypeByName(String name) {
        return CommonHelper.getIgnoreCase(modifiersByName, name);
    }

    public static AbstractImportFilter getImportFilterByName(String name) {
        return CommonHelper.getIgnoreCase(filtersByName, name);
    }

    public static AbstractImportFilter demandImportFilterByName(String name) {
        AbstractImportFilter result = StructureRegistry.getImportFilterByName(name);
        if (result != null) {
            return result;
        }
        String message = "Tried to use an import filter named \"%s\", but no such import filter was found!";
        message = String.format(message, name) + "\nThe choices for Import Filters are as follows : ";
        for (String n : StructureRegistry.getAllFilterNames()) {
            message = message + "\n" + n;
        }
        throw new IllegalArgumentException(message);
    }

    public static Class<? extends TileFilter> getTileFilterByName(String name) {
        return CommonHelper.getIgnoreCase(tileFiltersByName, name);
    }

    public static int getStatusCodeFor(Class<? extends AbstractSpawnCriteria> clazz) {
        int i = spawnCriteriaToStatusCodes.indexOf(clazz);
        if (i == -1) {
            throw new IllegalArgumentException(clazz.getName() + " is not registered.");
        }
        return i;
    }

    public static Set<String> getAllModifierNames() {
        return Collections.unmodifiableSet(modifiersByName.keySet());
    }

    public static Set<String> getAllFilterNames() {
        return Collections.unmodifiableSet(filtersByName.keySet());
    }

    public static StructureData getArenaFromBiome(Random rand, BiomeGenBase biomeGenForCoords) {
        return arenasByName.get("arena1");
    }

    public static Set<String> getAllTileFilterNames() {
        return Collections.unmodifiableSet(tileFiltersByName.keySet());
    }

    static {
        StructureRegistry.registerModifierType(SpecialGenRandomMetaPerEach.class, "randomMetaPerEach");
        StructureRegistry.registerModifierType(SpecialGenRandomMeta.class, "randomMetaAll");
        StructureRegistry.registerModifierType(SpecialGenExtendPillar.class, "createPillar");
        StructureRegistry.registerModifierType(SpecialGenFixGrass.class, "fixGrass");
        StructureRegistry.registerModifierType(SpecialGenVines.class, "vines");
        StructureRegistry.registerModifierType(SpecialGenPostPlacement.class, "postPlacement");
        StructureRegistry.registerModifierType(SpawnCriteriaFlatArea.class, "flatAreaCriteria");
        StructureRegistry.registerModifierType(SpawnCriteriaSpecificBiome.class, "fitInBiome");
        StructureRegistry.registerModifierType(SpawnCriteriaNoOverlap.class, "AvoidStructures");
        StructureRegistry.registerModifierType(SpawnCriteriaMinDistance.class, "KeepDistance");
        StructureRegistry.registerModifierType(SpawnCriteriaNotInWater.class, "AvoidWater");
        StructureRegistry.registerModifierType(SpawnCriteriaAvoidSea.class, "AvoidSea");
        StructureRegistry.registerModifierType(SpawnCriteriaMinMaxY.class, "YRange");
        StructureRegistry.registerModifierType(GroundHelperSurfacePoint.class, "SurfacePoint");
        StructureRegistry.registerModifierType(GroundHelperFlatArea.class, "FlatAreaGround");
        StructureRegistry.registerModifierType(GroundHelperFlatAreaBottomLayer.class, "FlatAreaSchematicBottom");
        StructureRegistry.registerImportFilter(new ImportFilterWool2Apricorn(), "Wool2Apricorns");
        StructureRegistry.registerTileFilter(TilePokechestFilter.class, "pokechest");
    }

    private static enum StructureType {
        standAlone,
        arena;

    }
}

