/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure.generation;

import com.pixelmonmod.pixelmon.blocks.IBlockRotator;
import com.pixelmonmod.pixelmon.blocks.decorative.BlockContainerPlus;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPistonBase;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.init.Blocks;

public class BlockRotation {
    public static int setBlockRotation(int coordBaseMode, Block block, int par2) {
        if (block instanceof IBlockRotator) {
            IBlockRotator ibr = (IBlockRotator)block;
            return ibr.rotate(coordBaseMode, block, par2);
        }
        if (block instanceof BlockStairs) {
            return BlockRotation.rotateStairs(coordBaseMode, block, par2);
        }
        if (block == Blocks.field_150442_at) {
            return BlockRotation.rotateLever(coordBaseMode, block, par2);
        }
        if (block == Blocks.field_150331_J || block == Blocks.field_150320_F) {
            return BlockRotation.rotatePiston(coordBaseMode, block, par2);
        }
        if (block == Blocks.field_150415_aT) {
            return BlockRotation.rotateTrapDoor(coordBaseMode, block, par2);
        }
        if (block == Blocks.field_150478_aa || block == Blocks.field_150429_aA) {
            return BlockRotation.rotateTorch(coordBaseMode, block, par2);
        }
        if (block == Blocks.field_150472_an || block == Blocks.field_150444_as) {
            return BlockRotation.rotateSign(coordBaseMode, block, par2);
        }
        if (block == Blocks.field_150324_C) {
            return BlockRotation.rotateBed(coordBaseMode, block, par2);
        }
        if (block instanceof BlockContainerPlus) {
            return BlockContainerPlus.rotate(coordBaseMode, block, par2);
        }
        return par2;
    }

    private static int rotateSign(int coordBaseMode, Block block, int par2) {
        if (coordBaseMode == 1) {
            if (par2 == 4) {
                return 2;
            }
            if (par2 == 2) {
                return 5;
            }
            if (par2 == 5) {
                return 3;
            }
            if (par2 == 3) {
                return 4;
            }
        }
        if (coordBaseMode == 2) {
            if (par2 == 4) {
                return 5;
            }
            if (par2 == 2) {
                return 3;
            }
            if (par2 == 5) {
                return 4;
            }
            if (par2 == 3) {
                return 2;
            }
        }
        if (coordBaseMode == 3) {
            if (par2 == 4) {
                return 3;
            }
            if (par2 == 2) {
                return 4;
            }
            if (par2 == 5) {
                return 2;
            }
            if (par2 == 3) {
                return 5;
            }
        }
        return par2;
    }

    private static int rotateTrapDoor(int coordBaseMode, Block block, int par2) {
        boolean opened = BlockTrapDoor.func_150118_d((int)par2);
        boolean placedTop = false;
        int side = par2;
        int returnval = -1;
        if (opened) {
            side = par2 ^ 4;
        }
        if (side > 7) {
            placedTop = true;
            side &= 0xFFFFFFF7;
        }
        if (coordBaseMode == 1) {
            if (side == 2) {
                returnval = 0;
            } else if (side == 0) {
                returnval = 3;
            } else if (side == 3) {
                returnval = 1;
            } else if (side == 1) {
                returnval = 2;
            }
        }
        if (coordBaseMode == 2) {
            if (side == 2) {
                returnval = 2;
            } else if (side == 0) {
                returnval = 1;
            } else if (side == 3) {
                returnval = 3;
            } else if (side == 1) {
                returnval = 0;
            }
        }
        if (coordBaseMode == 3) {
            if (side == 2) {
                returnval = 0;
            } else if (side == 0) {
                returnval = 2;
            } else if (side == 3) {
                returnval = 1;
            } else if (side == 1) {
                returnval = 3;
            }
        }
        if (returnval != -1) {
            if (placedTop) {
                returnval |= 8;
            }
            if (opened) {
                returnval ^= 4;
            }
            return returnval;
        }
        return par2;
    }

    private static int rotateLever(int coordBaseMode, Block block, int par2) {
        int othermeta = par2 & 8;
        int side = par2 & 7;
        if (coordBaseMode == 1) {
            if (side == 4) {
                return 1 + othermeta;
            }
            if (side == 1) {
                return 3 + othermeta;
            }
            if (side == 3) {
                return 2 + othermeta;
            }
            if (side == 2) {
                return 4 + othermeta;
            }
        } else if (coordBaseMode == 3) {
            if (side == 4) {
                return 2 + othermeta;
            }
            if (side == 1) {
                return 4 + othermeta;
            }
            if (side == 3) {
                return 1 + othermeta;
            }
            if (side == 2) {
                return 3 + othermeta;
            }
        } else if (coordBaseMode == 2) {
            if (side == 1) {
                return 2 + othermeta;
            }
            if (side == 2) {
                return 1 + othermeta;
            }
            if (side == 4) {
                return 3 + othermeta;
            }
            if (side == 3) {
                return 4 + othermeta;
            }
        }
        return par2;
    }

    private static int rotatePiston(int coordBaseMode, Block block, int par2) {
        int extended = BlockPistonBase.func_150075_c((int)par2) ? 1 : 0;
        int side = BlockPistonBase.func_150076_b((int)par2);
        if (coordBaseMode == 1) {
            if (side == 5) {
                return 2 + extended;
            }
            if (side == 4) {
                return 4 + extended;
            }
            if (side == 3) {
                return 2 + extended;
            }
            if (side == 2) {
                return 5 + extended;
            }
        } else if (coordBaseMode == 3) {
            if (side == 5) {
                return 3 + extended;
            }
            if (side == 2) {
                return 5 + extended;
            }
            if (side == 4) {
                return 2 + extended;
            }
            if (side == 3) {
                return 4 + extended;
            }
        } else if (coordBaseMode == 2) {
            if (side == 2) {
                return 3 + extended;
            }
            if (side == 3) {
                return 2 + extended;
            }
            if (side == 5) {
                return 4 + extended;
            }
            if (side == 4) {
                return 3 + extended;
            }
        }
        return par2;
    }

    private static int rotateStairs(int coordBaseMode, Block block, int meta) {
        int flag = meta & 4;
        meta &= 3;
        switch (coordBaseMode) {
            case 1: {
                meta = meta < 2 ? meta + 2 : (meta == 2 ? 1 : 0);
                break;
            }
            case 2: {
                meta = meta == 2 ? 3 : (meta == 3 ? 2 : meta);
                break;
            }
            case 3: {
                meta = meta < 2 ? meta + 2 : meta - 2;
            }
        }
        return meta | flag;
    }

    private static int rotateTorch(int coordBaseMode, Block block, int meta) {
        switch (coordBaseMode) {
            case 0: {
                return meta;
            }
            case 1: {
                switch (meta) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return 1;
                    }
                }
                break;
            }
            case 2: {
                switch (meta) {
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 3;
                    }
                }
                break;
            }
            case 3: {
                switch (meta) {
                    case 1: {
                        return 3;
                    }
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 1;
                    }
                    case 4: {
                        return 2;
                    }
                }
            }
        }
        return meta;
    }

    private static int rotateBed(int coordBaseMode, Block block, int meta) {
        int flag = meta & 0xC;
        meta &= 3;
        switch (coordBaseMode) {
            case 1: {
                return meta + 1 > 3 ? flag : meta + 1 | flag;
            }
            case 2: {
                return meta == 0 ? 2 | flag : (meta == 2 ? flag : meta | flag);
            }
            case 3: {
                return (meta & 1) == 1 ? meta + 1 | flag : meta - 1 | flag;
            }
        }
        return meta | flag;
    }

    private static int rotatePixelmonBlock(int coordBaseMode, Block block, int par2) {
        if (coordBaseMode == 2) {
            if (par2 == 2) {
                return 0;
            }
            if (par2 == 0) {
                return 2;
            }
        } else if (coordBaseMode == 1) {
            if (par2 == 0) {
                return 3;
            }
            if (par2 == 1) {
                return 0;
            }
            if (par2 == 2) {
                return 1;
            }
            if (par2 == 3) {
                return 2;
            }
        } else if (coordBaseMode == 3) {
            if (par2 == 2) {
                return 3;
            }
            if (par2 == 1) {
                return 0;
            }
            if (par2 == 0) {
                return 1;
            }
            if (par2 == 3) {
                return 2;
            }
        }
        return par2;
    }

    public static int setPixelmonBlockRotation(int coordBaseMode, Block block, int par2) {
        return BlockRotation.rotatePixelmonBlock(coordBaseMode, block, par2);
    }
}

