/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure.generation;

import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.blocks.BlockEntry;
import com.pixelmonmod.pixelmon.storage.structure.IStructureAwareness;
import com.pixelmonmod.pixelmon.storage.structure.StructureStorage;
import com.pixelmonmod.pixelmon.structure.SchematicEntry;
import com.pixelmonmod.pixelmon.structure.SchematicImporter;
import com.pixelmonmod.pixelmon.structure.StructureData;
import com.pixelmonmod.pixelmon.structure.generation.BlockRotation;
import com.pixelmonmod.pixelmon.structure.generation.SpecialParameters;
import com.pixelmonmod.pixelmon.structure.generation.StructureScattered;
import com.pixelmonmod.pixelmon.structure.generation.criteria.AbstractSpawnCriteria;
import com.pixelmonmod.pixelmon.structure.generation.groundhelper.AbstractGroundHelper;
import com.pixelmonmod.pixelmon.structure.generation.specialgen.AbstractSpecialGen;
import com.pixelmonmod.pixelmon.util.helpers.BlockHelper;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class ComplexScattered
extends StructureScattered
implements IStructureAwareness {
    public SchematicEntry mainComponent;
    public ArrayList<SchematicEntry> components = new ArrayList();
    protected ArrayList<AbstractSpawnCriteria> spawnCriteria = new ArrayList();
    protected AbstractGroundHelper flatHelper;
    protected boolean doBBoxCheck = true;
    public int statusCode = -3;
    private boolean forceGeneration;
    public StructureBoundingBox[] bbxs;
    public String name;
    protected World worldObj;

    public ComplexScattered(Random rand, int x, int y, int z, StructureData data, boolean doRotation, boolean forceGeneration) {
        super(rand, x, y, z, 0, 0, 0, doRotation);
        this.forceGeneration = forceGeneration;
        this.name = data.simpleName;
        StructureBoundingBox bb = this.initBB(data.mainComponent, x, y, z, true);
        this.mainComponent = new SchematicEntry(data.mainComponent, bb);
        for (int i = 0; i < data.components.size(); ++i) {
            SchematicImporter schem = data.components.get(i);
            bb = this.initBB(schem, x, y, z, false);
            this.components.add(new SchematicEntry(schem, bb));
        }
        ArrayList<StructureBoundingBox> bbxList = new ArrayList<StructureBoundingBox>();
        bbxList.add(this.mainComponent.bbox);
        for (SchematicEntry schentry : this.components) {
            bbxList.add(schentry.bbox);
        }
        this.bbxs = bbxList.toArray(new StructureBoundingBox[bbxList.size()]);
        this.initializeModifiers(data);
    }

    public ComplexScattered() {
    }

    protected StructureBoundingBox initBB(SchematicImporter schematic, int x, int y, int z, boolean isMainComponent) {
        int w = schematic.width - 1;
        int h = schematic.height - 1;
        int l = schematic.length - 1;
        if (isMainComponent) {
            int x0 = this.field_74885_f % 2 == 0 ? x + w : x + l;
            int z0 = this.field_74885_f % 2 == 0 ? z + l : z + w;
            return new StructureBoundingBox(x, y, z, x0, y + h, z0);
        }
        StructureBoundingBox b0 = this.mainComponent.bbox;
        int y0 = y + schematic.offsetY;
        int y1 = y + schematic.offsetY + h;
        switch (this.field_74885_f) {
            case 0: {
                return new StructureBoundingBox(x + schematic.offsetX, y0, z + schematic.offsetZ, x + w + schematic.offsetX, y1, z + l + schematic.offsetZ);
            }
            case 1: {
                int x0 = b0.func_78880_d() - (schematic.offsetZ + l) + x;
                int z0 = schematic.offsetX + z;
                return new StructureBoundingBox(x0, y0, z0, x0 + l, y1, z0 + w);
            }
            case 2: {
                int x0 = schematic.offsetX + x;
                int z0 = z + schematic.offsetZ;
                return new StructureBoundingBox(x0, y0, z0, x0 + w, y1, z0 + l);
            }
            case 3: {
                int x0 = schematic.offsetZ + x;
                int z0 = schematic.offsetX + z;
                return new StructureBoundingBox(x0, y0, z0, x0 + l, y1, z0 + w);
            }
        }
        return null;
    }

    public void initializeModifiers(StructureData data) {
        if (data.spawnCriteria != null) {
            for (SpecialParameters spawnParams : data.spawnCriteria) {
                try {
                    this.spawnCriteria.add((AbstractSpawnCriteria)SpecialParameters.createModifierFrom(spawnParams));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Error creating spawn criteria : " + e.getMessage());
                }
            }
        }
        if (data.groundHelper != null) {
            try {
                this.flatHelper = (AbstractGroundHelper)SpecialParameters.createModifierFrom(data.groundHelper);
                this.flatHelper.setStructure(this);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Error creating ground-helper : " + e.getMessage());
            }
        }
    }

    public void setEnableBboxCheck(boolean check) {
        this.doBBoxCheck = check;
    }

    public ComplexScattered addCriteria(AbstractSpawnCriteria criteria) {
        if (this.spawnCriteria == null) {
            this.spawnCriteria = new ArrayList(1);
        }
        this.spawnCriteria.add(criteria);
        return this;
    }

    public void addSpecialGenToAll(AbstractSpecialGen SPG) {
        this.mainComponent.addSpecialGenerator(SPG);
        for (SchematicEntry schentry : this.components) {
            schentry.addSpecialGenerator(SPG);
        }
    }

    public void setFlatSpawnHelper(AbstractGroundHelper helper) {
        this.flatHelper = helper;
    }

    public void removeCriteria(AbstractSpawnCriteria criteria) {
        if (this.spawnCriteria != null) {
            this.spawnCriteria.remove(criteria);
        }
    }

    public void refactorAt(int x, int y, int z) {
        StructureBoundingBox bbox = this.bbxs[0];
        int x1 = x - bbox.field_78897_a;
        int y1 = y - bbox.field_78895_b;
        int z1 = z - bbox.field_78896_c;
        for (int i = 0; i < this.bbxs.length; ++i) {
            bbox = this.bbxs[i];
            bbox.func_78886_a(x1, y1, z1);
        }
        this.field_74887_e.func_78886_a(x1, y1, z1);
    }

    public void refactorY(int y) {
        StructureBoundingBox bbox = this.bbxs[0];
        int y1 = y - bbox.field_78895_b;
        for (int i = 0; i < this.bbxs.length; ++i) {
            bbox = this.bbxs[i];
            bbox.func_78886_a(0, y1, 0);
        }
        this.field_74887_e.func_78886_a(0, y1, 0);
    }

    protected int func_151555_a(Block block, int par2) {
        return BlockRotation.setBlockRotation(this.field_74885_f, block, par2);
    }

    @Override
    public boolean generateImpl(World world, Random random) {
        this.worldObj = world;
        if (!this.forceGeneration && !this.canStructureFitAtCoords(world)) {
            return false;
        }
        System.out.println("Generating " + this.name + " @ " + this.field_74887_e.field_78897_a + ", " + this.field_74887_e.field_78896_c);
        this.func_74875_a(world, random, null);
        this.postGen(world, random);
        this.fixAllLighting(world);
        return true;
    }

    public boolean func_74875_a(World world, Random random, @Deprecated StructureBoundingBox bb) {
        if (!this.canStructureFitAtCoords(world)) {
            return false;
        }
        this.placeSchematic(world, this.mainComponent);
        for (SchematicEntry schentry : this.components) {
            this.placeSchematic(world, schentry);
        }
        return true;
    }

    protected void postGen(World world, Random random) {
        if (this.mainComponent.specialGens != null) {
            for (AbstractSpecialGen SPG : this.mainComponent.specialGens) {
                SPG.postGen(world, random, this.mainComponent);
            }
        }
        for (SchematicEntry schentry : this.components) {
            if (schentry.specialGens == null) continue;
            for (AbstractSpecialGen SPG : schentry.specialGens) {
                SPG.postGen(world, random, schentry);
            }
        }
    }

    private void placeSchematic(World world, SchematicEntry schentry) {
        SchematicImporter schem = schentry.schem;
        for (int x = 0; x < schem.width; ++x) {
            for (int z = 0; z < schem.length; ++z) {
                for (int y = 0; y < schem.height; ++y) {
                    try {
                        BlockEntry be = schem.blockEntries[x][y][z];
                        this.placeBlockAtCurrentPosition(world, be.block, this.func_151555_a(be.block, be.meta), x, y, z, schentry);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected void func_151550_a(World world, Block block, int meta, int x, int y, int z, StructureBoundingBox bbox) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ComplexScattered should not call this method! use placeBlockAtCurrentPosition(World, int, int, int, int, int, SCHEMATICENTRY) instead!");
    }

    protected void placeBlockAtCurrentPosition(World world, Block block, int meta, int x, int y, int z, SchematicEntry schentry) {
        int x0 = this.getXWithOffset(x, z, schentry.bbox);
        int y0 = this.getYWithOffset(y, schentry.bbox);
        int z0 = this.getZWithOffset(x, z, schentry.bbox);
        BlockEntry blockEntry = new BlockEntry(block, meta);
        boolean flag = true;
        if (schentry.specialGens != null) {
            for (AbstractSpecialGen SPG : schentry.specialGens) {
                if (SPG.doFilter(schentry, x0, y0, z0, blockEntry)) continue;
                flag = false;
            }
        }
        if (blockEntry.block instanceof BlockHelper.UtilBlock) {
            return;
        }
        if (flag) {
            world.func_147465_d(x0, y0, z0, blockEntry.block, blockEntry.meta, 2);
        }
    }

    @Deprecated
    protected int func_74865_a(int par1, int par2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot use this method with " + this.getClass() + " because this class uses multiple bounding boxes.");
    }

    @Deprecated
    protected int func_74862_a(int par1) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot use this method with " + this.getClass() + " because this class uses multiple bounding boxes.");
    }

    @Deprecated
    protected int func_74873_b(int par1, int par2) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Cannot use this method with " + this.getClass() + " because this class uses multiple bounding boxes.");
    }

    public int getXWithOffset(int localX, int localZ, StructureBoundingBox bbox) {
        switch (this.field_74885_f) {
            case 0: 
            case 2: {
                return bbox.field_78897_a + localX;
            }
            case 1: {
                return bbox.field_78893_d - localZ;
            }
            case 3: {
                return bbox.field_78897_a + localZ;
            }
        }
        return localX;
    }

    public int getYWithOffset(int localY, StructureBoundingBox bbox) {
        return this.field_74885_f == -1 ? localY : localY + bbox.field_78895_b;
    }

    public int getZWithOffset(int localX, int localZ, StructureBoundingBox bbox) {
        switch (this.field_74885_f) {
            case 0: {
                return bbox.field_78896_c + localZ;
            }
            case 1: 
            case 3: {
                return bbox.field_78896_c + localX;
            }
            case 2: {
                return bbox.field_78892_f - localZ;
            }
        }
        return localZ;
    }

    @Override
    public boolean canStructureFitAtCoords(World world) {
        if (this.flatHelper != null && !this.flatHelper.modHeightCoord(world)) {
            this.statusCode = -2;
            return false;
        }
        if (this.doBBoxCheck) {
            for (int i = 0; i < this.bbxs.length; ++i) {
                if (StructureStorage.canFitWithoutOverlap(world, this.bbxs[i])) continue;
                this.statusCode = -1;
                return false;
            }
        }
        for (AbstractSpawnCriteria criteria : this.spawnCriteria) {
            if (criteria.canSpawnHere(world, this)) continue;
            this.statusCode = criteria.statusCode;
            return false;
        }
        return true;
    }

    protected void fixAllLighting(World world) {
        for (StructureBoundingBox bb : this.bbxs) {
            WorldHelper.fixLighting(world, bb);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("Name", this.name);
        nbt.func_74782_a("BBX", (NBTBase)this.field_74887_e.func_151535_h());
        NBTTagList bboxList = new NBTTagList();
        for (int i = 0; i < this.bbxs.length; ++i) {
            bboxList.func_74742_a((NBTBase)this.bbxs[i].func_151535_h());
        }
        nbt.func_74782_a("BBXS", (NBTBase)bboxList);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.name = nbt.func_74779_i("Name");
        this.field_74887_e = new StructureBoundingBox(nbt.func_74759_k("BBX"));
        NBTTagList bboxList = nbt.func_150295_c("BBXS", 10);
        this.bbxs = new StructureBoundingBox[bboxList.func_74745_c()];
        for (int i = 0; i < bboxList.func_74745_c(); ++i) {
            this.bbxs[i] = new StructureBoundingBox(bboxList.func_150306_c(i));
        }
    }

    @Override
    public void setWorld(World worldObj) {
        this.worldObj = worldObj;
    }
}

