/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure.generation;

import com.pixelmonmod.pixelmon.blocks.BlockEntry;
import com.pixelmonmod.pixelmon.structure.SchematicImporter;
import com.pixelmonmod.pixelmon.structure.StructureData;
import com.pixelmonmod.pixelmon.structure.filter.TileFilter;
import com.pixelmonmod.pixelmon.structure.generation.BlockRotation;
import com.pixelmonmod.pixelmon.structure.generation.StructureScattered;
import com.pixelmonmod.pixelmon.util.helpers.BlockHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class GeneralScattered
extends StructureScattered {
    protected SchematicImporter s;
    protected StructureData sd;
    protected String name;
    private boolean forceGeneration;

    public GeneralScattered(Random par1Random, int par2, int par3, int par4, SchematicImporter schematic, StructureData structureData, boolean doRotation, boolean forceGeneration) {
        super(par1Random, par2, par3, par4, schematic.width, schematic.height, schematic.length, doRotation);
        this.forceGeneration = forceGeneration;
        this.s = schematic;
        this.sd = structureData;
        this.name = structureData.simpleName;
    }

    public boolean func_74875_a(World world, Random par2Random, StructureBoundingBox bb) {
        if (!this.forceGeneration && !this.canStructureFitAtCoords(world)) {
            return false;
        }
        for (int x = 0; x < this.s.width; ++x) {
            for (int z = 0; z < this.s.length; ++z) {
                for (int y = 0; y < this.s.height; ++y) {
                    BlockEntry blockEntry = this.s.blockEntries[x][y][z];
                    try {
                        if (blockEntry.block == BlockHelper.utilBlock0 || blockEntry.block == BlockHelper.utilBlock1) continue;
                        this.func_151550_a(world, blockEntry.block, this.func_151555_a(blockEntry.block, blockEntry.meta), x, y, z, bb);
                        if (this.sd.tileFilters.size() <= 0) continue;
                        for (TileFilter tf : this.sd.tileFilters) {
                            tf.checkTileEntity(world, blockEntry.block, this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
                        }
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage());
                    }
                }
            }
        }
        for (int i = 0; i < this.s.tileEntities.func_74745_c(); ++i) {
            try {
                NBTTagCompound teTag = this.s.tileEntities.func_150305_b(i);
                int x = teTag.func_74762_e("x");
                int y = teTag.func_74762_e("y");
                int z = teTag.func_74762_e("z");
                TileEntity te = world.func_147438_o(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
                if (te == null) continue;
                teTag.func_74768_a("x", this.func_74865_a(x, z));
                teTag.func_74768_a("y", this.func_74862_a(y));
                teTag.func_74768_a("z", this.func_74873_b(x, z));
                te.func_145839_a(teTag);
                ((WorldServer)world).func_73040_p().func_151250_a(this.func_74865_a(x, z), this.func_74862_a(y), this.func_74873_b(x, z));
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return true;
    }

    @Override
    protected boolean canStructureFitAtCoords(World world) {
        int blockHeight;
        int i;
        int maxHeight = -1;
        int minHeight = -1;
        for (i = 0; i < 2; ++i) {
            int ix = i == 0 ? this.field_74887_e.field_78897_a : this.field_74887_e.field_78893_d;
            for (int iz = this.field_74887_e.field_78896_c; iz <= this.field_74887_e.field_78892_f; ++iz) {
                blockHeight = this.getTopSolidBlock(world, ix, iz);
                if (maxHeight == -1 || blockHeight > maxHeight) {
                    maxHeight = blockHeight;
                    continue;
                }
                if (minHeight != -1 && blockHeight >= minHeight) continue;
                minHeight = blockHeight;
            }
        }
        for (i = 0; i < 2; ++i) {
            int iz = i == 0 ? this.field_74887_e.field_78896_c : this.field_74887_e.field_78892_f;
            for (int ix = this.field_74887_e.field_78897_a; ix <= this.field_74887_e.field_78893_d; ++ix) {
                blockHeight = this.getTopSolidBlock(world, ix, iz);
                if (maxHeight == -1 || blockHeight > maxHeight) {
                    maxHeight = blockHeight;
                    continue;
                }
                if (minHeight != -1 && blockHeight >= minHeight) continue;
                minHeight = blockHeight;
            }
        }
        if (maxHeight - minHeight > 4) {
            return false;
        }
        this.field_74887_e.func_78886_a(0, minHeight - this.sd.depth - this.field_74887_e.field_78895_b + 1, 0);
        return true;
    }

    protected int func_151555_a(Block block, int par2) {
        return BlockRotation.setBlockRotation(this.field_74885_f, block, par2);
    }

    @Override
    public boolean generateImpl(World world, Random random) {
        return this.func_74875_a(world, random, this.field_74887_e);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

