/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure.generation;

import com.pixelmonmod.pixelmon.structure.StructureRegistry;
import com.pixelmonmod.pixelmon.structure.generation.AbstractStructureModifier;
import com.pixelmonmod.pixelmon.structure.generation.criteria.AbstractSpawnCriteria;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SpecialParameters {
    public static final int FLAG_NONE = 0;
    public static final int FLAG_ARRAY = 1;
    public final Class<? extends AbstractStructureModifier> modifierClass;
    public final String[] parameters;

    public SpecialParameters(String name, String[] lines) {
        Class<? extends AbstractStructureModifier> clazz = StructureRegistry.getModifierTypeByName(name);
        if (clazz == null) {
            String message = "Could not find the SpecialGen type \"" + name + "\"";
            message = message + "\nThe valid names (non-case-sensitive) for SpecialGens are as follows:";
            for (String s : StructureRegistry.getAllModifierNames()) {
                message = message + "\n" + s;
            }
            throw new IllegalArgumentException(message);
        }
        this.modifierClass = clazz;
        this.parameters = this.filterParams(lines);
    }

    public String[] filterParams(String[] lines) {
        for (int i = 0; i < lines.length; ++i) {
            lines[i] = CommonHelper.textInQuotes(lines[i]).replaceAll("\\s", "");
        }
        return lines;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.hashCode() + String.format("(%s)%s", this.modifierClass.getSimpleName(), Arrays.toString(this.parameters));
    }

    public static AbstractStructureModifier createModifierFrom(SpecialParameters sp) {
        Class<? extends AbstractStructureModifier> clazz = null;
        try {
            clazz = sp.modifierClass;
        }
        catch (NullPointerException e) {
            throw new NullPointerException("Check to make the variable is actually declared.");
        }
        Exception error = null;
        try {
            Constructor<? extends AbstractStructureModifier> stringArrayCons = clazz.getConstructor(String[].class);
            AbstractStructureModifier result = stringArrayCons.newInstance(new Object[]{sp.parameters});
            if (result instanceof AbstractSpawnCriteria) {
                AbstractSpawnCriteria criteria = (AbstractSpawnCriteria)result;
                criteria.statusCode = StructureRegistry.getStatusCodeFor(criteria.getClass());
            }
            return result;
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException("The \"String[]\" constuctor, REQUIRED by the contract of AbstractStructureModifier, could not be found in " + clazz + ".");
        }
        catch (SecurityException e) {
            error = e;
        }
        catch (InstantiationException e) {
            error = e;
        }
        catch (IllegalAccessException e) {
            error = e;
        }
        catch (IllegalArgumentException e) {
            error = e;
        }
        catch (InvocationTargetException e) {
            error = e;
        }
        throw new RuntimeException("Error creating modifier with " + sp, error);
    }

    public static String demandValue(String paramName, String[] parameters, int flag) {
        String result = SpecialParameters.getValue(paramName, parameters, flag);
        if (result == null) {
            throw new IllegalArgumentException("The parameter \"" + paramName + "\" could not be found.");
        }
        return result;
    }

    public static String getValue(String paramName, String[] parameters, int flag) {
        String regex = "(" + paramName + "=)(.*)";
        Pattern pat = Pattern.compile(regex, 2);
        String par = null;
        for (int i = 0; i < parameters.length; ++i) {
            Matcher mat = pat.matcher(parameters[i]);
            if (!mat.matches()) continue;
            par = mat.replaceAll("$2");
            break;
        }
        if (par == null) {
            return null;
        }
        if (flag == 1) {
            par = par.replaceAll("(<)(.*)(>)", "$2");
        }
        return par;
    }
}

