/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure.generation;

import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.storage.structure.IStructureAwareness;
import com.pixelmonmod.pixelmon.storage.structure.StructureStorage;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;

public abstract class StructureScattered
extends StructureComponent
implements IStructureAwareness {
    public int scatteredFeatureSizeX;
    public int scatteredFeatureSizeY;
    public int scatteredFeatureSizeZ;
    protected int field_74936_d = -1;
    protected boolean shouldSave;

    protected StructureScattered(Random par1Random, int x, int y, int z, int width, int height, int length, boolean doRotation) {
        this(par1Random, x, y, z, width, height, length, false, doRotation);
    }

    protected StructureScattered(Random par1Random, int x, int y, int z, int width, int height, int length, boolean save, boolean doRotation) {
        super(0);
        this.scatteredFeatureSizeX = width;
        this.scatteredFeatureSizeY = height;
        this.scatteredFeatureSizeZ = length;
        this.field_74885_f = doRotation ? par1Random.nextInt(4) : 0;
        switch (this.field_74885_f) {
            case 0: 
            case 2: {
                this.field_74887_e = new StructureBoundingBox(x, y, z, x + width - 1, y + height - 1, z + length - 1);
                break;
            }
            default: {
                this.field_74887_e = new StructureBoundingBox(x, y, z, x + length - 1, y + height - 1, z + width - 1);
            }
        }
        this.shouldSave = save;
    }

    protected StructureScattered() {
    }

    public abstract String getName();

    public void setShouldSave(boolean save) {
        this.shouldSave = save;
    }

    public final boolean generate(World world, Random random) {
        boolean generated = this.generateImpl(world, random);
        if (generated && this.shouldSave) {
            StructureStorage.addStructure(this, world);
        }
        return generated;
    }

    public abstract boolean generateImpl(World var1, Random var2);

    protected abstract boolean canStructureFitAtCoords(World var1);

    public int getTopSolidBlock(World world, int par1, int par2) {
        Chunk chunk = world.func_72938_d(par1, par2);
        par1 &= 0xF;
        par2 &= 0xF;
        for (int k = chunk.func_76625_h() + 15; k > 0; --k) {
            Block block = chunk.func_150810_a(par1, k, par2);
            if (block == Blocks.field_150350_a || !block.func_149688_o().func_76230_c() || block.func_149688_o() == Material.field_151584_j || block.func_149688_o() == Material.field_151575_d || block.isFoliage((IBlockAccess)world, par1, k, par2)) continue;
            return k;
        }
        return -1;
    }

    public void fixLighting(World world) {
        WorldHelper.fixLighting(world, this.field_74887_e);
    }

    @Override
    public StructureBoundingBox[] getBounds() {
        return new StructureBoundingBox[]{this.field_74887_e};
    }

    protected final void func_143012_a(NBTTagCompound nbttagcompound) {
        this.writeToNBT(nbttagcompound);
    }

    protected final void func_143011_b(NBTTagCompound nbttagcompound) {
        this.readFromNBT(nbttagcompound);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("BBX", (NBTBase)this.field_74887_e.func_151535_h());
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.field_74887_e = new StructureBoundingBox(nbt.func_74759_k("BBX"));
    }

    @Override
    public void setWorld(World worldObj) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDirty() {
        if (!this.shouldSave) return false;
        this.shouldSave = false;
        if (false) return false;
        return true;
    }
}

