/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure.generation.criteria;

import com.pixelmonmod.pixelmon.structure.generation.ComplexScattered;
import com.pixelmonmod.pixelmon.structure.generation.SpecialParameters;
import com.pixelmonmod.pixelmon.structure.generation.criteria.AbstractSpawnCriteria;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class SpawnCriteriaFlatArea
extends AbstractSpawnCriteria {
    public final int maxYVariation;
    public int skip = 0;

    public SpawnCriteriaFlatArea(String[] params) {
        super(params);
        this.maxYVariation = Integer.parseInt(SpecialParameters.demandValue("MaxYVariation", params, 0));
        String skipParam = SpecialParameters.getValue("Skip", params, 0);
        this.skip = skipParam == null ? 0 : Integer.parseInt(skipParam);
    }

    @Override
    public boolean canSpawnHere(World world, ComplexScattered structure) {
        StructureBoundingBox bb = structure.mainComponent.bbox;
        int maxVal = -1;
        int minVal = 999;
        for (StructureBoundingBox bbox : structure.bbxs) {
            int i = bbox.field_78897_a;
            while (i + 1 + this.skip <= bbox.field_78893_d) {
                int j = bbox.field_78896_c;
                while (j + 1 + this.skip <= bbox.field_78892_f) {
                    int height = world.func_72825_h(i, j);
                    if (height > maxVal) {
                        maxVal = height;
                    }
                    if (height < minVal) {
                        minVal = height;
                    }
                    if (maxVal - minVal > this.maxYVariation) {
                        return false;
                    }
                    j += 1 + this.skip;
                }
                i += 1 + this.skip;
            }
        }
        return true;
    }
}

