/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure.generation.criteria;

import com.pixelmonmod.pixelmon.storage.structure.IStructureAwareness;
import com.pixelmonmod.pixelmon.storage.structure.StructureStorage;
import com.pixelmonmod.pixelmon.structure.generation.ComplexScattered;
import com.pixelmonmod.pixelmon.structure.generation.SpecialParameters;
import com.pixelmonmod.pixelmon.structure.generation.criteria.AbstractSpawnCriteria;
import java.util.ArrayList;
import net.minecraft.world.World;

public class SpawnCriteriaMinDistance
extends AbstractSpawnCriteria {
    String[] structureAvoids;
    Class<? extends IStructureAwareness>[] otherAvoids;
    public final int minDistance;

    public SpawnCriteriaMinDistance(String[] params) {
        super(params);
        this.minDistance = Integer.parseInt(SpecialParameters.demandValue("MinDistance", params, 0));
        String[] distanceParams = SpecialParameters.demandValue("Structures", params, 1).split(",");
        ArrayList<String> l0 = new ArrayList<String>();
        ArrayList<Class<? extends IStructureAwareness>> l1 = new ArrayList<Class<? extends IStructureAwareness>>();
        for (String s : distanceParams) {
            if (s.matches("(\\()(.*)(\\))")) {
                l0.add(s.replaceAll("(\\()(.*)(\\))", "$2"));
                continue;
            }
            l1.add(StructureStorage.demandClassNamed(s));
        }
        this.structureAvoids = l0.isEmpty() ? null : l0.toArray(new String[l0.size()]);
        this.otherAvoids = l1.isEmpty() ? null : l1.toArray(new Class[l1.size()]);
    }

    @Override
    public boolean canSpawnHere(World world, ComplexScattered structure) {
        int x = structure.mainComponent.bbox.func_78881_e();
        int y = structure.mainComponent.bbox.func_78879_f();
        int z = structure.mainComponent.bbox.func_78891_g();
        if (this.structureAvoids != null) {
            for (String s : this.structureAvoids) {
                if (StructureStorage.isSafeDistanceToNearestNamed(world, s, x, y, z, this.minDistance, true, true, true, true)) continue;
                return false;
            }
        }
        if (this.otherAvoids != null) {
            for (Class<? extends IStructureAwareness> clazz : this.otherAvoids) {
                if (StructureStorage.isSafeDistanceToNearest(world, clazz, x, y, z, this.minDistance, true, true, true, true)) continue;
                return false;
            }
        }
        return true;
    }
}

