/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure.generation.criteria;

import com.pixelmonmod.pixelmon.storage.structure.IStructureAwareness;
import com.pixelmonmod.pixelmon.storage.structure.StructureStorage;
import com.pixelmonmod.pixelmon.structure.generation.ComplexScattered;
import com.pixelmonmod.pixelmon.structure.generation.SpecialParameters;
import com.pixelmonmod.pixelmon.structure.generation.criteria.AbstractSpawnCriteria;
import net.minecraft.world.World;

public class SpawnCriteriaNoOverlap
extends AbstractSpawnCriteria {
    public final boolean chunkMode;
    public final Class<? extends IStructureAwareness>[] avoidOnly;

    public SpawnCriteriaNoOverlap(String[] params) {
        super(params);
        this.chunkMode = Boolean.parseBoolean(SpecialParameters.demandValue("NoStructuresInSameChunk", params, 0));
        String[] structureClassNames = SpecialParameters.demandValue("StructureTypes", params, 1).split(",");
        this.avoidOnly = new Class[structureClassNames.length];
        for (int i = 0; i < structureClassNames.length; ++i) {
            this.avoidOnly[i] = StructureStorage.demandClassNamed(structureClassNames[i]);
        }
    }

    @Override
    public boolean canSpawnHere(World world, ComplexScattered structure) {
        for (int i = 0; i < structure.bbxs.length; ++i) {
            if (!(!this.chunkMode ? !StructureStorage.canFitWithoutOverlap(world, structure.bbxs[i], this.avoidOnly) : !StructureStorage.canFitWithoutChunkOverlap(world, structure.bbxs[i], this.avoidOnly))) continue;
            return false;
        }
        return true;
    }
}

