/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure.generation.criteria;

import com.pixelmonmod.pixelmon.structure.SchematicEntry;
import com.pixelmonmod.pixelmon.structure.SchematicImporter;
import com.pixelmonmod.pixelmon.structure.generation.ComplexScattered;
import com.pixelmonmod.pixelmon.structure.generation.SpecialParameters;
import com.pixelmonmod.pixelmon.structure.generation.criteria.AbstractSpawnCriteria;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;

public class SpawnCriteriaNotInWater
extends AbstractSpawnCriteria {
    public final double waterLimit;
    public final int yOffset;

    public SpawnCriteriaNotInWater(String[] params) {
        super(params);
        this.waterLimit = Double.parseDouble(SpecialParameters.demandValue("WaterPercentageLimit", params, 0));
        this.yOffset = Integer.parseInt(SpecialParameters.demandValue("YOffset", params, 0));
    }

    @Override
    public boolean canSpawnHere(World world, ComplexScattered structure) {
        double totalWaters = 0.0;
        double totalSpaces = 0.0;
        SchematicImporter schem = structure.mainComponent.schem;
        for (int i = 0; i < schem.width; ++i) {
            for (int j = 0; j < schem.length; ++j) {
                int z;
                int y;
                if (schem.blockEntries[i][0][j].block.func_149688_o() == Material.field_151579_a) continue;
                int x = structure.getXWithOffset(i, j, structure.mainComponent.bbox);
                Block bl = world.func_147439_a(x, y = structure.mainComponent.bbox.field_78895_b + this.yOffset, z = structure.getZWithOffset(i, j, structure.mainComponent.bbox));
                if (bl == Blocks.field_150355_j) {
                    totalWaters += 1.0;
                }
                totalSpaces += 1.0;
            }
        }
        if (totalWaters / totalSpaces > this.waterLimit) {
            return false;
        }
        for (SchematicEntry schentry : structure.components) {
            schem = schentry.schem;
            for (int i = 0; i < schem.width; ++i) {
                for (int j = 0; j < schem.length; ++j) {
                    int z;
                    int y;
                    if (schem.blockEntries[i][0][j].block.func_149688_o() == Material.field_151579_a) continue;
                    int x = structure.getXWithOffset(i, j, schentry.bbox);
                    Block bl = world.func_147439_a(x, y = schentry.bbox.field_78895_b + this.yOffset, z = structure.getZWithOffset(i, j, schentry.bbox));
                    if (bl == Blocks.field_150355_j) {
                        totalWaters += 1.0;
                    }
                    totalSpaces += 1.0;
                }
            }
            if (!(totalWaters / totalSpaces > this.waterLimit)) continue;
            return false;
        }
        return true;
    }
}

