/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure.generation.criteria;

import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.structure.generation.ComplexScattered;
import com.pixelmonmod.pixelmon.structure.generation.SpecialParameters;
import com.pixelmonmod.pixelmon.structure.generation.criteria.AbstractSpawnCriteria;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class SpawnCriteriaSpecificBiome
extends AbstractSpawnCriteria {
    protected final BiomeGenBase theBiome;
    protected BiomeGenBase[] alsoAllowedBiomes;
    protected int extraSpace;

    public SpawnCriteriaSpecificBiome(BiomeGenBase biome, int extraSpace, BiomeGenBase ... alsoAllowedBiomes) {
        super(null);
        this.theBiome = biome;
        this.extraSpace = extraSpace;
        this.alsoAllowedBiomes = alsoAllowedBiomes;
    }

    public SpawnCriteriaSpecificBiome(String[] params) {
        super(params);
        this.theBiome = WorldHelper.demandBiome(SpecialParameters.demandValue("Biome", params, 0));
        String extraSpaceParam = SpecialParameters.getValue("ExtraSpace", params, 0);
        this.extraSpace = extraSpaceParam == null ? 0 : Integer.parseInt(extraSpaceParam);
        String extraBiomes = SpecialParameters.getValue("AlsoAllow", params, 1);
        if (extraBiomes != null) {
            String[] extraBiomeParams = extraBiomes.split(",");
            this.alsoAllowedBiomes = new BiomeGenBase[extraBiomeParams.length];
            for (int i = 0; i < extraBiomeParams.length; ++i) {
                this.alsoAllowedBiomes[i] = WorldHelper.demandBiome(extraBiomeParams[i]);
            }
        }
    }

    @Override
    public boolean canSpawnHere(World world, ComplexScattered structure) {
        for (StructureBoundingBox bbox : structure.bbxs) {
            if (WorldHelper.canFitWithinBiome(world, this.theBiome, this.alsoAllowedBiomes, bbox.field_78897_a - this.extraSpace, bbox.field_78896_c - this.extraSpace, bbox.func_78883_b() + this.extraSpace, bbox.func_78880_d() + this.extraSpace, 0)) continue;
            return false;
        }
        return true;
    }
}

