/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure.generation.groundhelper;

import com.pixelmonmod.pixelmon.structure.generation.SpecialParameters;
import com.pixelmonmod.pixelmon.structure.generation.groundhelper.AbstractGroundHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class GroundHelperFlatArea
extends AbstractGroundHelper {
    public final int maxYVariation;
    public int skip = 0;

    public GroundHelperFlatArea(String[] params) {
        super(params);
        this.maxYVariation = Integer.parseInt(SpecialParameters.demandValue("MaxYVariation", params, 0));
        String skipParam = SpecialParameters.getValue("Skip", params, 0);
        this.skip = skipParam == null ? 0 : Integer.parseInt(skipParam);
    }

    @Override
    public boolean modHeightCoord(World world) {
        StructureBoundingBox bb = this.structure.mainComponent.bbox;
        int maxVal = -1;
        int minVal = 999;
        for (StructureBoundingBox bbox : this.structure.bbxs) {
            int i = bbox.field_78897_a;
            while (i + 1 + this.skip <= bbox.field_78893_d) {
                int j = bbox.field_78896_c;
                while (j + 1 + this.skip <= bbox.field_78892_f) {
                    int height = world.func_72825_h(i, j);
                    if (height > maxVal) {
                        maxVal = height;
                    }
                    if (height < minVal) {
                        minVal = height;
                    }
                    if (maxVal - minVal > this.maxYVariation) {
                        return false;
                    }
                    j += 1 + this.skip;
                }
                i += 1 + this.skip;
            }
        }
        this.structure.refactorAt(bb.field_78897_a, minVal, bb.field_78896_c);
        return true;
    }
}

