/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure.generation.specialgen;

import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.blocks.BlockEntry;
import com.pixelmonmod.pixelmon.structure.SchematicEntry;
import com.pixelmonmod.pixelmon.structure.generation.SpecialParameters;
import com.pixelmonmod.pixelmon.structure.generation.specialgen.AbstractSpecialGen;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.Link2D;
import com.pixelmonmod.pixelmon.util.helpers.BlockHelper;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenVines;
import net.minecraftforge.common.util.ForgeDirection;

public class SpecialGenVines
extends AbstractSpecialGen {
    protected EntryList2D<Integer> detectedPoints = new EntryList2D();
    protected Random random;
    protected final int y;
    protected final int chance;
    public Block[] onlyAtBlocks;

    public SpecialGenVines(String[] params) throws RuntimeException {
        super(params);
        this.y = Integer.parseInt(SpecialParameters.demandValue("Y", params, 0));
        this.chance = Integer.parseInt(SpecialParameters.demandValue("Denominator", params, 0));
        this.random = new Random();
        String onlyat = SpecialParameters.getValue("atBlocks", params, 1);
        Object ids = null;
        if (onlyat != null) {
            String[] only = onlyat.split(",");
            this.onlyAtBlocks = new Block[only.length];
            for (int i = 0; i < only.length; ++i) {
                this.onlyAtBlocks[i] = BlockHelper.demandBlock(only[i]);
            }
        }
    }

    public SpecialGenVines(int y, int chance) {
        super(null);
        this.y = y;
        this.chance = chance;
        this.random = new Random();
    }

    @Override
    public boolean doFilter(SchematicEntry schentry, int x, int y, int z, BlockEntry blockEntry) {
        boolean flag;
        if (blockEntry.block.func_149688_o() == Material.field_151579_a) {
            return true;
        }
        boolean bl = flag = this.onlyAtBlocks == null || CommonHelper.contains(this.onlyAtBlocks, blockEntry.block);
        if (flag && this.random.nextInt(this.chance) == 0) {
            ForgeDirection d = WorldHelper.NWSE[this.random.nextInt(4)];
            int i = x + d.offsetX;
            int j = z + d.offsetZ;
            this.detectedPoints.addValue(i, j, 64);
        }
        return true;
    }

    @Override
    public void postGen(World world, Random random, SchematicEntry schentry) {
        WorldGenVines vines = new WorldGenVines();
        for (Link2D link2D : this.detectedPoints) {
            vines.func_76484_a(world, random, link2D.x, ((Integer)link2D.value).intValue(), link2D.z);
        }
    }
}

