/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.structure.worldGen;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.api.events.PixelmonStructureGenerationEvent;
import com.pixelmonmod.pixelmon.structure.StructureData;
import com.pixelmonmod.pixelmon.structure.StructureRegistry;
import com.pixelmonmod.pixelmon.structure.generation.StructureScattered;
import com.pixelmonmod.pixelmon.worldGeneration.battleDimension.BattleDimWorldProvider;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;

public class WorldGenScatteredFeature
extends MapGenScatteredFeature
implements IWorldGenerator {
    private static boolean hasGenerated = false;
    private int maxDistanceBetweenScatteredFeatures = 16;
    private int minDistanceBetweenScatteredFeatures = 1;

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (random.nextInt(6) != 1) {
            return;
        }
        int xPos = random.nextInt(16) + chunkX * 16;
        int yPos = 64;
        int zPos = random.nextInt(16) + chunkZ * 16;
        StructureData structure = StructureRegistry.getScatteredStructureFromBiome(random, world.func_72807_a(xPos, zPos));
        if (structure == null) {
            return;
        }
        StructureScattered s = structure.createStructure(random, xPos, yPos, zPos, true, false);
        if (this.canSpawnStructureAtCoords(world, s, structure, xPos, yPos, zPos)) {
            s.generate(world, random);
            if (structure.hasPokemon) {
                // empty if block
            }
        }
    }

    protected boolean canSpawnStructureAtCoords(World world, StructureScattered s, StructureData structureData, int x, int y, int z) {
        if (RandomHelper.getRandomNumberBetween(0, 40) == 0 && world.field_73011_w.field_76574_g != BattleDimWorldProvider.DimID) {
            PixelmonStructureGenerationEvent generationEvent = new PixelmonStructureGenerationEvent(world, s, structureData, x, y, z);
            Pixelmon.EVENT_BUS.post((Event)generationEvent);
            if (!generationEvent.isCanceled()) {
                return true;
            }
        }
        return false;
    }
}

