/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util;

import com.google.common.collect.TreeMultimap;
import com.pixelmonmod.pixelmon.util.BooleanOp;
import com.pixelmonmod.pixelmon.util.IList2D;
import com.pixelmonmod.pixelmon.util.INbt;
import com.pixelmonmod.pixelmon.util.Link2D;
import com.pixelmonmod.pixelmon.util.MinimalList2D;
import com.pixelmonmod.pixelmon.util.NBTTools;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;
import java.awt.Color;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public abstract class AbstractList2D<T>
implements IList2D<T> {
    protected int elements = 0;
    protected Integer minX = null;
    protected Integer minZ = null;
    protected Integer maxX = null;
    protected Integer maxZ = null;
    protected Double minVal = null;
    protected Double maxVal = null;
    protected Class valuesClass;
    protected TreeMultimap<Integer, Integer> xToZ = TreeMultimap.create();
    protected TreeMultimap<Integer, Integer> zToX = TreeMultimap.create();
    protected ArrayList<T> valuesList = new ArrayList();

    @Override
    public abstract AbstractList2D createNew();

    @Override
    public abstract T get(int var1, int var2);

    protected abstract T removeImpl(int var1, int var2);

    protected abstract void putValue(int var1, int var2, T var3);

    public abstract Set<T> toSet();

    public abstract List<T> toList();

    @Override
    public void addValue(int x, int z, T value) {
        if (this.minX == null || x < this.minX) {
            this.minX = x;
        }
        if (this.maxX == null || x > this.maxX) {
            this.maxX = x;
        }
        if (this.minZ == null || z < this.minZ) {
            this.minZ = z;
        }
        if (this.maxZ == null || z > this.maxZ) {
            this.maxZ = z;
        }
        if (value instanceof Number) {
            double numValue = ((Number)value).doubleValue();
            if (this.minVal == null || numValue < this.minVal) {
                this.minVal = numValue;
            }
            if (this.maxVal == null || numValue > this.maxVal) {
                this.maxVal = numValue;
            }
        }
        if (!this.contains(x, z)) {
            ++this.elements;
        } else {
            this.valuesList.remove(this.get(x, z));
        }
        this.xToZ.put((Object)x, (Object)z);
        this.zToX.put((Object)z, (Object)x);
        this.valuesList.add(value);
        this.putValue(x, z, value);
    }

    @Override
    public T remove(int x, int z) {
        if (this.contains(x, z)) {
            --this.elements;
            this.valuesList.remove(this.get(x, z));
        }
        this.xToZ.remove((Object)x, (Object)z);
        this.zToX.remove((Object)z, (Object)x);
        if (this.xToZ.get((Object)x).isEmpty()) {
            this.xToZ.removeAll((Object)x);
        }
        if (this.zToX.get((Object)z).isEmpty()) {
            this.zToX.removeAll((Object)z);
        }
        return this.removeImpl(x, z);
    }

    public TreeSet<Integer> xList() {
        return new TreeSet<Integer>(this.xToZ.keySet());
    }

    public TreeSet<Integer> zList() {
        return new TreeSet<Integer>(this.zToX.keySet());
    }

    public TreeSet<Integer> xList(int z) {
        return new TreeSet<Integer>(this.zToX.get((Object)z));
    }

    public TreeSet<Integer> zList(int x) {
        return new TreeSet<Integer>(this.xToZ.get((Object)x));
    }

    public Integer minX() {
        return this.minX;
    }

    public Integer midX() {
        return this.minX == null ? null : Integer.valueOf((this.maxX - this.minX) / 2);
    }

    public Integer maxX() {
        return this.maxX;
    }

    public Integer minZ() {
        return this.minZ;
    }

    public Integer midZ() {
        return this.minZ == null ? null : Integer.valueOf((this.maxZ - this.minZ) / 2);
    }

    public Integer maxZ() {
        return this.maxZ;
    }

    public Integer rangeX() {
        return this.xList().size();
    }

    public Integer rangeZ() {
        return this.zList().size();
    }

    public Double minVal() {
        return this.minVal;
    }

    public Double maxVal() {
        return this.maxVal;
    }

    public int size() {
        return this.elements;
    }

    public static int[] getBounds(AbstractList2D ... lists) {
        int xMin = 0;
        int xMax = 0;
        int zMin = 0;
        int zMax = 0;
        for (AbstractList2D list : lists) {
            if (list.minX != null && list.minX < xMin) {
                xMin = list.minX;
            }
            if (list.maxX != null && list.maxX > xMax) {
                xMax = list.maxX;
            }
            if (list.minZ != null && list.minZ < zMin) {
                zMin = list.minZ;
            }
            if (list.maxZ == null || list.maxZ <= zMax) continue;
            zMax = list.maxZ;
        }
        return new int[]{xMin, zMin, xMax, zMax};
    }

    @Override
    public boolean contains(int x, int z) {
        return this.xToZ.containsEntry((Object)x, (Object)z);
    }

    public boolean contains(T value) {
        return this.valuesList.contains(value);
    }

    public boolean isntNull(int x, int z) {
        return this.get(x, z) != null;
    }

    public boolean containsX(int x) {
        return this.xToZ.containsKey((Object)x);
    }

    public boolean containsZ(int z) {
        return this.zToX.containsKey((Object)z);
    }

    public boolean isEmpty() {
        return this.elements == 0;
    }

    public boolean overlaps(AbstractList2D another) {
        for (int i : this.xList()) {
            for (int j : this.zList(i)) {
                if (!another.contains(i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public void addRect(int x, int z, int width, int length, T value, boolean overwrite) {
        int dx = Integer.signum(width);
        int dz = Integer.signum(length);
        for (int i = 0; i != width; i += dx) {
            for (int j = 0; j != length; j += dz) {
                if (!overwrite && this.contains(i, j)) continue;
                this.addValue(x + i, z + j, value);
            }
        }
    }

    public void addRectButSkip(int x, int z, int width, int length, T value, T noOverwrite) {
        int dx = Integer.signum(width);
        int dz = Integer.signum(length);
        for (int i = 0; i != width; i += dx) {
            for (int j = 0; j != length; j += dz) {
                if (noOverwrite.equals(this.get(x + i, z + j))) continue;
                this.addValue(x + i, z + j, value);
            }
        }
    }

    public void addCheckerBoard(int x, int z, int width, int length, T value) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < length; ++j) {
                if ((i + j & 1) != 0) continue;
                this.addValue(x + i, z + j, value);
            }
        }
    }

    public AbstractList2D<T> copy() {
        AbstractList2D result = this.createNew();
        for (Link2D link : this) {
            result.addValue(link.x, link.z, link.value);
        }
        return result;
    }

    public static <T extends Number> AbstractList2D<T> sumCheckerBoard(AbstractList2D<T> values, T addend) {
        AbstractList2D addendCheckers = values.createNew();
        int[] bounds = AbstractList2D.getBounds(values);
        addendCheckers.addCheckerBoard(bounds[0], bounds[1], bounds[2] + 1 - bounds[0], bounds[3] + 1 - bounds[1], addend);
        AbstractList2D.add(values, addendCheckers);
        return values;
    }

    public int[] randomPoint(Random random) {
        TreeSet<Integer> var = this.xList();
        Integer[] xa = var.toArray(new Integer[var.size()]);
        int x = xa[random.nextInt(xa.length)];
        var = this.zList(x);
        Integer[] za = var.toArray(new Integer[var.size()]);
        int z = za[random.nextInt(za.length)];
        return new int[]{x, z};
    }

    public T getOneValue() {
        Object result = null;
        for (Link2D link : this) {
            if (link.value == null) continue;
            return link.value;
        }
        return null;
    }

    public AbstractList2D<T> fillEvens(T fill) {
        for (int i : this.xList()) {
            if ((i & 1) != 0) continue;
            for (int j : this.zList(i)) {
                if ((j & 1) != 0) continue;
                this.addValue(i, j, fill);
            }
        }
        return this;
    }

    public AbstractList2D<T> checkerboard(T fill) {
        for (int i : this.xList()) {
            for (int j : this.zList(i)) {
                if ((j + i & 1) != 0) continue;
                this.addValue(i, j, fill);
            }
        }
        return this;
    }

    public int[] getNthIntersection(AbstractList2D other, int n) {
        int hits = 0;
        for (Integer i : this.xList()) {
            for (Integer j : this.zList(i)) {
                if (other.contains(i, j)) {
                    ++hits;
                }
                if (hits != n) continue;
                return new int[]{i, j};
            }
        }
        return null;
    }

    public AbstractList2D<T> replace(T value) {
        for (int i : this.xList()) {
            for (int j : this.zList(i)) {
                this.addValue(i, j, value);
            }
        }
        return this;
    }

    public <F> AbstractList2D<F> convert(F fillValue) {
        AbstractList2D result = this.createNew();
        for (int i : this.xList()) {
            for (int j : this.zList(i)) {
                result.addValue(i, j, fillValue);
            }
        }
        return result;
    }

    public AbstractList2D<T> recreateWithMinAtZero() {
        AbstractList2D result = this.createNew();
        for (Integer i : this.xList()) {
            for (Integer j : this.zList(i)) {
                result.addValue(i - this.minX, j - this.minZ, this.get(i, j));
            }
        }
        return result;
    }

    public AbstractList2D expand(int radius, T value) {
        AbstractList2D temp = this.createNew();
        for (int x : this.xList()) {
            for (int z : this.zList(x)) {
                for (int i = -radius; i <= radius; ++i) {
                    for (int j = -radius; j <= radius; ++j) {
                        if (this.contains(x + i, z + j)) continue;
                        temp.addValue(x + i, z + j, value);
                    }
                }
            }
        }
        return this.combine(temp, false, new Object[0]);
    }

    public static <T> AbstractList2D<T> fromArray(Class<? extends AbstractList2D> list2Dclass, int x, int z, int width, int length, T[] values) {
        AbstractList2D result = null;
        try {
            result = list2Dclass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int j = 0; j < length; ++j) {
            for (int i = 0; i < width; ++i) {
                result.addValue(i, j, values[i + j * width]);
            }
        }
        return result;
    }

    public static AbstractList2D<Integer> fromArray(Class<? extends AbstractList2D> list2Dclass, int x, int z, int width, int length, int[] values) {
        AbstractList2D result = null;
        try {
            result = list2Dclass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int j = 0; j < length; ++j) {
            for (int i = 0; i < width; ++i) {
                result.addValue(i, j, values[i + j * width]);
            }
        }
        return result;
    }

    public static AbstractList2D<Byte> fromArray(Class<? extends AbstractList2D> list2Dclass, int x, int z, int width, int length, byte[] values) {
        AbstractList2D result = null;
        try {
            result = list2Dclass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int j = 0; j < length; ++j) {
            for (int i = 0; i < width; ++i) {
                result.addValue(i, j, values[i + j * width]);
            }
        }
        return result;
    }

    public static AbstractList2D<Float> fromArray(Class<? extends AbstractList2D> list2Dclass, int x, int z, int width, int length, float[] values) {
        AbstractList2D result = null;
        try {
            result = list2Dclass.newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (int j = 0; j < length; ++j) {
            for (int i = 0; i < width; ++i) {
                result.addValue(i, j, Float.valueOf(values[i + j * width]));
            }
        }
        return result;
    }

    public static AbstractList2D<Float> modify(AbstractList2D<Float> values, AbstractList2D<Float> result, GeometryHelper.FunctionType type, double ... args) {
        if (result == null) {
            result = values.createNew();
        }
        for (Integer i : values.xList()) {
            for (Integer j : values.zList(i)) {
                Float newValue = type == GeometryHelper.FunctionType.PERFECTSIN ? Float.valueOf((float)GeometryHelper.perfectSin(values.get(i, j).floatValue(), args[0], values.minVal, values.maxVal)) : Float.valueOf((float)type.function(values.get(i, j).floatValue(), args));
                result.addValue(i, j, newValue);
            }
        }
        return result;
    }

    public static <T> AbstractList2D<T> copyWithOnly(AbstractList2D<T> values, T value) {
        AbstractList2D result = values.createNew();
        for (Integer x : values.xList()) {
            for (Integer z : values.zList(x)) {
                T t = values.get(x, z);
                if (!t.equals(value)) continue;
                result.addValue(x, z, t);
            }
        }
        return result;
    }

    public static <T> AbstractList2D<T> copyWithout(AbstractList2D<T> values, T value) {
        AbstractList2D result = values.createNew();
        for (Integer x : values.xList()) {
            for (Integer z : values.zList(x)) {
                T t = values.get(x, z);
                if (t.equals(value)) continue;
                result.addValue(x, z, t);
            }
        }
        return result;
    }

    public static <E, T extends Comparable<E>> AbstractList2D<T> filter(AbstractList2D<T> values, E value, BooleanOp op) {
        AbstractList2D result = values.createNew();
        for (Integer x : values.xList()) {
            TreeSet<Integer> column = values.zList(x);
            for (Integer z : column) {
                Comparable t = (Comparable)values.get(x, z);
                if (!op.op(t, value)) continue;
                result.addValue(x, z, t);
            }
        }
        return result;
    }

    public <E> AbstractList2D<E> filterConversion(T match, AbstractList2D<E> dest, E value) {
        for (Integer x : this.xList()) {
            TreeSet<Integer> column = this.zList(x);
            for (Integer z : column) {
                if (!match.equals(this.get(x, z))) continue;
                dest.addValue(x, z, value);
            }
        }
        return dest;
    }

    public static AbstractList2D<Float> invert(AbstractList2D<Float> source, AbstractList2D<Float> dest) {
        if (dest == null) {
            dest = source.createNew();
        }
        for (Integer i : source.xList()) {
            for (Integer j : source.zList(i)) {
                float value = 1.0f - source.get(i, j).floatValue();
                dest.addValue(i, j, Float.valueOf(value));
            }
        }
        return dest;
    }

    public static AbstractList2D<Integer> add(AbstractList2D<Integer> source, AbstractList2D<Integer> dest, int addend) {
        if (dest == null) {
            dest = source.createNew();
        }
        for (Integer i : source.xList()) {
            for (Integer j : source.zList(i)) {
                Integer val = source.get(i, j) + addend;
                dest.addValue(i, j, val);
            }
        }
        return dest;
    }

    public static <T extends Number> void add(AbstractList2D<T> left, AbstractList2D<? extends Number> right) {
        for (int i : right.xList()) {
            for (int j : right.zList(i)) {
                Constructor<?>[] constructors;
                Number addend1 = (Number)left.get(i, j);
                Number addend2 = right.get(i, j);
                if (left.get(i, j) == null) continue;
                double sum = addend1.doubleValue() + addend2.doubleValue();
                Class<?> numClass = addend1.getClass();
                Number result = null;
                String methodName = null;
                Object constructor = null;
                for (Constructor<?> con : constructors = numClass.getConstructors()) {
                    Class<?>[] params = con.getParameterTypes();
                    if (params.length <= 0 || !params[0].isPrimitive() || params[0].getSimpleName().equals("boolean") || params[0].getSimpleName().equals("char")) continue;
                    methodName = params[0].getSimpleName() + "Value";
                    break;
                }
                Method getMethod = null;
                try {
                    getMethod = Double.class.getMethod(methodName, new Class[0]);
                    result = (Number)getMethod.invoke((Object)sum, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                left.addValue(i, j, result);
            }
        }
    }

    public static AbstractList2D<Float> add(AbstractList2D<Float> source, AbstractList2D<Float> dest, float addend) {
        if (dest == null) {
            dest = source.createNew();
        }
        for (Integer i : source.xList()) {
            for (Integer j : source.zList(i)) {
                Float val = Float.valueOf(source.get(i, j).floatValue() + addend);
                dest.addValue(i, j, val);
            }
        }
        return dest;
    }

    public static AbstractList2D<Float> mul(AbstractList2D<Float> source, AbstractList2D<Float> dest, float factor) {
        if (dest == null) {
            dest = source.createNew();
        }
        for (Integer i : source.xList()) {
            for (Integer j : source.zList(i)) {
                Float val = Float.valueOf(source.get(i, j).floatValue() * factor);
                dest.addValue(i, j, val);
            }
        }
        return dest;
    }

    public <E extends T> AbstractList2D<T> combine(AbstractList2D<E> other, boolean overwrite, E ... keepThese) {
        for (Integer i : other.xList()) {
            TreeSet<Integer> column = other.zList(i);
            for (Integer j : column) {
                T val = this.get(i, j);
                if (!overwrite && this.get(i, j) != null || keepThese != null && CommonHelper.contains(keepThese, val)) continue;
                this.addValue(i, j, other.get(i, j));
            }
        }
        return this;
    }

    public AbstractList2D<T> intersect(IList2D other) {
        TreeSet<Integer> xList = new TreeSet<Integer>((SortedSet<Integer>)this.xList());
        Iterator i$ = xList.iterator();
        while (i$.hasNext()) {
            int i = (Integer)i$.next();
            TreeSet<Integer> zList = new TreeSet<Integer>((SortedSet<Integer>)this.zList(i));
            Iterator i$2 = zList.iterator();
            while (i$2.hasNext()) {
                int j = (Integer)i$2.next();
                if (other.contains(i, j)) continue;
                this.remove(i, j);
            }
        }
        return this;
    }

    public static <T> AbstractList2D<T> common(AbstractList2D<T> derive, AbstractList2D ... rest) {
        AbstractList2D<T> result = derive.copy();
        for (int i = 0; i < rest.length; ++i) {
            result.intersect(rest[i]);
        }
        return result;
    }

    public static boolean isPointSurrounded(AbstractList2D values, int x, int z) {
        for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                if (i == 0 || j == 0 || values.get(x + i, j + z) != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isInBounds(int x, int z) {
        return x >= this.minX() && x <= this.maxX() && z >= this.minZ() && z <= this.maxZ();
    }

    public AbstractList2D<T> modifyWithShape(Shape shape, T fill) {
        Rectangle2D bbox = shape.getBounds2D();
        int i = (int)bbox.getMinX() - 1;
        while ((double)i < bbox.getMaxX()) {
            int j = (int)bbox.getMinY() - 1;
            while ((double)j < bbox.getMaxY()) {
                if (shape.contains(i, j)) {
                    this.addValue(i, j, fill);
                }
                ++j;
            }
            ++i;
        }
        return this;
    }

    public AbstractList2D<T> addLines(Collection<? extends Line2D> lines, T fill) {
        for (Line2D line2D : lines) {
            this.addLine(line2D, fill);
        }
        return this;
    }

    public AbstractList2D<T> addLine(Line2D line, T fill) {
        double temp;
        boolean steep;
        double x0 = line.getX1();
        double y0 = line.getY1();
        double x1 = line.getX2();
        double y1 = line.getY2();
        boolean bl = steep = Math.abs(y1 - y0) > Math.abs(x1 - x0);
        if (steep) {
            temp = x0;
            x0 = y0;
            y0 = temp;
            temp = x1;
            x1 = y1;
            y1 = temp;
        }
        if (x0 > x1) {
            temp = x0;
            x0 = x1;
            x1 = temp;
            temp = y0;
            y0 = y1;
            y1 = temp;
        }
        int deltax = (int)(x1 - x0);
        int deltay = (int)Math.abs(y1 - y0);
        int error = deltax / 2;
        int y = (int)y0;
        int ystep = y0 < y1 ? 1 : -1;
        int x = (int)x0;
        while ((double)x <= x1) {
            if (steep) {
                this.addValue(y, x, fill);
            } else {
                this.addValue(x, y, fill);
            }
            if ((error -= deltay) < 0) {
                y += ystep;
                error += deltax;
            }
            ++x;
        }
        return this;
    }

    public String listIndices() {
        return this.xToZ.toString();
    }

    public MinimalList2D<T> makeBoring() {
        MinimalList2D<T> result = new MinimalList2D<T>();
        for (int i : this.xList()) {
            for (int j : this.zList(i)) {
                result.addValue(i, j, this.get(i, j));
            }
        }
        return result;
    }

    public static int[] toIntArray(AbstractList2D<Integer> l2d) {
        int width = l2d.rangeX();
        int length = l2d.rangeZ();
        int[] result = new int[width * length];
        for (int i : l2d.xList()) {
            for (int j : l2d.zList(i)) {
                result[l2d.index((int)i, (int)j)] = l2d.get(i, j);
            }
        }
        return result;
    }

    protected int index(int x, int z) {
        return (z - this.minZ) * this.rangeX() + (x - this.minX);
    }

    public void imageFill(AbstractList2D<Float> l2d, BufferedImage img) {
        Color color = null;
        for (int i = 0; i < img.getWidth(); ++i) {
            for (int j = 0; j < img.getHeight(); ++j) {
                color = new Color(img.getRGB(i, j));
                float alpha = (float)color.getAlpha() / 255.0f;
                if (alpha == 0.0f) continue;
                float lightness = Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), null)[2];
                float value = lightness * alpha;
                l2d.addValue(i, j, Float.valueOf(value));
            }
        }
    }

    public void readNBT(NBTTagCompound nbt) {
        Map xMap = CommonHelper.getMap(nbt);
        for (Map.Entry e : xMap.entrySet()) {
            int i = Integer.parseInt(e.getKey());
            NBTTagCompound z = (NBTTagCompound)e.getValue();
            Map zMap = CommonHelper.getMap(z);
            for (Map.Entry n : zMap.entrySet()) {
                String key = n.getKey();
                int dotIndex = key.indexOf(".");
                int j = Integer.parseInt(key.substring(0, dotIndex));
                String className = key.substring(dotIndex + 1, key.length());
                Object v = null;
                if (className.equals("I")) {
                    v = ((NBTTagInt)n.getValue()).func_150287_d();
                } else if (className.equals("SH")) {
                    v = ((NBTTagShort)n.getValue()).func_150289_e();
                } else if (className.equals("L")) {
                    v = ((NBTTagLong)n.getValue()).func_150291_c();
                } else if (className.equals("F")) {
                    v = Float.valueOf(((NBTTagFloat)n.getValue()).func_150288_h());
                } else if (className.equals("D")) {
                    v = ((NBTTagDouble)n.getValue()).func_150286_g();
                } else if (className.equals("BY")) {
                    v = ((NBTTagByte)n.getValue()).func_150290_f();
                } else if (className.equals("BO")) {
                    v = ((NBTTagByte)n.getValue()).func_150290_f() != 0;
                } else if (className.equals("ST")) {
                    v = ((NBTTagString)n.getValue()).func_150285_a_();
                } else if (className.equals("TC")) {
                    v = (NBTTagCompound)n.getValue();
                } else if (className.equals("T")) {
                    v = (NBTBase)n.getValue();
                } else if (className.equals("O")) {
                    v = CommonHelper.THING;
                } else {
                    try {
                        Class<?> clazz = Class.forName(className);
                        v = clazz.newInstance();
                        ((INbt)v).read((NBTTagCompound)n.getValue());
                    }
                    catch (Exception e1) {
                        e1.printStackTrace();
                    }
                }
                if (v == null) {
                    throw new RuntimeException("The NBT tag could not be loaded into the " + this.getClass());
                }
                this.addValue(i, j, v);
            }
        }
    }

    public NBTTagCompound writeNBT() {
        NBTTagCompound x = new NBTTagCompound();
        for (int i : this.xList()) {
            NBTTagCompound z = new NBTTagCompound();
            for (int j : this.zList(i)) {
                T val = this.get(i, j);
                if (val instanceof Integer) {
                    z.func_74768_a(j + ".I", ((Integer)val).intValue());
                    continue;
                }
                if (val instanceof Short) {
                    z.func_74777_a(j + ".SH", ((Short)val).shortValue());
                    continue;
                }
                if (val instanceof Long) {
                    z.func_74772_a(j + ".L", ((Long)val).longValue());
                    continue;
                }
                if (val instanceof Float) {
                    z.func_74776_a(j + ".F", ((Float)val).floatValue());
                    continue;
                }
                if (val instanceof Double) {
                    z.func_74780_a(j + ".D", ((Double)val).doubleValue());
                    continue;
                }
                if (val instanceof Byte) {
                    z.func_74774_a(j + ".BY", ((Byte)val).byteValue());
                    continue;
                }
                if (val instanceof Boolean) {
                    z.func_74757_a(j + ".BO", ((Boolean)val).booleanValue());
                    continue;
                }
                if (val instanceof String) {
                    z.func_74778_a(j + ".ST", (String)val);
                    continue;
                }
                if (val instanceof NBTTagCompound) {
                    z.func_74782_a(j + ".TC", (NBTBase)((NBTTagCompound)val));
                    continue;
                }
                if (val instanceof NBTBase) {
                    z.func_74782_a(j + ".T", (NBTBase)val);
                    continue;
                }
                if (val.getClass() == Object.class) {
                    z.func_74777_a(j + ".O", (short)0);
                    continue;
                }
                if (!(val instanceof INbt)) continue;
                NBTTagCompound valSave = new NBTTagCompound();
                ((INbt)val).write(valSave);
                z.func_74782_a(j + "." + val.getClass().getName(), (NBTBase)valSave);
            }
            x.func_74782_a(i + "", (NBTBase)z);
        }
        return x;
    }

    public void save(File file) throws IOException {
        NBTTools.saveNBT(this.writeNBT(), file, true);
    }

    public AbstractList2D<T> loadFill(File file) throws IOException {
        this.readNBT(NBTTools.loadNBT(file));
        return this;
    }
}

