/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util;

import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.IList2D;
import com.pixelmonmod.pixelmon.util.Iterator2D;
import com.pixelmonmod.pixelmon.util.Link2D;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.Array;
import java.util.HashSet;
import net.minecraftforge.common.util.ForgeDirection;

public class Array2D<T>
implements IList2D<T> {
    protected int width;
    protected int length;
    protected int size;
    protected int zeroX = 0;
    protected int zeroZ = 0;
    protected Double minVal = null;
    protected Double maxVal = null;
    protected Object values;
    private final Class<T> arrayClass;

    public Array2D(Class<T> valuesClass, int width, int length) {
        this.width = width;
        this.length = length;
        this.size = width * length;
        this.arrayClass = valuesClass;
        this.values = Array.newInstance(valuesClass, width * length);
    }

    public Array2D(Class<T> valuesClass, int width, int length, T fill) {
        this(valuesClass, width, length);
        for (int i = 0; i < Array.getLength(this.values); ++i) {
            this.zet(this.values, i, fill, false);
        }
        this.recalcMinMax();
    }

    private Array2D(Array2D<T> src) {
        this.width = src.width;
        this.length = src.length;
        this.size = src.size;
        this.setZero(src.zeroX, src.zeroZ);
        this.arrayClass = src.arrayClass;
        this.minVal = src.minVal;
        this.maxVal = src.maxVal;
        this.values = ((Object[])src.values).clone();
    }

    public Object clone() {
        return new Array2D<T>(this);
    }

    public Array2D<T> copyAll(Array2D<T> src, boolean cloneArray) {
        this.width = src.width;
        this.length = src.length;
        this.size = src.size;
        this.setZero(src.zeroX, src.zeroZ);
        this.minVal = src.minVal;
        this.maxVal = src.maxVal;
        this.values = cloneArray ? ((Object[])src.values).clone() : src.values;
        return this;
    }

    public Array2D<T> setZero(int x, int z) {
        this.zeroX = x;
        this.zeroZ = z;
        return this;
    }

    public boolean isInBounds(int x, int z) {
        return x >= 0 && x < this.width && z >= 0 && z < this.length;
    }

    public int minX() {
        return this.zeroX;
    }

    public int minZ() {
        return this.zeroZ;
    }

    public int maxX() {
        return this.width + this.zeroX;
    }

    public int maxZ() {
        return this.length + this.zeroZ;
    }

    public int width() {
        return this.width;
    }

    public int length() {
        return this.length;
    }

    public int size() {
        return this.size;
    }

    public Double minValue() {
        return this.minVal;
    }

    public Double maxValue() {
        return this.maxVal;
    }

    public Object values() {
        return this.values;
    }

    public static int index(int x, int z, int width) {
        return z * width + x;
    }

    public static int[] reverseIndex(int i, int width, int zeroX, int zeroZ) {
        int z = i / width;
        int x = i % width;
        return new int[]{x + zeroX, z + zeroZ};
    }

    @Override
    public T get(int x, int z) {
        return this.isInBounds(x - this.zeroX, z - this.zeroZ) ? (T)this.uncheckedGet(x, z) : null;
    }

    public T uncheckedGet(int x, int z) {
        return (T)Array.get(this.values, Array2D.index(x - this.zeroX, z - this.zeroZ, this.width));
    }

    public void set(int x, int z, T value) {
        this.set(x, z, value, true);
    }

    public void set(int x, int z, T value, boolean recalcMinMax) {
        try {
            this.zet(this.values, Array2D.index(x - this.zeroX, z - this.zeroZ, this.width), value, recalcMinMax);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            String message = String.format("Attempted to set a value at (x=%s, z=%s) in Array2D[minX=%s, minZ=%s, maxX=%s, maxZ=%s]", x, z, this.minX(), this.minZ(), this.maxX(), this.maxZ());
            throw new ArrayIndexOutOfBoundsException(message);
        }
    }

    public void set(int i, T value) {
        this.set(i, value, true);
    }

    public void set(int i, T value, boolean recalcMinMax) {
        this.zet(this.values, i, value, recalcMinMax);
    }

    protected void zet(Object array, int i, T value, boolean recalcMinMax) {
        Object prev = Array.get(array, i);
        boolean mayHaveAlteredMinMax = recalcMinMax && prev != null && (prev.equals(this.minVal) || prev.equals(this.maxVal));
        Array.set(array, i, value);
        if (mayHaveAlteredMinMax) {
            this.recalcMinMax();
        } else {
            this.alterMinMax(value);
        }
    }

    protected void alterMinMax(Object n) {
        if (n instanceof Number) {
            Number num = (Number)n;
            if (this.minVal == null || num.doubleValue() < this.minVal) {
                this.minVal = num.doubleValue();
            }
            if (this.maxVal == null || num.doubleValue() > this.maxVal) {
                this.maxVal = num.doubleValue();
            }
        }
    }

    public void recalcMinMax() {
        this.minVal = null;
        this.maxVal = null;
        for (int i = 0; i < Array.getLength(this.values); ++i) {
            this.alterMinMax(Array.get(this.values, i));
        }
    }

    public void setRect(int x, int z, int width, int length, T value, boolean overwrite) {
        int dx = Integer.signum(width);
        int dz = Integer.signum(length);
        for (int i = 0; i != width; i += dx) {
            for (int j = 0; j != length; j += dz) {
                if (!overwrite && this.get(x + i, z + j) != null) continue;
                this.set(x + i, z + j, value, false);
            }
        }
        this.recalcMinMax();
    }

    public void removeAll(T value) {
        if (value == null) {
            return;
        }
        boolean flag = value.equals(this.minVal) || value.equals(this.maxVal);
        for (int i = 0; i < Array.getLength(this.values); ++i) {
            boolean yeah;
            boolean bl = yeah = value != null && value.equals(Array.get(this.values, i));
            if (!yeah) continue;
            this.zet(this.values, i, null, false);
        }
        if (flag) {
            this.recalcMinMax();
        }
    }

    public Array2D<T> combine(EntryList2D<T> l2d, boolean overwrite, T ... keepThese) {
        if (l2d.minX < this.zeroX || l2d.minZ < this.zeroZ || l2d.maxX > this.width + this.zeroX || l2d.maxZ > this.length + this.zeroZ) {
            String details = "(l2d.maxX = " + l2d.maxX + ", width+zeroX = " + this.width + "+" + this.zeroX + ")";
            throw new IllegalArgumentException("The parameter 'l2d' must fit within this Array2D : " + details);
        }
        for (Link2D link2D : l2d) {
            try {
                T val = this.get(link2D.x, link2D.z);
                if (!overwrite || !CommonHelper.contains(keepThese, val)) {
                    // empty if block
                }
                this.set(link2D.x, link2D.z, link2D.value, false);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("L2D row length = " + l2d.xList().size());
                System.err.println("L2D column length = " + l2d.zList().size());
            }
        }
        this.recalcMinMax();
        return this;
    }

    public Array2D<T> intersect(Array2D other) {
        for (int i = this.minX(); i <= this.maxX(); ++i) {
            int j = this.minZ();
            while (j <= this.maxZ()) {
                if (!other.contains(i, j)) {
                    this.remove(i, j);
                }
                ++i;
            }
        }
        this.recalcMinMax();
        return this;
    }

    public Array2D<T> expand(int radius, T value) {
        int minX = this.firstNonEmptyCoord(ForgeDirection.WEST) - radius;
        int maxX = this.firstNonEmptyCoord(ForgeDirection.EAST) + radius + 1;
        int minZ = this.firstNonEmptyCoord(ForgeDirection.NORTH) - radius;
        int maxZ = this.firstNonEmptyCoord(ForgeDirection.SOUTH) + radius + 1;
        if (minX < this.minX() || maxX > this.maxX() || minZ < this.minZ() || maxZ > this.maxX()) {
            Array2D<T> newSet = new Array2D<T>(this.arrayClass, maxX - minX, maxZ - minZ).setZero(minX, minZ);
            for (int x = this.minX(); x <= this.maxX(); ++x) {
                for (int z = this.minZ(); z <= this.maxZ(); ++z) {
                    T srcVal = this.get(x, z);
                    if (srcVal == null) continue;
                    for (int i = -radius; i <= radius; ++i) {
                        for (int j = -radius; j <= radius; ++j) {
                            srcVal = this.get(x + i, z + i);
                            newSet.set(x + i, z + j, srcVal == null ? value : srcVal, false);
                        }
                    }
                }
            }
            newSet.recalcMinMax();
            this.copyAll(newSet, false);
        } else {
            for (int x = this.minX(); x <= this.maxX(); ++x) {
                for (int z = this.minZ(); z <= this.maxZ(); ++z) {
                    T srcVal = this.get(x, z);
                    if (srcVal == null) continue;
                    for (int i = -radius; i <= radius; ++i) {
                        for (int j = -radius; j <= radius; ++j) {
                            srcVal = this.get(x + i, z + j);
                            if (srcVal != null) continue;
                            this.set(x + i, z + j, value, false);
                        }
                    }
                }
            }
            this.recalcMinMax();
        }
        return this;
    }

    public Array2D<T> modifyWithShape(Shape shape, T fill) {
        try {
            for (int i = this.minX(); i < this.maxX(); ++i) {
                for (int j = this.minZ(); j < this.maxZ(); ++j) {
                    if (!shape.contains(i, j)) continue;
                    this.set(i, j, fill, false);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Rectangle2D bounds = shape.getBounds2D();
            String message = String.format("The shape does not fit.\nArray2D:[minX=%s, minZ=%s, maxX=%s, maxZ=%s]\nShape:[minX=%s, minZ=%s, maxX=%s, maxZ=%s]\nDetails: " + e.getMessage(), this.minX(), this.minZ(), this.maxX(), this.maxZ(), (int)bounds.getMinX(), (int)bounds.getMinY(), (int)bounds.getMaxX(), (int)bounds.getMaxY());
            throw new ArrayIndexOutOfBoundsException(message);
        }
        this.recalcMinMax();
        return this;
    }

    public static Array2D<Float> invert(Array2D<Float> src) {
        for (int i = src.minX(); i <= src.maxX(); ++i) {
            for (int j = src.minZ(); j <= src.maxZ(); ++j) {
                Float value = src.get(i, j);
                if (value == null) continue;
                src.set(i, j, Float.valueOf(1.0f - value.floatValue()), false);
            }
        }
        src.recalcMinMax();
        return src;
    }

    public static Array2D<Integer> add(Array2D<Integer> src, int addend) {
        for (int i = src.minX(); i <= src.maxX(); ++i) {
            for (int j = src.minZ(); j <= src.maxZ(); ++j) {
                Integer value = src.get(i, j);
                if (value == null) continue;
                src.set(i, j, value + addend);
            }
        }
        return src;
    }

    public static Array2D<Float> add(Array2D<Float> src, float addend) {
        for (int i = src.minX(); i <= src.maxX(); ++i) {
            for (int j = src.minZ(); j <= src.maxZ(); ++j) {
                Float value = src.get(i, j);
                if (value == null) continue;
                src.set(i, j, Float.valueOf(value.floatValue() + addend));
            }
        }
        return src;
    }

    public static Array2D<Float> mul(Array2D<Float> src, float factor) {
        for (int i = src.minX(); i <= src.maxX(); ++i) {
            for (int j = src.minZ(); j <= src.maxZ(); ++j) {
                Float value = src.get(i, j);
                if (value == null) continue;
                src.set(i, j, Float.valueOf(value.floatValue() * factor));
            }
        }
        return src;
    }

    public <I, E extends AbstractList2D<I>> Array2D<T> combine(E l2d, T fill, boolean overwrite, T ... keepThese) {
        if (l2d.minX < this.zeroX || l2d.minZ < this.zeroZ || l2d.maxX > this.width + this.zeroX || l2d.maxZ > this.length + this.zeroZ) {
            String details = "(l2d.maxX = " + l2d.maxX + ", width+zeroX = " + this.width + "+" + this.zeroX + ")";
            throw new IllegalArgumentException("The parameter 'l2d' must fit within this Array2D : " + details);
        }
        for (Link2D link : l2d) {
            try {
                T val = this.get(link.x, link.z);
                if (!overwrite || !CommonHelper.contains(keepThese, val)) {
                    // empty if block
                }
                this.set(link.x, link.z, fill);
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.err.println("L2D row length = " + l2d.xList().size());
                System.err.println("L2D column length = " + l2d.zList().size());
            }
        }
        return this;
    }

    public HashSet<T> valueSet() {
        HashSet<Object> result = new HashSet<Object>();
        for (int i = 0; i < Array.getLength(this.values); ++i) {
            Object val = Array.get(this.values, i);
            if (val == null) continue;
            result.add(val);
        }
        return result;
    }

    public T[] columnAt(int x) {
        x -= this.zeroX;
        Object result = Array.newInstance(this.arrayClass, this.length);
        for (int i = 0; i < this.length; ++i) {
            this.zet(result, i, this.get(x, i), false);
        }
        return (Object[])result;
    }

    public T[] rowAt(int z) {
        z -= this.zeroZ;
        Object result = Array.newInstance(this.arrayClass, this.width);
        for (int i = 0; i < this.width; ++i) {
            this.zet(result, i, this.get(i, z), false);
        }
        return (Object[])result;
    }

    public HashSet<T> valuesInRow(int z) {
        T[] row = this.rowAt(z);
        HashSet<T> result = new HashSet<T>();
        for (int i = 0; i < row.length; ++i) {
            if (row[i] == null) continue;
            result.add(row[i]);
        }
        return result;
    }

    public HashSet<T> valuesInColumn(int x) {
        T[] column = this.columnAt(x);
        HashSet<T> result = new HashSet<T>();
        for (int i = 0; i < column.length; ++i) {
            if (column[i] == null) continue;
            result.add(column[i]);
        }
        return result;
    }

    public HashSet<T> firstNonEmptyStrip(ForgeDirection dir) {
        HashSet<T> result = null;
        boolean hortz = WorldHelper.isHorizontal(dir);
        switch (dir) {
            case NORTH: 
            case WEST: {
                int i = 0;
                while (result == null || result.isEmpty()) {
                    result = hortz ? this.valuesInColumn(i) : this.valuesInRow(i);
                    ++i;
                }
                break;
            }
            case SOUTH: 
            case EAST: {
                int i = -1 + (hortz ? this.width : this.length);
                while (result == null || result.isEmpty()) {
                    result = hortz ? this.valuesInColumn(i) : this.valuesInRow(i);
                    --i;
                }
                break;
            }
        }
        return result;
    }

    public Integer firstNonEmptyCoord(ForgeDirection side) {
        switch (side) {
            case WEST: {
                for (int i = this.minX(); i <= this.maxX(); ++i) {
                    for (int j = this.minZ(); j <= this.maxZ(); ++j) {
                        if (this.get(i, j) == null) continue;
                        return i;
                    }
                }
                break;
            }
            case NORTH: {
                for (int i = this.minZ(); i <= this.maxZ(); ++i) {
                    for (int j = this.minX(); j <= this.maxX(); ++j) {
                        if (this.get(j, i) == null) continue;
                        return i;
                    }
                }
                break;
            }
            case EAST: {
                for (int i = this.maxX(); i >= this.minX(); --i) {
                    for (int j = this.minZ(); j <= this.maxZ(); ++j) {
                        if (this.get(i, j) == null) continue;
                        return i;
                    }
                }
                break;
            }
            case SOUTH: {
                for (int i = this.maxZ(); i >= this.minZ(); --i) {
                    for (int j = this.minX(); j <= this.maxX(); ++j) {
                        if (this.get(j, i) == null) continue;
                        return i;
                    }
                }
                break;
            }
        }
        return null;
    }

    @Override
    public Iterator2D iterator() {
        return new ArrayIterator2D();
    }

    public String toString() {
        String result = super.toString() + String.format("(Width:%s, Length:%s, zero[%s, %s])", this.width, this.length, this.zeroX, this.zeroZ);
        for (int i = 0; i < this.length; ++i) {
            String row = "[";
            for (int j = 0; j < this.width; ++j) {
                row = row + this.get(j, i);
                if (j + 1 < this.width) {
                    // empty if block
                }
                row = row + ", ";
            }
            row = row + ']';
            result = result + System.lineSeparator() + row;
        }
        return result;
    }

    @Override
    public boolean contains(int x, int z) {
        return this.get(x, z) != null;
    }

    @Override
    public void addValue(int x, int z, T value) {
        this.set(x, z, value, true);
    }

    @Override
    public T remove(int x, int z) {
        return this.remove(x, z, true);
    }

    public T remove(int x, int z, boolean recalcMinMax) {
        boolean flag;
        T result = this.get(x, z);
        boolean bl = flag = result != null && (result.equals(this.minVal) || result.equals(this.maxVal));
        if (result != null) {
            this.set(x, z, null, false);
        }
        if (recalcMinMax && flag) {
            this.recalcMinMax();
        }
        return result;
    }

    @Override
    public Array2D<T> createNew() {
        return new Array2D<T>(this.arrayClass, this.width, this.length);
    }

    public Array2D<T> createNewWithSameZeros() {
        return ((Array2D)this.createNew()).setZero(this.zeroX, this.zeroZ);
    }

    public class ArrayIterator2D
    extends Iterator2D<T> {
        private int i = 0;

        @Override
        public boolean hasNext() {
            return this.i < Array.getLength(Array2D.this.values);
        }

        @Override
        public Link2D<T> next() {
            int[] xz = this.reverseIndex();
            Link2D result = new Link2D(xz[0], xz[1], Array2D.this.get(xz[0], xz[1]));
            ++this.i;
            return result;
        }

        @Override
        public void remove() {
            int[] xz = this.reverseIndex();
            Array2D.this.remove(xz[0], xz[1]);
            --this.i;
        }

        private int[] reverseIndex() {
            return Array2D.reverseIndex(this.i, Array2D.this.width, Array2D.this.zeroX, Array2D.this.zeroZ);
        }
    }
}

