/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.util.IRandomPicker;
import com.pixelmonmod.pixelmon.util.PixelmonDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.util.MathHelper;

public class ChancedWrapper<T>
implements Comparable<ChancedWrapper> {
    public T object;
    public float minChance;
    public float maxChance;
    private static final String illegalChance = "The ChancedWrapper from %s wrapping %s must be initialized with a chance value between 0.0f and 1.0f. The value in this case, however, was %s";

    public ChancedWrapper(T object, float chance) {
        if (chance < 0.0f || chance > 1.0f) {
            throw ChancedWrapper.badChanceArg(object, chance);
        }
        this.object = object;
        this.minChance = 0.0f;
        this.maxChance = chance;
    }

    public ChancedWrapper(T object, Random rand, float chance) {
        chance = MathHelper.func_76131_a((float)chance, (float)0.0f, (float)1.0f);
        this.object = object;
        this.minChance = RandomHelper.useRandomForNumberBetween(rand, 0.0f, 1.0f - chance);
        this.maxChance = this.minChance + chance;
    }

    public boolean chosen(float a) {
        boolean result = this.minChance <= a && a < this.maxChance;
        return result;
    }

    public boolean chosen(Random random) {
        return this.chosen(random.nextFloat());
    }

    public static boolean chosen(float chance, Random random) {
        chance = MathHelper.func_76131_a((float)chance, (float)0.0f, (float)1.0f);
        float minChance = RandomHelper.useRandomForNumberBetween(random, 0.0f, 1.0f - chance);
        float maxChance = minChance + chance;
        float a = random.nextFloat();
        return minChance <= a && a < maxChance;
    }

    protected static IllegalArgumentException badChanceArg(Object attemptedObj, float badArg) {
        return new IllegalArgumentException(String.format(illegalChance, PixelmonDebug.prevMethod(), attemptedObj, Float.valueOf(badArg)));
    }

    public static <T, E extends ChancedWrapper<T>> E weightedChoice(Collection<E> choices, Random random, boolean nextForEach) {
        ChancedWrapper result;
        ArrayList<ChancedWrapper> preliminary = new ArrayList<ChancedWrapper>();
        float next = random.nextFloat();
        for (ChancedWrapper choice : choices) {
            boolean chosen;
            if (nextForEach) {
                next = random.nextFloat();
            }
            if (!(chosen = choice.chosen(next))) continue;
            preliminary.add(choice);
        }
        ChancedWrapper chancedWrapper = result = preliminary.size() == 0 ? null : (ChancedWrapper)preliminary.get(random.nextInt(preliminary.size()));
        if (result != null) {
            // empty if block
        }
        return (E)result;
    }

    public static <T> T weightedChoice(Collection<ChancedWrapper<T>> choices, IRandomPicker random, boolean nextForEach) {
        ArrayList<T> preliminary = new ArrayList<T>();
        float next = random.nextFloat();
        for (ChancedWrapper<T> choice : choices) {
            if (nextForEach) {
                next = random.nextFloat();
            }
            if (!choice.chosen(next)) continue;
            preliminary.add(choice.object);
        }
        T result = preliminary.size() == 0 ? null : (T)preliminary.get(random.getNextInt(preliminary.size()));
        return result;
    }

    public float chance() {
        return this.maxChance - this.minChance;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(chance = " + (this.maxChance - this.minChance) + "object = " + this.object + ")";
    }

    public String describeObject() {
        return this.object.toString();
    }

    @Override
    public int compareTo(ChancedWrapper o) {
        int objectCompare;
        int classCompare = this.getClass().getSimpleName().compareTo(o.getClass().getSimpleName());
        if (classCompare != 0) {
            return classCompare;
        }
        int chanceCompare = (int)Math.signum(this.chance() - o.chance());
        if (chanceCompare != 0) {
            return chanceCompare;
        }
        if (this.object instanceof Comparable && o.object instanceof Comparable) {
            Comparable c0 = (Comparable)this.object;
            Comparable c1 = (Comparable)o.object;
            try {
                return c0.compareTo(c1);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if ((objectCompare = this.describeObject().compareTo(o.describeObject())) != 0) {
            return objectCompare;
        }
        return this.hashCode() - o.hashCode();
    }
}

