/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util;

import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.Iterator2D;
import com.pixelmonmod.pixelmon.util.Link2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class EntryList2D<T>
extends AbstractList2D<T> {
    ArrayList<Entry<ArrayList<Entry<T>>>> values = new ArrayList();

    public EntryList2D(int width, int length, T value) {
        for (int i = 0; i < width; ++i) {
            for (int j = 0; j < length; ++j) {
                this.addValue(i, j, value);
            }
        }
    }

    public EntryList2D() {
    }

    @Override
    public AbstractList2D createNew() {
        return new EntryList2D<T>();
    }

    @Override
    public T get(int x, int z) {
        for (Entry<ArrayList<Entry<T>>> eX : this.values) {
            if (((Entry)eX).key == x) {
                for (Entry eZ : (ArrayList)((Entry)eX).value) {
                    if (eZ.key == z) {
                        return (T)eZ.value;
                    }
                    if (eZ.key <= z) continue;
                    return null;
                }
                return null;
            }
            if (((Entry)eX).key <= x) continue;
            return null;
        }
        return null;
    }

    @Override
    protected T removeImpl(int x, int z) {
        for (int i = 0; i < this.values.size(); ++i) {
            Entry<ArrayList<Entry<Object>>> e = this.values.get(i);
            if (((Entry)e).key == x) {
                for (int j = 0; j < ((ArrayList)((Entry)e).value).size(); ++j) {
                    Entry e2 = (Entry)((ArrayList)((Entry)e).value).get(j);
                    if (e2.key == z) {
                        Object result = ((Entry)((ArrayList)((Entry)e).value).remove(j)).value;
                        if (((ArrayList)((Entry)e).value).isEmpty()) {
                            e.setValue(null);
                            this.values.remove(i);
                        }
                        return (T)result;
                    }
                    if (e2.key <= z) continue;
                    return null;
                }
                continue;
            }
            if (((Entry)e).key <= x) continue;
            return null;
        }
        return null;
    }

    @Override
    protected void putValue(int x, int z, T value) {
        for (int i = 0; i < this.values.size(); ++i) {
            Entry<ArrayList<Entry<T>>> e = this.values.get(i);
            if (((Entry)e).key == x) {
                for (int j = 0; j < ((ArrayList)((Entry)e).value).size(); ++j) {
                    Entry e2 = (Entry)((ArrayList)((Entry)e).value).get(j);
                    if (e2.key == z) {
                        e2.setValue(value);
                        return;
                    }
                    if (e2.key <= z) continue;
                    ((ArrayList)((Entry)e).value).add(j, new Entry<T>(z, value));
                    return;
                }
                ((ArrayList)((Entry)e).value).add(new Entry<T>(z, value));
                return;
            }
            if (((Entry)e).key <= x) continue;
            ArrayList<Entry<T>> newList = new ArrayList<Entry<T>>();
            newList.add(new Entry<T>(z, value));
            this.values.add(i, new Entry(x, newList));
            return;
        }
        ArrayList<Entry<T>> newList = new ArrayList<Entry<T>>();
        newList.add(new Entry<T>(z, value));
        this.values.add(new Entry(x, newList));
    }

    @Override
    public HashSet<T> toSet() {
        HashSet<Object> result = new HashSet<Object>();
        for (Entry<ArrayList<Entry<T>>> eX : this.values) {
            for (Entry eZ : (ArrayList)((Entry)eX).value) {
                result.add(eZ.value);
            }
        }
        return result;
    }

    @Override
    public ArrayList<T> toList() {
        ArrayList<Object> result = new ArrayList<Object>();
        for (Entry<ArrayList<Entry<T>>> eX : this.values) {
            for (Entry eZ : (ArrayList)((Entry)eX).value) {
                result.add(eZ.value);
            }
        }
        return result;
    }

    public static int[] toIntArray(EntryList2D<Integer> l2d) {
        int width = l2d.rangeX();
        int length = l2d.rangeZ();
        int[] result = new int[width * length];
        for (Link2D link2D : l2d) {
            result[l2d.index((int)link2D.x, (int)link2D.z)] = (Integer)link2D.value;
        }
        return result;
    }

    @Override
    public EntryIterator2D<T> iterator() {
        return new EntryIterator2D(this);
    }

    public class EntryIterator2D<E>
    extends Iterator2D<E> {
        protected int totalIndex;
        protected final EntryList2D<E> list;

        protected EntryIterator2D(EntryList2D<E> list) {
            this.list = list;
        }

        @Override
        public boolean hasNext() {
            return this.totalIndex != this.list.size();
        }

        @Override
        public Link2D next() {
            Entry e = this.list.values.get(this.currentI);
            this.currentX = e.key;
            Entry e2 = (Entry)((ArrayList)e.value).get(this.currentJ);
            this.currentZ = e2.key;
            this.prevI = this.currentI;
            this.prevJ = this.currentJ;
            if (this.currentJ + 1 < ((ArrayList)e.value).size()) {
                ++this.currentJ;
            } else if (this.currentI + 1 < this.list.values.size()) {
                ++this.currentI;
                this.currentJ = 0;
            }
            ++this.totalIndex;
            return new Link2D<Object>(this.currentX, this.currentZ, e2.value);
        }

        @Override
        public void remove() {
            this.list.remove(this.currentI, this.currentJ);
            this.currentI = this.prevI;
            this.currentJ = this.prevJ;
            --this.totalIndex;
        }
    }

    public static class Entry<T>
    implements Map.Entry<Integer, T>,
    Comparable<Entry> {
        private Integer key;
        private T value;

        public Entry(Integer k, T v) {
            this.key = k;
            this.value = v;
        }

        @Override
        public Integer getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public T setValue(T value) {
            T old = value;
            this.value = value;
            return old;
        }

        @Override
        public int compareTo(Entry that) {
            return this.key - that.key;
        }
    }
}

