/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util;

import java.util.ArrayList;

public class Property {
    private String name;
    private String value;
    public String comment;
    private String[] values;
    private final boolean wasRead;
    private final boolean isList;
    private final Type type;
    private boolean changed = false;

    public Property() {
        this.wasRead = false;
        this.type = null;
        this.isList = false;
    }

    public Property(String name, String value, Type type) {
        this(name, value, type, false);
    }

    Property(String name, String value, Type type, boolean read) {
        this.setName(name);
        this.value = value;
        this.type = type;
        this.wasRead = read;
        this.isList = false;
    }

    public Property(String name, String[] values, Type type) {
        this(name, values, type, false);
    }

    Property(String name, String[] values, Type type, boolean read) {
        this.setName(name);
        this.type = type;
        this.values = values;
        this.wasRead = read;
        this.isList = true;
    }

    public String getString() {
        return this.value;
    }

    public int getInt() {
        return this.getInt(-1);
    }

    public int getInt(int _default) {
        try {
            return Integer.parseInt(this.value);
        }
        catch (NumberFormatException e) {
            return _default;
        }
    }

    public boolean isIntValue() {
        try {
            Integer.parseInt(this.value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public boolean getBoolean(boolean _default) {
        if (this.isBooleanValue()) {
            return Boolean.parseBoolean(this.value);
        }
        return _default;
    }

    public boolean isBooleanValue() {
        return "true".equals(this.value.toLowerCase()) || "false".equals(this.value.toLowerCase());
    }

    public boolean isDoubleValue() {
        try {
            Double.parseDouble(this.value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public double getDouble(double _default) {
        try {
            return Double.parseDouble(this.value);
        }
        catch (NumberFormatException e) {
            return _default;
        }
    }

    public String[] getStringList() {
        return this.values;
    }

    public int[] getIntList() {
        ArrayList<Integer> nums = new ArrayList<Integer>();
        for (String value : this.values) {
            try {
                nums.add(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int[] primitives = new int[nums.size()];
        for (int i = 0; i < nums.size(); ++i) {
            primitives[i] = (Integer)nums.get(i);
        }
        return primitives;
    }

    public boolean isIntList() {
        for (String value : this.values) {
            try {
                Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public boolean[] getBooleanList() {
        ArrayList<Boolean> tmp = new ArrayList<Boolean>();
        for (String value : this.values) {
            try {
                tmp.add(Boolean.parseBoolean(value));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        boolean[] primitives = new boolean[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            primitives[i] = (Boolean)tmp.get(i);
        }
        return primitives;
    }

    public boolean isBooleanList() {
        for (String value : this.values) {
            if ("true".equalsIgnoreCase(value) || "false".equalsIgnoreCase(value)) continue;
            return false;
        }
        return true;
    }

    public double[] getDoubleList() {
        ArrayList<Double> tmp = new ArrayList<Double>();
        for (String value : this.values) {
            try {
                tmp.add(Double.parseDouble(value));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        double[] primitives = new double[tmp.size()];
        for (int i = 0; i < tmp.size(); ++i) {
            primitives[i] = (Double)tmp.get(i);
        }
        return primitives;
    }

    public boolean isDoubleList() {
        for (String value : this.values) {
            try {
                Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean wasRead() {
        return this.wasRead;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isList() {
        return this.isList;
    }

    public boolean hasChanged() {
        return this.changed;
    }

    void resetChangedState() {
        this.changed = false;
    }

    public void set(String value) {
        this.value = value;
        this.changed = true;
    }

    public void set(String[] values) {
        this.values = values;
        this.changed = true;
    }

    public void set(int value) {
        this.set(Integer.toString(value));
    }

    public void set(boolean value) {
        this.set(Boolean.toString(value));
    }

    public void set(double value) {
        this.set(Double.toString(value));
    }

    public static enum Type {
        STRING,
        INTEGER,
        BOOLEAN,
        DOUBLE;

        private static Type[] values;

        public static Type tryParse(char id) {
            for (int x = 0; x < values.length; ++x) {
                if (values[x].getID() != id) continue;
                return values[x];
            }
            return STRING;
        }

        public char getID() {
            return this.name().charAt(0);
        }

        static {
            values = new Type[]{STRING, INTEGER, BOOLEAN, DOUBLE};
        }
    }
}

