/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.geom;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.Iterable2D;
import com.pixelmonmod.pixelmon.util.geom.Complex;
import com.pixelmonmod.pixelmon.util.geom.FractalDragon;
import com.pixelmonmod.pixelmon.util.geom.ShapeHolder;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;

public abstract class Fractal<T extends Iterable2D> {
    protected static final File FOLDER = Fractal.correctFolder();
    public static final double r = 0.7427429446246816;
    public static final double angA = -0.5741054276517762;
    public static final double angB = 0.8200600925461135;
    public static final AffineTransform goldScale1 = AffineTransform.getScaleInstance(0.7427429446246816, 0.7427429446246816);
    public static final AffineTransform goldScale2 = AffineTransform.getScaleInstance(0.5516670817897429, 0.5516670817897429);
    public static final AffineTransform goldLeft = AffineTransform.getRotateInstance(-0.5741054276517762);
    public static final AffineTransform goldRight = AffineTransform.getRotateInstance(0.8200600925461135);
    public static final AffineTransform left45 = AffineTransform.getRotateInstance(Math.toRadians(-45.0));
    public static final AffineTransform right45 = AffineTransform.getRotateInstance(Math.toRadians(45.0));
    public static final AffineTransform scaleBetween45 = AffineTransform.getScaleInstance(0.707, 0.707);
    public static EntryList2D<AbstractList2D<Float>> goldDragons = new EntryList2D();
    public final T geometry;

    private static File correctFolder() {
        if (Pixelmon.modDirectory != null) {
            return new File(Pixelmon.modDirectory, "assets/pixelmon/L2D/");
        }
        if (ItemStack.class.getSimpleName().startsWith("ItemStack")) {
            File temp = new File(new File((File)null, "stuff").getAbsolutePath()).getParentFile().getParentFile().getParentFile();
            System.out.println("temp = " + temp.getAbsolutePath());
            return new File(temp, "jars/assets/pixelmon/L2D/");
        }
        return null;
    }

    public static void preloadFractals() {
        FractalDragon.load();
    }

    public Fractal(T geometry) {
        this.geometry = geometry;
    }

    public static void MBrot(Canvas canvas, int widthHeight) {
        Graphics2D g2d = (Graphics2D)canvas.getGraphics();
        g2d.translate(100.0, 0.0);
        g2d.scale(0.4, 0.4);
        float epsilon = 0.001f;
        int maxIterations = 1000;
        int maxColors = 0xFFFFFF;
        for (float x = -2.0f; x <= 2.0f; x += epsilon) {
            for (float y = -2.0f; y <= 2.0f; y += epsilon) {
                Complex c = new Complex(x, y);
                Complex z = new Complex(0.0, 0.0);
                boolean bounded = true;
                for (int iterations = 0; iterations < maxIterations; ++iterations) {
                    z = z.sqr().add(c);
                    if (!(z.abs() >= 2.0)) continue;
                    bounded = false;
                    break;
                }
                if (!bounded) continue;
                int xint = (int)((double)widthHeight * ((z.x + 4.0) / 4.0));
                int yint = (int)((double)widthHeight * ((z.i + 4.0) / 4.0));
                g2d.setColor(Color.WHITE);
                g2d.drawRect(xint, yint, 1, 1);
            }
        }
    }

    public static AbstractList2D<Float> goldDragon(int startSize, int iterations, boolean blur) {
        if (goldDragons.get(startSize, iterations) != null) {
            return goldDragons.get(startSize, iterations);
        }
        ArrayList<Line2D.Float> lines = Fractal.goldDragonLines(startSize, iterations).getAll();
        AbstractList2D<Float> result = new EntryList2D<Float>().addLines(lines, Float.valueOf(1.0f));
        if (blur) {
            result = GeometryHelper.sequencedBlur(result, 2, true, false, true, true, false);
        }
        goldDragons.addValue(startSize, iterations, result);
        return result;
    }

    public static ShapeHolder<Line2D.Float> goldDragonLines(int startingSize, int iterations) {
        Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float end = new Point2D.Float(startingSize, 0.0f);
        float newLength = (float)((double)startingSize * 0.7427429446246816);
        Point2D mid = new Point2D.Float(newLength, 0.0f);
        mid = goldLeft.transform(mid, null);
        Line2D.Float a = new Line2D.Float(start, mid);
        Line2D.Float b = new Line2D.Float(mid, end);
        ShapeHolder<Line2D.Float> result = new ShapeHolder<Line2D.Float>(a, b);
        for (int i = 0; i <= iterations; ++i) {
            for (ShapeHolder<Line2D.Float> holder : result.getInnermostHolders()) {
                Fractal.replaceForGoldDragon(holder);
            }
        }
        return result;
    }

    private static void replaceForGoldDragon(ShapeHolder<Line2D.Float> part) {
        Line2D.Float line1 = (Line2D.Float)part.getA();
        Line2D.Float line2 = (Line2D.Float)part.getB();
        AffineTransform move = AffineTransform.getTranslateInstance(-line1.x1, -line1.y1);
        Point2D.Float mid1 = new Point2D.Float(line1.x2, line1.y2);
        move.transform(mid1, mid1);
        goldScale1.transform(mid1, mid1);
        goldLeft.transform(mid1, mid1);
        try {
            move.invert();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        move.transform(mid1, mid1);
        Line2D.Float line1a = new Line2D.Float(line1.x1, line1.y1, mid1.x, mid1.y);
        Line2D.Float line1b = new Line2D.Float(mid1.x, mid1.y, line1.x2, line1.y2);
        move = AffineTransform.getTranslateInstance(-line2.x1, -line2.y1);
        Point2D.Float mid2 = new Point2D.Float(line2.x2, line2.y2);
        move.transform(mid2, mid2);
        goldScale2.transform(mid2, mid2);
        goldRight.transform(mid2, mid2);
        try {
            move.invert();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        move.transform(mid2, mid2);
        Line2D.Float line2a = new Line2D.Float(line2.x1, line2.y1, mid2.x, mid2.y);
        Line2D.Float line2b = new Line2D.Float(mid2.x, mid2.y, line2.x2, line2.y2);
        ShapeHolder<Line2D.Float> holderA = new ShapeHolder<Line2D.Float>(line1a, line1b);
        ShapeHolder<Line2D.Float> holderB = new ShapeHolder<Line2D.Float>(line2a, line2b);
        part.setA(holderA);
        part.setB(holderB);
    }

    static {
        FOLDER.mkdirs();
    }
}

