/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.geom;

import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.geom.Fractal;
import com.pixelmonmod.pixelmon.util.geom.LSystem;
import com.pixelmonmod.pixelmon.util.geom.ShapeHolder;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraftforge.common.util.ForgeDirection;

public class FractalDragon
extends Fractal<EntryList2D> {
    public static final ArrayList<FractalDragon> pointDragons = new ArrayList();
    public static final EntryList2D<FractalDragon> lineDragons = new EntryList2D();
    public static final LSystem dragon = new LSystem(new char[]{'X', 'Y'}, "FX", "X=X+YF", "Y=FX-Y");

    private FractalDragon(EntryList2D geometry, int iterations) {
        super(geometry);
        FractalDragon.putDragon(this, iterations);
    }

    private FractalDragon(EntryList2D geometry, int startSize, int iterations) {
        super(geometry);
        FractalDragon.putDragon(this, startSize, iterations);
    }

    private static File useFile(String dragonParams) {
        return new File(FOLDER, "DRAGON_" + dragonParams + ".L2D");
    }

    public static void load() {
        for (int i = 12; i <= 15; ++i) {
            File dragonFile = new File(FOLDER, "DRAGON_" + i + ".L2D");
            try {
                FractalDragon fd = new FractalDragon((EntryList2D)new EntryList2D().loadFill(dragonFile), i);
                continue;
            }
            catch (IOException e) {
                FractalDragon.dragonLSystem(i, true);
                continue;
            }
            catch (NullPointerException e) {
                FractalDragon.dragonLSystem(i, true);
            }
        }
    }

    public static void initPoints() {
        for (int i = 12; i <= 15; ++i) {
            AbstractList2D abstractList2D = (AbstractList2D)FractalDragon.dragonLSystem((int)i, (boolean)true).geometry;
        }
    }

    private static void putDragon(FractalDragon dragon, int iters) {
        CommonHelper.ensureIndex(pointDragons, iters);
        pointDragons.set(iters, dragon);
    }

    private static void putDragon(FractalDragon dragon, int startSize, int iters) {
        lineDragons.addValue(startSize, iters, dragon);
    }

    public static FractalDragon dragonLSystem(int iterations, boolean blur) {
        String commands = dragon.generate(iterations);
        EntryList2D e2d = new EntryList2D();
        Point2D.Float prev = new Point2D.Float(0.0f, 0.0f);
        ForgeDirection[] eswn = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST, ForgeDirection.NORTH};
        int currentDirection = 0;
        for (char command : commands.toCharArray()) {
            switch (command) {
                case 'F': {
                    Point2D.Float newPoint;
                    int x = (int)((float)eswn[currentDirection % 4].offsetX + prev.x);
                    int z = (int)((float)eswn[currentDirection % 4].offsetZ + prev.y);
                    prev = newPoint = new Point2D.Float(x, z);
                    e2d.addValue(x, z, Float.valueOf(1.0f));
                    break;
                }
                case '+': {
                    ++currentDirection;
                    break;
                }
                case '-': {
                    --currentDirection;
                }
            }
            if (currentDirection >= 0) continue;
            currentDirection += (currentDirection + 4) % 4;
        }
        if (blur) {
            e2d = (EntryList2D)GeometryHelper.sequencedBlur(e2d, 3, true, false, true, false).recreateWithMinAtZero();
        }
        File f = null;
        try {
            f = FractalDragon.useFile(String.valueOf(iterations));
            f.getParentFile().mkdirs();
            f.createNewFile();
            e2d.save(f);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new FractalDragon(e2d, iterations);
    }

    public static FractalDragon dragonLines(int startSize, int iterations, boolean blur) {
        ArrayList<Line2D.Float> lines = FractalDragon.dragonLinesGeom(startSize, iterations).getAll();
        EntryList2D e2d = (EntryList2D)new EntryList2D<Float>().addLines(lines, Float.valueOf(1.0f));
        if (blur) {
            e2d = GeometryHelper.sequencedBlur(e2d, 2, true, false, true, true, false);
        }
        return new FractalDragon(e2d, startSize, iterations);
    }

    public static ShapeHolder<Line2D.Float> dragonLinesGeom(int startingSize, int iterations) {
        Point2D.Float start = new Point2D.Float(0.0f, 0.0f);
        Point2D.Float end = new Point2D.Float(startingSize, 0.0f);
        float newLength = (float)startingSize * 0.707f;
        Point2D mid = new Point2D.Float(newLength, 0.0f);
        mid = left45.transform(mid, null);
        Line2D.Float a = new Line2D.Float(start, mid);
        Line2D.Float b = new Line2D.Float(mid, end);
        ShapeHolder<Line2D.Float> result = new ShapeHolder<Line2D.Float>(a, b);
        for (int i = 0; i <= iterations; ++i) {
            for (ShapeHolder<Line2D.Float> holder : result.getInnermostHolders()) {
                FractalDragon.replaceForDragon(holder);
            }
        }
        return result;
    }

    private static void replaceForDragon(ShapeHolder<Line2D.Float> part) {
        Line2D.Float line1 = (Line2D.Float)part.getA();
        Line2D.Float line2 = (Line2D.Float)part.getB();
        AffineTransform move = AffineTransform.getTranslateInstance(-line1.x1, -line1.y1);
        Point2D.Float mid1 = new Point2D.Float(line1.x2, line1.y2);
        move.transform(mid1, mid1);
        scaleBetween45.transform(mid1, mid1);
        left45.transform(mid1, mid1);
        try {
            move.invert();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        move.transform(mid1, mid1);
        Line2D.Float line1a = new Line2D.Float(line1.x1, line1.y1, mid1.x, mid1.y);
        Line2D.Float line1b = new Line2D.Float(mid1.x, mid1.y, line1.x2, line1.y2);
        move = AffineTransform.getTranslateInstance(-line2.x1, -line2.y1);
        Point2D.Float mid2 = new Point2D.Float(line2.x2, line2.y2);
        move.transform(mid2, mid2);
        scaleBetween45.transform(mid2, mid2);
        right45.transform(mid2, mid2);
        try {
            move.invert();
        }
        catch (NoninvertibleTransformException e) {
            e.printStackTrace();
        }
        move.transform(mid2, mid2);
        Line2D.Float line2a = new Line2D.Float(line2.x1, line2.y1, mid2.x, mid2.y);
        Line2D.Float line2b = new Line2D.Float(mid2.x, mid2.y, line2.x2, line2.y2);
        ShapeHolder<Line2D.Float> holderA = new ShapeHolder<Line2D.Float>(line1a, line1b);
        ShapeHolder<Line2D.Float> holderB = new ShapeHolder<Line2D.Float>(line2a, line2b);
        part.setA(holderA);
        part.setB(holderB);
    }
}

