/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.geom;

import java.util.ArrayList;
import java.util.HashMap;

public class LSystem {
    public ArrayList<Character> vars = new ArrayList();
    private HashMap<Character, String> rules = new HashMap();
    public String start;

    public LSystem(char[] vars, String start, String ... rules) {
        for (char c2 : vars) {
            this.vars.add(Character.valueOf(c2));
        }
        this.start = start;
        for (String rule : rules) {
            this.parseRules(rule);
        }
    }

    private void parseRules(String rule) {
        char key = rule.charAt(0);
        String val = rule.substring(2);
        for (Character c : this.vars) {
            val.replaceAll("" + c, this.vars.indexOf(c) + "");
        }
        this.rules.put(Character.valueOf(key), val);
    }

    public String generate(int iterations) {
        String result = this.start + "";
        for (int i = 0; i < iterations; ++i) {
            for (Character c : this.vars) {
                result = result.replaceAll(c + "", this.vars.indexOf(c) + "");
            }
            for (int j = 0; j < this.vars.size(); ++j) {
                result = result.replaceAll(j + "", this.rules.get(this.vars.get(j)));
            }
        }
        return result;
    }
}

