/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.geom;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.WorldHelper;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.util.Random;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class ShapeHelper {
    private static Random RANDOM = new Random();

    public static Ellipse2D.Float centeredEllipse(float width, float length) {
        return new Ellipse2D.Float(-width / 2.0f, -length / 2.0f, width, length);
    }

    public static Path2D warbledCircle(float diameter, float deviation, Random rand, Point2D[] points) {
        return ShapeHelper.warbledEllipse(diameter, diameter, deviation, rand, points);
    }

    public static Path2D warbledEllipse(float width, float length, float deviation, Random rand, Point2D[] points) {
        int next;
        int i;
        Path2D.Float result = new Path2D.Float();
        Point2D.Float[] circlePoints = new Point2D.Float[4];
        Point2D.Float[] handles1 = new Point2D.Float[4];
        Point2D.Float[] handles2 = new Point2D.Float[4];
        for (i = 0; i < 4; ++i) {
            next = i + 1 > 3 ? 0 : i + 1;
            ForgeDirection dir = WorldHelper.NWSE[i];
            ForgeDirection nextDir = WorldHelper.NWSE[next];
            boolean hortzA = WorldHelper.isHorizontal(dir);
            boolean hortzB = WorldHelper.isHorizontal(nextDir);
            float x = hortzA ? (float)dir.offsetX * width * 0.5f : 0.0f;
            float z = hortzA ? 0.0f : (float)dir.offsetZ * length * 0.5f;
            circlePoints[i] = (Point2D.Float)ShapeHelper.pointNear(x, z, deviation, rand);
            float handleOffsetX = hortzB ? (float)nextDir.offsetX * 0.276f * width : 0.0f;
            float handleOffsetZ = hortzB ? 0.0f : (float)nextDir.offsetZ * 0.276f * length;
            Point2D.Float base = (Point2D.Float)ShapeHelper.pointNear(handleOffsetX, handleOffsetZ, deviation * 0.25f, rand);
            handles1[i] = new Point2D.Float(circlePoints[i].x + base.x, circlePoints[i].y + base.y);
            handles2[i] = new Point2D.Float(circlePoints[i].x - base.x, circlePoints[i].y - base.y);
        }
        for (i = 0; i < 4; ++i) {
            next = i + 1 > 3 ? 0 : i + 1;
            CubicCurve2D.Float curve = ShapeHelper.curveFrom4Points(circlePoints[i], handles1[i], handles2[next], circlePoints[next]);
            result.append(curve, true);
            try {
                points[i] = circlePoints[i];
                points[i + 4] = handles1[i];
                points[i + 8] = handles2[i];
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    public static Point2D pointNear(float x, float z, float deviation, Random rand) {
        if (rand == null) {
            rand = RANDOM;
        }
        return new Point2D.Float(x += RandomHelper.useRandomForNumberBetween(rand, -deviation, deviation), z += RandomHelper.useRandomForNumberBetween(rand, -deviation, deviation));
    }

    public static CubicCurve2D.Float curveFrom4Points(Point2D.Float start, Point2D.Float ctrl1, Point2D.Float ctrl2, Point2D.Float end) {
        return new CubicCurve2D.Float(start.x, start.y, ctrl1.x, ctrl1.y, ctrl2.x, ctrl2.y, end.x, end.y);
    }
}

