/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.helpers;

import com.google.common.collect.ObjectArrays;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.util.testing.Explorer;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.LoaderException;
import cpw.mods.fml.common.LoaderState;
import cpw.mods.fml.common.registry.GameData;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemMultiTexture;
import net.minecraft.util.RegistryNamespaced;
import org.apache.logging.log4j.Level;

public class BlockHelper {
    public static Map<String, Material> materialNamingMap = new HashMap<String, Material>();
    public static final Block utilBlock0 = new UtilBlock(0);
    public static final Block utilBlock1 = new UtilBlock(1);

    public static boolean isBlockNormalCube(Block block) {
        return block.func_149688_o().func_76218_k() && block.func_149686_d() && !block.func_149744_f();
    }

    public static Block demandBlock(String name) {
        if ((name = CommonHelper.textInQuotes(name)).equalsIgnoreCase("util0")) {
            return utilBlock0;
        }
        if (name.equalsIgnoreCase("util1")) {
            return utilBlock1;
        }
        Block result = Block.func_149684_b((String)name.replaceAll(" ", "_"));
        if (result == null) {
            throw new IllegalArgumentException("There is no such block registered with name \"" + name + "\"");
        }
        return result;
    }

    public static Material possiblyParseBlockMaterial(String s) {
        if (!(s = s.toLowerCase()).startsWith("mat")) {
            return null;
        }
        s = s.substring(s.indexOf(".") + 1);
        return materialNamingMap.get(s);
    }

    public static Material parseBlockMaterial(String s) {
        return materialNamingMap.get(s.toLowerCase());
    }

    public static boolean containsBlockOrMat(Object[] array, Block block) {
        for (int i = 0; i < array.length; ++i) {
            if (array[i] instanceof Block && (Block)array[i] == block) {
                return true;
            }
            if (!(array[i] instanceof Material) || block == null || array[i] != block.func_149688_o()) continue;
            return true;
        }
        return false;
    }

    public static Block registerMultiNameBlock(Block block, String name, String[] namesById) {
        return BlockHelper.registerBlock(block, ItemMultiTexture.class, name, null, new Class[]{Block.class, String[].class}, block, namesById);
    }

    public static void exploreBlockRegistry() {
        RegistryNamespaced br = Block.field_149771_c;
        Map map = null;
        for (Field f : RegistryNamespaced.class.getDeclaredFields()) {
            if (!Map.class.isAssignableFrom(f.getType())) continue;
            f.setAccessible(true);
            try {
                map = (Map)f.get(br);
            }
            catch (Exception e) {}
            break;
        }
        Explorer.showSimpleExplorer(map, "Registered Blocks");
    }

    public static Block registerBlock(Block block, Class<? extends ItemBlock> itemclass, String name, String modId, Class[] itemCtorClasses, Object ... itemCtorArgs) {
        if (Loader.instance().isInState(LoaderState.CONSTRUCTING)) {
            FMLLog.warning((String)"The mod %s is attempting to register a block whilst it it being constructed. This is bad modding practice - please use a proper mod lifecycle event.", (Object[])new Object[]{Loader.instance().activeModContainer()});
        }
        try {
            assert (block != null) : "registerBlock: block cannot be null";
            ItemBlock i = null;
            if (itemclass != null) {
                Class[] ctorArgClasses = new Class[itemCtorClasses.length + 1];
                ctorArgClasses[0] = Block.class;
                for (int idx = 1; idx < ctorArgClasses.length; ++idx) {
                    ctorArgClasses[idx] = itemCtorClasses[idx - 1];
                }
                Constructor<? extends ItemBlock> itemCtor = itemclass.getConstructor(ctorArgClasses);
                i = itemCtor.newInstance(ObjectArrays.concat((Object)block, (Object[])itemCtorArgs));
            }
            if (i != null) {
                CommonHelper.callInaccessibleMethod(GameData.class, "registerBlockAndItem", null, new Class[]{ItemBlock.class, Block.class, String.class, String.class}, i, block, name, modId);
            } else {
                CommonHelper.callInaccessibleMethod(GameData.class, "registerBlock", null, new Class[]{Block.class, String.class, String.class}, block, name, modId);
            }
            return block;
        }
        catch (Exception e) {
            FMLLog.log((Level)Level.ERROR, (Throwable)e, (String)"Caught an exception during block registration", (Object[])new Object[0]);
            throw new LoaderException((Throwable)e);
        }
    }

    static {
        Object[] mats = new Object[]{"air", Material.field_151579_a, "anvil", Material.field_151574_g, "cactus", Material.field_151570_A, "cake", Material.field_151568_F, "circuits", Material.field_151594_q, "clay", Material.field_151571_B, "cloth", Material.field_151580_n, "coral", Material.field_151589_v, "craftedsnow", Material.field_151596_z, "dragonegg", Material.field_151566_D, "fire", Material.field_151581_o, "glass", Material.field_151592_s, "gourd", Material.field_151572_C, "grass", Material.field_151577_b, "ground", Material.field_151578_c, "ice", Material.field_151588_w, "iron", Material.field_151573_f, "lava", Material.field_151587_i, "leaves", Material.field_151584_j, "piston", Material.field_76233_E, "plants", Material.field_151585_k, "portal", Material.field_151567_E, "redstonelight", Material.field_151591_t, "rock", Material.field_151576_e, "sand", Material.field_151595_p, "snow", Material.field_151597_y, "sponge", Material.field_151583_m, "tnt", Material.field_151590_u, "vine", Material.field_151582_l, "water", Material.field_151586_h, "web", Material.field_151569_G, "wood", Material.field_151575_d, "carpet", Material.field_151593_r, "metal", Material.field_151573_f, "stone", Material.field_151576_e};
        CommonHelper.addEntries(materialNamingMap, mats);
    }

    public static class UtilBlock
    extends Block {
        int u;

        protected UtilBlock(int u) {
            super(Material.field_151579_a);
            this.u = u;
        }
    }
}

