/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.helpers;

import com.pixelmonmod.pixelmon.util.Array2D;
import com.pixelmonmod.pixelmon.util.IList2D;
import com.pixelmonmod.pixelmon.util.Link2D;
import java.util.HashMap;

public class GeometryHelper {
    public static final double PHI = 1.618033988749895;

    public static double logistic(double x, double a, double b, double c) {
        return c / (1.0 + a * Math.pow(Math.E, -b * x));
    }

    public static double angleDeg(double xD, double yD) {
        return Math.toDegrees(Math.atan2(yD, xD));
    }

    public static double sin(double x, double a, double shift, double scale) {
        return scale * Math.sin((float)((x + shift) / a * Math.PI));
    }

    public static double slider(double x, double min, double max) {
        return GeometryHelper.clampDouble((x - min) / (max - min), 0.0, 1.0);
    }

    public static double inverseSlider(double x, double min, double max) {
        return x * (max - min) + min;
    }

    public static double lineSlider(double x, double x1, double x2, double y1, double y2) {
        return GeometryHelper.inverseSlider(GeometryHelper.slider(x, x1, x2), y1, y2);
    }

    public static double clampDouble(double in, double min, double max) {
        return in < min ? min : (in > max ? max : in);
    }

    public static int even(int i) {
        return i & 0xFFFFFFFE;
    }

    public static double perfectSin(double x, double length, double minIN, double maxIN) {
        System.out.print("Min = " + minIN + ", max = " + maxIN);
        double input = GeometryHelper.slider(x, minIN, maxIN);
        double result = GeometryHelper.sin(input, length, length * 0.5, 1.0);
        System.out.println(", In = " + x + ", input = " + input + ", result = " + result);
        return result;
    }

    public static double dist(double x1, double y1, double x2, double y2) {
        return Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
    }

    public static double dist(double x, double y, double z) {
        return Math.sqrt(x * x + y * y + z * z);
    }

    public static HashMap<Integer, HashMap<Integer, Double>> weirdBlur(HashMap<Integer, HashMap<Integer, Double>> points, int radius) {
        for (Integer i : points.keySet()) {
            HashMap<Integer, Double> column = points.get(i);
            for (Integer j : column.keySet()) {
                Double point = column.get(j);
                double average = 0.0;
                float div = 0.0f;
                for (int x = -radius; x <= radius; ++x) {
                    for (int y = -radius; y <= radius; ++y) {
                        div += 1.0f;
                        Double add = null;
                        try {
                            add = points.get(i + x).get(j + y);
                        }
                        catch (NullPointerException e) {
                            add = 0.0;
                        }
                        average += add != null ? add : 0.0;
                    }
                }
                System.out.println(average);
                points.get(i).put(j, average /= (double)div);
            }
        }
        return points;
    }

    public static <T extends IList2D<Float>> T boxBlur(T points, int radius) {
        return GeometryHelper.allBlur(points, radius, true);
    }

    public static <T extends IList2D<Float>> T limitedBlur(T points, int radius) {
        return GeometryHelper.allBlur(points, radius, false);
    }

    private static <T extends IList2D<Float>> T allBlur(T points, int radius, boolean nulls) {
        IList2D result = points.createNew();
        if (result instanceof Array2D) {
            Array2D src = (Array2D)points;
            ((Array2D)result).setZero(src.minX(), src.minZ());
        }
        for (Link2D link : points) {
            if (link.value == null) continue;
            int i = link.x;
            int j = link.z;
            float average = 0.0f;
            float div = 0.0f;
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    Float add = points.get(x + i, y + j);
                    if (!nulls && add == null) continue;
                    average += add != null ? add.floatValue() : 0.0f;
                    div += 1.0f;
                }
            }
            result.addValue(i, j, Float.valueOf(average /= div));
        }
        return (T)result;
    }

    public static <T extends IList2D<Float>> T gaussianBlur(T points, int radius) {
        T result = points;
        for (int i = 0; i < 3; ++i) {
            result = GeometryHelper.boxBlur(result, radius);
        }
        return result;
    }

    public static <T extends IList2D<Float>> T sequencedBlur(T points, int radius, boolean ... extendBeyond) {
        for (int i = 0; i < extendBeyond.length; ++i) {
            points = GeometryHelper.allBlur(points, radius, extendBeyond[i]);
        }
        return points;
    }

    public static enum FunctionType {
        LOG,
        SIN,
        PERFECTSIN;


        public double function(double input, double ... args) {
            switch (this) {
                case LOG: {
                    return GeometryHelper.logistic(input, args[0], args[1], args[2]);
                }
                case SIN: {
                    return GeometryHelper.sin(input, args[0], args[1], args[2]);
                }
                case PERFECTSIN: {
                    return GeometryHelper.perfectSin(input, args[0], args[1], args[2]);
                }
            }
            return Double.NEGATIVE_INFINITY;
        }
    }
}

