/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.testing;

import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.Array2D;
import com.pixelmonmod.pixelmon.util.Iterable2D;
import com.pixelmonmod.pixelmon.util.Link2D;
import com.pixelmonmod.pixelmon.util.PixelmonDebug;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;

public abstract class AbstractDrawable {
    protected boolean statedDrawingException = false;

    public abstract void draw(Graphics2D var1);

    public static class ImageDrawing
    extends AbstractDrawable {
        BufferedImage img;

        public ImageDrawing(BufferedImage img) {
            this.img = img;
        }

        @Override
        public void draw(Graphics2D g2d) {
            g2d.drawImage((Image)this.img, 10, 10, null);
        }
    }

    public static class NonNullDrawing
    extends AbstractDrawable {
        private ListingWrapper points;

        public NonNullDrawing(Iterable2D points) {
            this.points = new ListingWrapper(points);
        }

        public NonNullDrawing(Collection<Integer> points) {
            this.points = new ListingWrapper<Integer>(points);
        }

        @Override
        public void draw(Graphics2D g2d) {
            if (this.points.is2D) {
                this.draw2D(g2d);
            } else {
                this.draw1D(g2d);
            }
        }

        public void draw1D(Graphics2D g2d) {
            Collection list = (Collection)this.points.getListing();
            Iterator i$ = list.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                g2d.setColor(Color.WHITE);
                g2d.drawRect(i, 0, 0, 0);
            }
        }

        public void draw2D(Graphics2D g2d) {
            Iterable2D l2d = (Iterable2D)this.points.getListing();
            for (Link2D link : l2d) {
                g2d.setColor(Color.WHITE);
                g2d.drawRect(link.x, link.z, 0, 0);
            }
        }
    }

    public static class LineDrawing
    extends AbstractDrawable {
        Collection<? extends Line2D> lines;

        public LineDrawing(Collection<? extends Line2D> lines) {
            this.lines = lines;
            System.out.println("The LineDrawing from " + PixelmonDebug.prevMethod() + " contains " + lines.size() + " lines.");
        }

        @Override
        public void draw(Graphics2D g2d) {
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setColor(Color.WHITE);
            for (Line2D line2D : this.lines) {
                g2d.drawLine((int)line2D.getX1(), (int)line2D.getY1(), (int)line2D.getX2(), (int)line2D.getY2());
            }
        }
    }

    public static class FloatDrawing
    extends AbstractDrawable {
        ListingWrapper<Float> points;

        public FloatDrawing(Iterable2D<Float> i2d) {
            this.points = new ListingWrapper<Float>(i2d);
        }

        @Override
        public void draw(Graphics2D g2d) {
            block4: {
                block3: {
                    if (!(((ListingWrapper)this.points).listing instanceof Iterable2D)) break block3;
                    Iterable2D pointsItr = (Iterable2D)((ListingWrapper)this.points).listing;
                    for (Link2D link : pointsItr) {
                        float height = ((Float)link.value).floatValue();
                        int i = link.x;
                        int j = link.z;
                        g2d.setColor(new Color(height, height, height));
                        g2d.drawRect(i, j, 1, 1);
                    }
                    break block4;
                }
                if (!(((ListingWrapper)this.points).listing instanceof AbstractList2D)) break block4;
                AbstractList2D l2d = (AbstractList2D)((ListingWrapper)this.points).listing;
                for (Integer i : l2d.xList()) {
                    TreeSet<Integer> column = l2d.zList(i);
                    for (Integer j : column) {
                        float height = ((Float)l2d.get(i, j)).floatValue();
                        g2d.setColor(new Color(height, height, height));
                        g2d.drawRect(i, j, 1, 1);
                    }
                }
            }
        }
    }

    public static class IntegerDrawing
    extends AbstractDrawable {
        ListingWrapper<Integer> points;
        private double min;
        private double max;

        public IntegerDrawing(Array2D<Integer> points) {
            this.points = new ListingWrapper<Integer>(points);
            HashSet<Integer> values = points.valueSet();
            this.min = (double)Collections.min(values).intValue() - 0.1;
            this.max = Collections.max(values).intValue();
        }

        public IntegerDrawing(AbstractList2D<Integer> points) {
            this.points = new ListingWrapper<Integer>(points);
            this.min = points.minVal() - 0.1;
            this.max = points.maxVal();
        }

        public IntegerDrawing(Map<Integer, Integer> points) {
            this.points = new ListingWrapper<Integer>(points);
            this.min = (double)Collections.min(points.values()).intValue() - 0.1;
            this.max = Collections.max(points.values()).intValue();
        }

        public IntegerDrawing(AbstractList2D<Integer> points, double minDifference) {
            this.points = new ListingWrapper<Integer>(points);
            this.min = points.minVal() - Math.abs(minDifference);
            this.max = points.maxVal();
            if (this.min >= this.max) {
                this.min = this.max - 0.1;
            }
        }

        public IntegerDrawing(Map<Integer, Integer> points, double minDifference) {
            this.points = new ListingWrapper<Integer>(points);
            this.min = (double)Collections.min(points.values()).intValue() - Math.abs(minDifference);
            this.max = Collections.max(points.values()).intValue();
            if (this.min >= this.max) {
                this.min = this.max - 0.1;
            }
        }

        @Override
        public void draw(Graphics2D g2d) {
            if (this.points.is2D()) {
                this.draw2D(g2d);
            } else {
                this.draw1D(g2d);
            }
        }

        public void draw2D(Graphics2D g2d) {
            block4: {
                Object listing;
                block3: {
                    listing = ((ListingWrapper)this.points).listing;
                    if (!(listing instanceof Iterable2D)) break block3;
                    Iterable2D pointsItr = (Iterable2D)listing;
                    for (Link2D link : pointsItr) {
                        int i = link.x;
                        int j = link.z;
                        float value = (float)GeometryHelper.slider(((Integer)link.value).intValue(), this.min, this.max);
                        g2d.setColor(new Color(value, value, value));
                        g2d.drawRect(i, j, 0, 0);
                    }
                    break block4;
                }
                if (!(listing instanceof AbstractList2D)) break block4;
                AbstractList2D l2d = (AbstractList2D)listing;
                for (Integer i : l2d.xList()) {
                    TreeSet<Integer> column = l2d.zList(i);
                    for (Integer j : column) {
                        float value = (float)GeometryHelper.slider(((Integer)l2d.get(i, j)).intValue(), this.min, this.max);
                        g2d.setColor(new Color(value, value, value));
                        g2d.drawRect(i, j, 0, 0);
                    }
                }
            }
        }

        public void draw1D(Graphics2D g2d) {
            Map map = (Map)this.points.getListing();
            for (Integer i : map.keySet()) {
                float value = (float)GeometryHelper.slider(((Integer)map.get(i)).intValue(), this.min, this.max);
                g2d.setColor(new Color(value, value, value));
                g2d.drawRect(i, 0, 0, 0);
            }
        }
    }

    public static class ListingWrapper<T> {
        private Object listing;
        private boolean is2D;

        public ListingWrapper(AbstractList2D<T> list2d) {
            this.listing = list2d;
            this.is2D = true;
        }

        public ListingWrapper(Collection<T> list) {
            this.listing = list;
            this.is2D = false;
        }

        public ListingWrapper(Map<Integer, T> map) {
            this.listing = map;
            this.is2D = false;
        }

        public ListingWrapper(Iterable2D<T> i2d) {
            this.listing = i2d;
            this.is2D = true;
        }

        public boolean is2D() {
            return this.is2D;
        }

        public Object getListing() {
            return this.listing;
        }
    }
}

