/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.testing;

import com.pixelmonmod.pixelmon.client.materials.EnumMaterialOption;
import com.pixelmonmod.pixelmon.client.materials.Lighting;
import com.pixelmonmod.pixelmon.util.testing.IDrawableGL;
import com.pixelmonmod.pixelmon.util.testing.Navigator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.awt.Canvas;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import net.minecraft.util.Vec3;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;
import org.lwjgl.util.vector.Vector3f;

public class Canvas3D {
    int displayWidth;
    int displayHeight;
    float xr = 0.0f;
    float yr;
    float zr;
    float farPlaneDistance;
    float zoom = 0.0f;
    boolean fullscreen = false;
    boolean solidFaces = true;
    boolean lighting = true;
    Canvas canvas;
    Collection<IDrawableGL> drawables = new ArrayList<IDrawableGL>();

    public Canvas3D(int displayWidth, int displayHeight, float farPlaneDist) {
        this.displayWidth = displayWidth;
        this.displayHeight = displayHeight;
        this.farPlaneDistance = farPlaneDist;
        try {
            Display.setDisplayMode((DisplayMode)new DisplayMode(this.displayWidth, this.displayHeight));
            Display.setTitle((String)"3D Testing Grid");
            Display.create();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GL11.glMatrixMode((int)5889);
        GL11.glLoadIdentity();
        GLU.gluPerspective((float)30.0f, (float)((float)displayWidth / (float)displayHeight), (float)0.5f, (float)farPlaneDist);
        GL11.glMatrixMode((int)5888);
    }

    public static Canvas3D create() {
        Canvas3D result = new Canvas3D(1000, 700, 3000.0f);
        Navigator.register(result);
        return result;
    }

    public void addDrawables(IDrawableGL ... ds) {
        Collections.addAll(this.drawables, ds);
    }

    public void setWireframe(boolean flag) {
        this.solidFaces = !flag;
    }

    public void setLighting(boolean flag) {
        this.lighting = flag;
    }

    public void safeStart() {
        try {
            this.start();
        }
        catch (LWJGLException e) {
            e.printStackTrace();
        }
    }

    public void start() throws LWJGLException {
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-1000.0f);
        GL11.glEnable((int)2929);
        GL11.glDepthFunc((int)513);
        if (!this.solidFaces) {
            EnumMaterialOption.WIREFRAME.begin(new Object[0]);
        }
        while (!Display.isCloseRequested()) {
            GL11.glColor3f((float)0.5f, (float)0.5f, (float)0.5f);
            Navigator.onTick();
            GL11.glClear((int)16640);
            GL11.glMatrixMode((int)5888);
            GL11.glLoadIdentity();
            if (this.lighting) {
                Lighting.attempt(0.0f, 50.0f, 0.0f);
            }
            GL11.glTranslatef((float)0.0f, (float)0.0f, (float)this.zoom);
            GL11.glRotatef((float)this.xr, (float)1.0f, (float)0.0f, (float)0.0f);
            GL11.glRotatef((float)-45.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GL11.glTranslatef((float)0.0f, (float)-200.0f, (float)0.0f);
            for (IDrawableGL drawable : this.drawables) {
                drawable.draw();
            }
            Display.update();
            this.xr -= 0.2f;
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        Display.destroy();
    }

    @SubscribeEvent
    public void onMouseEvent(Navigator.MouseEvent e) {
        this.zoom += (float)e.scrollwheel;
    }

    public static void drawLine(Vector3f point1, Vector3f point2) {
        Canvas3D.drawLine(point1.x, point1.y, point1.z, point2.x, point2.y, point2.z);
    }

    public static void drawLine(Vec3 point1, Vec3 point2) {
        Canvas3D.drawLine(point1.field_72450_a, point1.field_72448_b, point1.field_72449_c, point2.field_72450_a, point2.field_72448_b, point2.field_72449_c);
    }

    public static void drawLine(double x1, double y1, double z1, double x2, double y2, double z2) {
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)x1, (double)y1, (double)z1);
        GL11.glVertex3d((double)x2, (double)y2, (double)z2);
        GL11.glEnd();
    }
}

