/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.testing;

import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.Array2D;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.Iterable2D;
import com.pixelmonmod.pixelmon.util.NBTTools;
import com.pixelmonmod.pixelmon.util.geom.Fractal;
import com.pixelmonmod.pixelmon.util.geom.FractalDragon;
import com.pixelmonmod.pixelmon.util.geom.ShapeHelper;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;
import com.pixelmonmod.pixelmon.util.testing.AbstractDrawable;
import com.pixelmonmod.pixelmon.util.testing.StopWatch;
import com.pixelmonmod.pixelmon.util.testing.TestingCanvas;
import com.pixelmonmod.pixelmon.util.testing.Testomatic;
import com.pixelmonmod.pixelmon.worldGeneration.PathExcavator;
import com.pixelmonmod.pixelmon.worldGeneration.WorldGenMysteryDungeon;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.DungeonEntranceStandard;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.MysteryDungeonFloor;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.RoomMarker;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import javax.swing.JFileChooser;

public class DemoDrawingsAwt {
    @Testomatic.MethodName(name="Path Excavator")
    public static void pathExcavator() {
        PathExcavator excavator = new PathExcavator(0, 10, 20, -16, 0);
        AbstractList2D<Integer> path = excavator.genPath(new Random(), 0);
        AbstractList2D.sumCheckerBoard(path, -1);
        TestingCanvas canvas = TestingCanvas.createSimpleScreen(1000, 700, "Path Excavator");
        canvas.setDrawables(new AbstractDrawable.IntegerDrawing(path));
        canvas.setTranslation(150.0, 250.0);
        canvas.setScale(10.0, 10.0);
    }

    @Testomatic.MethodName(name="Mystery Dungeon Room's Edge")
    public static void roomEdge() {
        RoomMarker room = new RoomMarker(4, 4, 25, 75, 1, false);
        TestingCanvas canvas = TestingCanvas.createSimpleScreen(1000, 700, "Room Edge Test");
        canvas.setDrawables(new AbstractDrawable.IntegerDrawing(room.getAllEdgePoints(false).checkerboard(1)));
        canvas.setTranslation(15.0, 15.0);
        canvas.setScale(5.0, 5.0);
    }

    @Testomatic.MethodName(name="Complete 10-Floor Mystery Dungeon")
    public static void mysteryDungeonFull() {
        int floor = 1;
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        Random random = new Random();
        MysteryDungeonFloor[] floors = new MysteryDungeonFloor[10];
        Array2D<Integer>[] floorMaps = WorldGenMysteryDungeon.floorMaps(65, 65, floors, random, true);
        stopwatch.suspend();
        System.out.println(stopwatch.describe());
        for (int i = 0; i < 10; ++i) {
            Array2D<Integer> floorMap = floorMaps[i];
            if (i == 0) {
                DungeonEntranceStandard.entrancesOn4Sides(floors[i], floorMap, random);
            }
            TestingCanvas canvas = TestingCanvas.createSimpleScreen(1000, 700, "MysteryDungeon - Floor " + floor++);
            canvas.setDrawables(new AbstractDrawable.IntegerDrawing(floorMap));
            canvas.setTranslation(50.0, 50.0);
            canvas.setScale(9.0, 9.0);
        }
    }

    @Testomatic.MethodName(name="Single Mystery Dungeon Floor")
    public static void newDungeonFloor() {
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        Random rand = new Random();
        MysteryDungeonFloor dungeon = new MysteryDungeonFloor(65, 65, 1, rand, false);
        Array2D<Integer> ints = dungeon.floorMain(new Random(), 2);
        stopwatch.suspend();
        System.out.println(stopwatch.describe());
        TestingCanvas canvas = TestingCanvas.createSimpleScreen(1000, 700, "Mystery Dungeon");
        canvas.setDrawables(new AbstractDrawable.IntegerDrawing(ints));
        canvas.setTranslation(50.0, 50.0);
        canvas.setScale(10.0, 10.0);
    }

    @Testomatic.MethodName(name="Warbled Ellipse")
    public static void warbledEllipse() {
        Point2D[] circleparts = new Point2D[12];
        Path2D warb = ShapeHelper.warbledEllipse(128.0f, 64.0f, 5.0f, null, circleparts);
        AbstractList2D<Float> points = new EntryList2D<Float>().modifyWithShape(warb, Float.valueOf(1.0f));
        EntryList2D<Integer> circlePoints = new EntryList2D<Integer>();
        for (Point2D p : circleparts) {
            circlePoints.addValue((int)p.getX(), (int)p.getY(), 1);
        }
        points = GeometryHelper.sequencedBlur(points, 3, true, false);
        TestingCanvas canvas = TestingCanvas.createSimpleScreen(1000, 700, "Warbled circle");
        canvas.setDrawables(new AbstractDrawable.FloatDrawing(points), new AbstractDrawable.IntegerDrawing(circlePoints));
        canvas.setTranslation(100.0, 100.0);
    }

    @Testomatic.MethodName(name="Dragon Fractal (L-System based)")
    public static void dragon() {
        TestingCanvas canvas = TestingCanvas.createSimpleScreen("Dragon");
        Testomatic.showConcurrentDialog("Just so you know...", "This may take a couple of seconds", 500L);
        Iterable2D dragon = FractalDragon.dragonLSystem((int)9, (boolean)true).geometry;
        canvas.setDrawables(new AbstractDrawable.FloatDrawing(dragon));
        canvas.setTranslation(200.0, 50.0);
    }

    @Testomatic.MethodName(name="Golden Dragon Fractal (Totally Awesome!)")
    public static void goldDragonLines() {
        TestingCanvas canvas = TestingCanvas.createSimpleScreen(1000, 700, "Golden Dragon");
        Testomatic.showConcurrentDialog("Hey", "Move the big window to get it to refresh and show the fractal.", 2000L);
        StopWatch gDragonTimer = new StopWatch("Golden Dragon Timer");
        gDragonTimer.start();
        ArrayList<Line2D.Float> lines = Fractal.goldDragonLines(1200, 15).getAll();
        gDragonTimer.stop();
        System.out.println(gDragonTimer.describe());
        canvas.setTranslation(350.0, 500.0);
        canvas.setScale(0.5, 0.5);
        canvas.setDrawables(new AbstractDrawable.LineDrawing(lines));
    }

    @Testomatic.MethodName(name="Dragon Fractal (Line based)")
    public static void dragonLines() {
        TestingCanvas canvas = TestingCanvas.createSimpleScreen(1000, 700, "Non-LSystem Dragon");
        StopWatch dragonTimer = new StopWatch("Dragon Timer");
        dragonTimer.start();
        ArrayList<Line2D.Float> lines = FractalDragon.dragonLinesGeom(300, 15).getAll();
        dragonTimer.stop();
        System.out.println(dragonTimer.describe());
        canvas.setTranslation(350.0, 500.0);
        canvas.setScale(0.5, 0.5);
        canvas.setDrawables(new AbstractDrawable.LineDrawing(lines));
    }

    @Testomatic.MethodName(name="Golden Dragon Fractal as AbstractList2D")
    public static void goldDragonPoints() {
        TestingCanvas canvas = TestingCanvas.createSimpleScreen(1000, 700, "Golden Dragon 2");
        canvas.setTranslation(300.0, 350.0);
        AbstractList2D<Float> points = Fractal.goldDragon(350, 15, true);
        canvas.setDrawables(new AbstractDrawable.FloatDrawing(points));
    }

    @Testomatic.MethodName(name="MBrot fractal")
    public static void MBrot() {
        TestingCanvas canvas = TestingCanvas.createSimpleScreen(1000, 700, "FractalTest");
        Fractal.MBrot(canvas, 700);
    }

    @Testomatic.MethodName(name="AbstractList2D from File")
    public static void fileDrawing() {
        JFileChooser chooser = new JFileChooser(Testomatic.MCPFolder());
        int choice = chooser.showOpenDialog(null);
        if (choice == 0) {
            File l2dFile = chooser.getSelectedFile();
            try {
                EntryList2D<Integer> values = new EntryList2D<Integer>();
                values.readNBT(NBTTools.loadNBT(l2dFile));
                Object avalue = values.getOneValue();
                AbstractDrawable drawable = avalue instanceof Integer ? new AbstractDrawable.IntegerDrawing(values) : (avalue instanceof Float ? new AbstractDrawable.FloatDrawing(values) : new AbstractDrawable.NonNullDrawing(values));
                TestingCanvas canvas = TestingCanvas.createSimpleScreen("AbstractList2D from file: \"" + l2dFile.getName() + "\" , number of values = " + values.size());
                canvas.setDrawables(drawable);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

