/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.testing;

import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;

public class Explorer
extends JTree {
    public Explorer(Collection col) {
        super(Explorer.addNodes(new DefaultMutableTreeNode(), col));
    }

    public Explorer(Map map) {
        super(Explorer.addNodes(new DefaultMutableTreeNode(), map));
    }

    public Explorer(NBTTagCompound nbt) {
        super(Explorer.addNodes(new DefaultMutableTreeNode(), nbt));
    }

    public static void showSimpleExplorer(Collection col, String name) {
        Explorer expl = new Explorer(col);
        JScrollPane treeView = new JScrollPane(expl);
        JFrame frame = new JFrame(name);
        frame.setDefaultCloseOperation(2);
        frame.add(treeView);
        frame.pack();
        frame.setVisible(true);
    }

    public static void showSimpleExplorer(Map map, String name) {
        Explorer expl = new Explorer(map);
        JScrollPane treeView = new JScrollPane(expl);
        JFrame frame = new JFrame(name);
        frame.setDefaultCloseOperation(2);
        frame.add(treeView);
        frame.pack();
        frame.setVisible(true);
    }

    public static void showSimpleExplorer(NBTTagCompound nbt, String name) {
        Explorer expl = new Explorer(nbt);
        JScrollPane treeView = new JScrollPane(expl);
        JFrame frame = new JFrame(name);
        frame.setDefaultCloseOperation(2);
        frame.add(treeView);
        frame.pack();
        frame.setVisible(true);
    }

    protected static DefaultMutableTreeNode addNodes(DefaultMutableTreeNode branch, Map map) {
        Set entries = map.entrySet();
        for (Map.Entry e : entries) {
            DefaultMutableTreeNode item = new DefaultMutableTreeNode(e.getKey() + "(mapentry)");
            branch.add(item);
            Explorer.addNodes(item, e.getValue());
        }
        return branch;
    }

    protected static DefaultMutableTreeNode addNodes(DefaultMutableTreeNode branch, Collection collection) {
        for (Object o : collection) {
            Explorer.addNodes(branch, o);
        }
        return branch;
    }

    protected static <T> DefaultMutableTreeNode addNodes(DefaultMutableTreeNode branch, T[] array) {
        for (T o : array) {
            DefaultMutableTreeNode item = new DefaultMutableTreeNode(o + "(array)");
            branch.add(item);
            Explorer.addNodes(item, o);
        }
        return branch;
    }

    protected static DefaultMutableTreeNode addNodes(DefaultMutableTreeNode branch, NBTTagCompound nbt) {
        Map nbtMap = CommonHelper.getMap(nbt);
        for (Map.Entry e : nbtMap.entrySet()) {
            DefaultMutableTreeNode item = new DefaultMutableTreeNode(e.getKey());
            branch.add(item);
            Explorer.addNodes(item, e.getValue());
        }
        return branch;
    }

    protected static DefaultMutableTreeNode addNodes(DefaultMutableTreeNode branch, NBTTagList nbt) {
        ArrayList<NBTBase> list = CommonHelper.getList(nbt);
        int i = 0;
        for (NBTBase o : list) {
            DefaultMutableTreeNode enclosure = new DefaultMutableTreeNode(i++ + "(taglist)");
            branch.add(enclosure);
            Explorer.addNodes(enclosure, o);
        }
        return branch;
    }

    protected static <T> void addNodes(DefaultMutableTreeNode branch, Object thingy) {
        if (thingy == null) {
            Explorer.addNodes(branch, "NULL");
            return;
        }
        if ((thingy = Explorer.getData(thingy)) instanceof Collection) {
            Explorer.addNodes(branch, (Collection)thingy);
        } else if (thingy instanceof Map) {
            Explorer.addNodes(branch, (Map)thingy);
        } else if (thingy instanceof NBTTagCompound) {
            Explorer.addNodes(branch, (NBTTagCompound)thingy);
        } else if (thingy instanceof NBTTagList) {
            Explorer.addNodes(branch, (NBTTagList)thingy);
        } else if (thingy.getClass().isArray()) {
            Object[] array = CommonHelper.wrapperArray(thingy);
            System.out.println(array.getClass());
            Explorer.addNodes(branch, array);
        } else {
            branch.add(new DefaultMutableTreeNode(thingy));
        }
    }

    protected static Object getData(Object value) {
        if (value instanceof NBTTagInt) {
            return ((NBTTagInt)value).func_150287_d();
        }
        if (value instanceof NBTTagShort) {
            return ((NBTTagShort)value).func_150289_e();
        }
        if (value instanceof NBTTagLong) {
            return ((NBTTagLong)value).func_150291_c();
        }
        if (value instanceof NBTTagFloat) {
            return Float.valueOf(((NBTTagFloat)value).func_150288_h());
        }
        if (value instanceof NBTTagDouble) {
            return ((NBTTagDouble)value).func_150286_g();
        }
        if (value instanceof NBTTagByte) {
            return ((NBTTagByte)value).func_150290_f();
        }
        if (value instanceof NBTTagString) {
            return ((NBTTagString)value).func_150285_a_();
        }
        if (value instanceof NBTTagIntArray) {
            return ((NBTTagIntArray)value).func_150302_c();
        }
        if (value instanceof NBTTagByteArray) {
            return ((NBTTagByteArray)value).func_150292_c();
        }
        if (value instanceof NBTTagEnd) {
            return "||END||";
        }
        return value;
    }
}

