/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.testing;

import com.pixelmonmod.pixelmon.util.IList2D;
import com.pixelmonmod.pixelmon.util.Link2D;
import com.pixelmonmod.pixelmon.util.helpers.VectorHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.client.model.obj.Face;
import net.minecraftforge.client.model.obj.Vertex;
import org.lwjgl.util.vector.Vector3f;

public interface IDrawableGL {
    public void draw();

    public static class NumberMesh
    implements IDrawableGL {
        public Collection<Face> faces = new ArrayList<Face>();
        float yScale;
        float xzScale;

        public NumberMesh(IList2D<? extends Number> i2d, float xzScale, float yScale) {
            this.yScale = yScale;
            this.xzScale = xzScale;
            NumberMesh.fillFaces(this.faces, i2d, xzScale, yScale);
        }

        public static void fillFaces(Collection<Face> faces, IList2D<? extends Number> i2d, float xzScale, float yScale) {
            for (Link2D link2D : i2d) {
                if (link2D.value == null) continue;
                int x = link2D.x;
                int z = link2D.z;
                Vector3f current = new Vector3f((float)x * xzScale, ((Number)link2D.value).floatValue() * yScale, (float)z * xzScale);
                Vector3f east = VectorHelper.createOrNull(Float.valueOf((float)(x + 1) * xzScale), i2d.get(x + 1, z), Float.valueOf((float)z * xzScale));
                Vector3f south = VectorHelper.createOrNull(Float.valueOf((float)x * xzScale), i2d.get(x, z + 1), Float.valueOf((float)(z + 1) * xzScale));
                Vector3f southEast = VectorHelper.createOrNull(Float.valueOf((float)(x + 1) * xzScale), i2d.get(x + 1, z + 1), Float.valueOf((float)(z + 1) * xzScale));
                if (east == null || south == null) continue;
                east.y *= yScale;
                south.y *= yScale;
                Vertex vc = new Vertex(current.x, current.y, current.z);
                Vertex ve = new Vertex(east.x, east.y, east.z);
                Vertex vs = new Vertex(south.x, south.y, south.z);
                if (southEast != null) {
                    southEast.y *= yScale;
                    Vertex vse = new Vertex(southEast.x, southEast.y, southEast.z);
                    Face f = new Face();
                    f.vertices = new Vertex[]{vc, ve, vse, vs};
                    faces.add(f);
                    continue;
                }
                Face f = new Face();
                f.vertices = new Vertex[]{vc, ve, vs};
                faces.add(f);
            }
        }

        @Override
        public void draw() {
            for (Face f : this.faces) {
                if (f.vertices.length == 3) {
                    Tessellator.field_78398_a.func_78371_b(4);
                } else {
                    Tessellator.field_78398_a.func_78382_b();
                }
                f.addFaceForRender(Tessellator.field_78398_a);
                Tessellator.field_78398_a.func_78381_a();
            }
        }
    }

    public static class BoxMesh
    implements IDrawableGL {
        public static HashMap<StructureBoundingBox, BoxMesh> meshMap = new HashMap();
        float x;
        float y;
        float z;
        Face[] faces = new Face[6];

        public BoxMesh(StructureBoundingBox box) {
            this(box.field_78897_a, box.field_78895_b, box.field_78896_c, box.field_78893_d, box.field_78894_e, box.field_78892_f);
        }

        public BoxMesh(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            this.fillFaces(minX, minY, minZ, maxX, maxY, maxZ);
            this.x = minX;
            this.y = minY;
            this.z = minZ;
        }

        public static BoxMesh get(StructureBoundingBox bbox) {
            BoxMesh result = meshMap.get(bbox);
            if (result == null) {
                result = new BoxMesh(bbox);
                meshMap.put(bbox, result);
            }
            return result;
        }

        public boolean equals(Object o) {
            if (!(o instanceof BoxMesh)) {
                return false;
            }
            BoxMesh other = (BoxMesh)o;
            return other.x == this.x && other.y == this.y && other.z == this.z;
        }

        @Override
        public void draw() {
            Tessellator.field_78398_a.func_78382_b();
            for (int i = 0; i < this.faces.length; ++i) {
                if (this.faces[i] == null) continue;
                this.faces[i].addFaceForRender(Tessellator.field_78398_a);
            }
            Tessellator.field_78398_a.func_78381_a();
        }

        private Face face(Vertex v1, Vertex v2, Vertex v3, Vertex v4) {
            Face result = new Face();
            result.vertices = new Vertex[]{v1, v2, v3, v4};
            return result;
        }

        private void fillFaces(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
            Vertex v1 = new Vertex(minX, minY, minZ);
            Vertex v2 = new Vertex(minX, maxY, minZ);
            Vertex v3 = new Vertex(maxX, maxY, minZ);
            Vertex v4 = new Vertex(maxX, minY, minZ);
            Vertex v5 = new Vertex(minX, minY, maxZ);
            Vertex v6 = new Vertex(minX, maxY, maxZ);
            Vertex v7 = new Vertex(maxX, maxY, maxZ);
            Vertex v8 = new Vertex(maxX, minY, maxZ);
            this.faces[0] = this.face(v4, v3, v2, v1);
            this.faces[1] = this.face(v1, v2, v6, v5);
            this.faces[2] = this.face(v2, v3, v7, v6);
            this.faces[3] = this.face(v3, v4, v8, v7);
            this.faces[4] = this.face(v4, v1, v5, v8);
            this.faces[5] = this.face(v5, v6, v7, v8);
        }
    }
}

