/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.testing;

import com.pixelmonmod.pixelmon.util.testing.Testomatic;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.JFileChooser;
import net.minecraftforge.client.model.obj.Face;
import net.minecraftforge.client.model.obj.Vertex;

public class ObjExporter {
    protected static File prevFile = Testomatic.MCPFolder();

    public static void export(Collection<Face> faces) {
        JFileChooser chooser = new JFileChooser(prevFile);
        int choice = chooser.showSaveDialog(null);
        if (choice != 0) {
            return;
        }
        File objFile = chooser.getSelectedFile();
        prevFile = objFile.getParentFile();
        ObjExporter.export(faces, objFile);
    }

    public static void export(Collection<Face> faces, File file) {
        System.out.println("exporting " + faces.size() + " faces.");
        FileWriter fwriter = null;
        try {
            file.getParentFile().mkdirs();
            file.createNewFile();
            fwriter = new FileWriter(file);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        BufferedWriter writer = new BufferedWriter(fwriter);
        boolean vertID = false;
        HashSet<String> vertexLines = new HashSet<String>();
        HashSet<String> faceLines = new HashSet<String>();
        for (Face f : faces) {
            for (Vertex v : f.vertices) {
                String s = ObjExporter.vert2String(v);
                vertexLines.add(s);
                System.out.println("adding " + s);
            }
        }
        ArrayList vList = new ArrayList(vertexLines);
        for (Face f : faces) {
            String faceString = "f ";
            for (int i = 0; i < f.vertices.length; ++i) {
                Vertex v;
                v = f.vertices[i];
                faceString = faceString + (vList.indexOf(ObjExporter.vert2String(v)) + 1);
                if (i + 1 == f.vertices.length) continue;
                faceString = faceString + " ";
            }
            faceLines.add(faceString);
        }
        try {
            for (String vString : vList) {
                writer.write(vString + "\n");
                System.out.println(vString);
            }
            writer.write("\n");
            for (String fString : faceLines) {
                writer.write(fString + "\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            ObjExporter.close(writer);
        }
        System.out.println("done exporting object model to " + file.getAbsolutePath());
    }

    private static String vert2String(Vertex vert) {
        return String.format("v %s %s %s", Float.valueOf(vert.x), Float.valueOf(vert.y), Float.valueOf(vert.z));
    }

    private static void close(Writer writer) {
        try {
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

