/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.testing;

import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;
import com.pixelmonmod.pixelmon.util.testing.AbstractDrawable;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Toolkit;
import java.awt.geom.Ellipse2D;
import javax.swing.JFrame;

public class TestingCanvas
extends Canvas {
    private AbstractDrawable[] drawables;
    private double[] translation = new double[2];
    private double[] scale = new double[]{1.0, 1.0};
    private static boolean defaultDraw = true;
    private final int width;
    private final int height;
    private static Ellipse2D circle = new Ellipse2D.Float(0.0f, 0.0f, 30.0f, 30.0f);
    public static AbstractList2D<Float> circleMap = GeometryHelper.gaussianBlur(new EntryList2D<Float>().modifyWithShape(circle, Float.valueOf(1.0f)), 3);

    public static TestingCanvas createSimpleScreen(int width, int height, String name) {
        TestingCanvas result = new TestingCanvas(width, height);
        result.setPreferredSize(new Dimension(width, height));
        JFrame frame = new JFrame(name);
        frame.setDefaultCloseOperation(2);
        frame.add(result);
        frame.pack();
        frame.setVisible(true);
        return result;
    }

    public static TestingCanvas createSimpleScreen(String name) {
        Dimension screenWH = Toolkit.getDefaultToolkit().getScreenSize();
        TestingCanvas result = new TestingCanvas(screenWH.width, screenWH.height);
        result.setPreferredSize(screenWH);
        JFrame frame = new JFrame(name);
        frame.setDefaultCloseOperation(2);
        frame.add(result);
        frame.pack();
        frame.setVisible(true);
        return result;
    }

    public TestingCanvas(int width, int height) {
        this.width = width;
        this.height = height;
        this.setBackground(Color.BLACK);
    }

    @Override
    public void paint(Graphics g) {
        if (this.drawables != null) {
            Graphics2D g2d = (Graphics2D)g;
            g2d.translate((int)this.translation[0], (int)this.translation[1]);
            g2d.scale(this.scale[0], this.scale[1]);
            for (AbstractDrawable drawable : this.drawables) {
                drawable.draw(g2d);
            }
        }
    }

    public void setDrawables(AbstractDrawable ... drawables) {
        this.drawables = drawables;
    }

    public void setTranslation(double x, double y) {
        this.translation[0] = x;
        this.translation[1] = y;
    }

    public void setScale(double x, double y) {
        this.scale[0] = x;
        this.scale[1] = y;
    }
}

