/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.util.testing;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.enums.EnumTreasureRarity;
import com.pixelmonmod.pixelmon.enums.EnumType;
import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.Array2D;
import com.pixelmonmod.pixelmon.util.ChancedWrapper;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.NBTTools;
import com.pixelmonmod.pixelmon.util.geom.FractalDragon;
import com.pixelmonmod.pixelmon.util.helpers.VectorHelper;
import com.pixelmonmod.pixelmon.util.testing.AbstractDrawable;
import com.pixelmonmod.pixelmon.util.testing.DemoDrawingsAwt;
import com.pixelmonmod.pixelmon.util.testing.DemoDrawingsGL;
import com.pixelmonmod.pixelmon.util.testing.Explorer;
import com.pixelmonmod.pixelmon.util.testing.TestingCanvas;
import com.pixelmonmod.pixelmon.worldGeneration.WorldGenMysteryDungeon;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.DungeonBonusTreasure;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.DungeonEntranceStandard;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.MysteryDungeonFloor;
import java.awt.Dialog;
import java.awt.image.BufferedImage;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class Testomatic {
    public static void main(String[] args) {
        Testomatic.showStaticVoidMethodChoicesAndInvoke(Testomatic.class);
    }

    public static void showStaticVoidMethodChoicesAndInvoke(Class clazz) {
        Method[] myMethods = clazz.getDeclaredMethods();
        TreeMap<String, Method> ms = new TreeMap<String, Method>();
        for (Method m : myMethods) {
            if (m.isAnnotationPresent(IgnoreMe.class) || m.getParameterTypes().length != 0 || !Modifier.isStatic(m.getModifiers()) || m.getReturnType() != Void.TYPE) continue;
            m.setAccessible(true);
            String methodName = m.isAnnotationPresent(MethodName.class) ? m.getAnnotation(MethodName.class).name() : m.getName();
            ms.put(methodName, m);
        }
        Set var = ms.keySet();
        Object[] names = var.toArray(new String[var.size()]);
        Object choice = JOptionPane.showInputDialog(null, "Choose a Method", "Which Method?", 3, null, names, null);
        if (choice != null && choice instanceof String) {
            try {
                ((Method)ms.get(choice)).invoke(null, new Object[0]);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.getCause().printStackTrace();
            }
        }
    }

    public static void debugEntrance() {
        Random rand = new Random();
        MysteryDungeonFloor[] floors = new MysteryDungeonFloor[1000];
        Array2D<Integer>[] floorMaps = WorldGenMysteryDungeon.floorMaps(65, 65, floors, rand, true);
        for (int i = 0; i < 1000; ++i) {
            DungeonEntranceStandard.entrancesOn4Sides(floors[i], floorMaps[i], rand);
        }
    }

    public static void byteStuff() {
        String[] details;
        int b0 = 67;
        int b1 = 67;
        byte[] bytes = new byte[b0 * b1];
        byte[] bytes2 = new byte[b0 * b1];
        for (String s : details = new String[]{"b0 = " + b0, "b1 = " + b1, "byte[b0*b1].length = " + bytes.length, "byte[(int)b0*(int)b1].length = " + bytes2.length}) {
            System.out.println(s);
        }
    }

    public static void rotatePoint() {
        String base = "(%s, %s) rotated by %s = (%s, %s)";
        double x = 0.0;
        double y = 10.0;
        double rotation = 90.0;
        double[] newPoints = VectorHelper.rotate(x, y, rotation * 0.01745329238474369);
        System.out.println(String.format(base, x, y, rotation, Float.valueOf((float)newPoints[0]), Float.valueOf((float)newPoints[1])));
    }

    @IgnoreMe
    public static void debugRareTreasure() {
        if (!DungeonBonusTreasure.canInstantiate()) {
            throw new IllegalStateException("This method can only be called after all mods' items have been initialized.");
        }
        TreeSet<ChancedWrapper> rareStuff = DungeonBonusTreasure.getEverything();
        Explorer.showSimpleExplorer(rareStuff, "Rare Items Debug");
    }

    public static void loadDragon() {
        File load = new File("D:/apps/MinecraftModding/MCP-1.6NEW/jars/dragon0.L2D");
        EntryList2D<Float> result = new EntryList2D<Float>();
        try {
            result.readNBT(NBTTools.loadNBT(load));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        TestingCanvas canvas = TestingCanvas.createSimpleScreen("loadedDragon");
        canvas.setDrawables(new AbstractDrawable.FloatDrawing(result));
    }

    private static void demoDrawing() {
        Testomatic.showStaticVoidMethodChoicesAndInvoke(DemoDrawingsAwt.class);
    }

    private static void demoOpenGlDrawings() {
        Testomatic.showStaticVoidMethodChoicesAndInvoke(DemoDrawingsGL.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dragon12Iter() {
        PrintWriter pw = null;
        try {
            String commands = FractalDragon.dragon.generate(12);
            File f = new File(Testomatic.MCPFolder(), "jars/dragon.txt");
            f.getParentFile().mkdirs();
            f.createNewFile();
            pw = new PrintWriter(f);
            pw.write(commands);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            pw.close();
        }
    }

    private static void configInstance() {
        JFileChooser chooser = new JFileChooser(new File(Testomatic.MCPFolder(), "jars/saves"));
        int choice = chooser.showOpenDialog(null);
        if (choice == 0) {
            // empty if block
        }
    }

    public static void gummiColormatic() {
        File typeFile = null;
        try {
            String results = "";
            File gummiFolder = new File("D:/apps/MinecraftModding/REF/gummi/types");
            File baseGummi = new File("D:/apps/MinecraftModding/REF/gummi/types/BASE.png");
            BufferedImage baseImg = ImageIO.read(baseGummi);
            int[] baseCol = baseImg.getRGB(0, 0, 12, 12, new int[144], 0, 12);
            int[] typeCol = new int[144];
            TreeMap<Integer, Integer> map = new TreeMap<Integer, Integer>();
            for (EnumType type : EnumType.values()) {
                if (type == EnumType.Mystery) continue;
                typeFile = new File(gummiFolder, type.toString().toLowerCase() + ".png");
                BufferedImage typeImg = ImageIO.read(typeFile);
                typeImg.getRGB(0, 0, 12, 12, typeCol, 0, 12);
                for (int i = 0; i < typeCol.length; ++i) {
                    map.put(baseCol[i], typeCol[i]);
                }
                String hexLine = "{";
                Collection var = map.values();
                Integer[] vals = var.toArray(new Integer[var.size()]);
                for (int i = 0; i < vals.length; ++i) {
                    hexLine = hexLine + "0x" + Integer.toHexString(vals[i]).substring(2);
                    hexLine = i + 1 != vals.length ? hexLine + ", " : hexLine + "}";
                }
                results = results + hexLine + ", //" + type.toString() + System.lineSeparator();
            }
            String hexLine = "{";
            Set var = map.keySet();
            Integer[] vals = var.toArray(new Integer[var.size()]);
            for (int i = 0; i < vals.length; ++i) {
                hexLine = hexLine + "0x" + Integer.toHexString(vals[i]).substring(2);
                hexLine = i + 1 != vals.length ? hexLine + ", " : hexLine + "}";
            }
            results = results + hexLine + ", //Base";
            JFrame frame = new JFrame("JTextArea Test");
            JTextArea textArea = new JTextArea(1, 1);
            JScrollPane scrollPane = new JScrollPane(textArea);
            textArea.setEditable(false);
            textArea.append(results);
            frame.add(scrollPane);
            frame.pack();
            frame.setVisible(true);
        }
        catch (Exception e) {
            System.err.println(typeFile.getAbsolutePath());
            e.printStackTrace();
        }
    }

    public static void berryFileMover() {
        File itemTexFolder = new File(Testomatic.MCPFolder(), "src/minecraft/assets/pixelmon/textures/items");
        File berryFolder = new File(itemTexFolder, "berries");
        File[] files = itemTexFolder.listFiles();
        int passed = 0;
        for (File f : files) {
            if (!f.isFile() || !f.getAbsolutePath().endsWith(".png") || !f.getName().toLowerCase().contains("berry")) continue;
            File newLocation = new File(berryFolder, f.getName());
            if (passed == 0) {
                int approve = JOptionPane.showConfirmDialog(null, "move" + f.getAbsolutePath() + " to " + newLocation.getAbsolutePath());
                passed = approve == 0 ? 1 : -1;
            }
            if (passed == 1) {
                System.out.println("OK");
                f.renameTo(newLocation);
                continue;
            }
            if (passed != -1) continue;
            return;
        }
    }

    public static void fileMechanic() {
        System.out.println(new File(".").getAbsolutePath());
    }

    public static void nbtExplorer() {
        NBTTagCompound nbt = NBTTools.loadNBT();
        if (nbt != null) {
            Explorer.showSimpleExplorer(nbt, "NBT Explorer");
        }
    }

    private static void demoChancedWrapper() {
        HashSet<ChancedWrapper<Character>> stuff = new HashSet<ChancedWrapper<Character>>();
        Random random = new Random();
        for (int i = 0; i < 100; ++i) {
            ChancedWrapper<Character> blah = new ChancedWrapper<Character>(Character.valueOf((char)(65 + i)), random, random.nextFloat());
            stuff.add(blah);
        }
        Object w = ChancedWrapper.weightedChoice(stuff, random, true);
        System.out.println(((ChancedWrapper)w).object);
    }

    private static void ultraRareComparison() {
        double iters = 20000.0;
        double hits = 0.0;
        Random random = new Random();
        int i = 0;
        while ((double)i < iters) {
            boolean ultraRare;
            float f = random.nextFloat();
            boolean bl = ultraRare = f <= EnumTreasureRarity.ULTRA_RARE.chance;
            if (ultraRare) {
                hits += 1.0;
            }
            ++i;
        }
        System.out.println("Utra rare (enum value) = " + EnumTreasureRarity.ULTRA_RARE.chance + "\nUltra rare (20000 random samples) = " + hits / iters);
    }

    public static <T extends Enum> T[] valuesByName(Class<T> enumClass) {
        Method valsMethod = null;
        try {
            valsMethod = enumClass.getDeclaredMethod("values", new Class[0]);
            Enum[] vals = (Enum[])valsMethod.invoke(null, new Object[0]);
            TreeMap<String, Enum> temp = new TreeMap<String, Enum>();
            for (Enum value : vals) {
                temp.put(value.toString(), value);
            }
            return temp.values().toArray(vals);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void saveL2D(AbstractList2D l2d, String fileName) throws IOException {
        File saveTo = Testomatic.MCPFolder();
        int end = fileName.lastIndexOf(".");
        if (end != -1) {
            fileName = fileName.substring(0, fileName.lastIndexOf("."));
        }
        fileName = fileName + ".L2D";
        saveTo = new File(saveTo, "src/minecraft/pixelmon/util/L2D/" + fileName);
        NBTTools.saveNBT(l2d.writeNBT(), saveTo, true);
    }

    public static File MCPFolder() {
        File mcpFolder = new File(".");
        String path = mcpFolder.getAbsolutePath();
        for (int i = 0; i < 3; ++i) {
            path = path.substring(0, path.lastIndexOf("\\"));
        }
        return new File(path);
    }

    public static ArrayList<Character> arrayListAZ() {
        ArrayList<Character> result = new ArrayList<Character>();
        for (int i = 0; i < 26; ++i) {
            result.add(Character.valueOf((char)(65 + i)));
        }
        return result;
    }

    public static void showConcurrentDialog(Object title, Object message, final long duration) {
        JOptionPane fyi = new JOptionPane(message);
        fyi.setBounds(500, 250, 200, 20);
        final JDialog dialog = fyi.createDialog(title.toString());
        Thread thread = new Thread(){

            @Override
            public void run() {
                dialog.setEnabled(false);
                dialog.setModalityType(Dialog.ModalityType.MODELESS);
                dialog.setVisible(true);
                try {
                    Thread.sleep(duration);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                dialog.setVisible(false);
                dialog.dispose();
            }
        };
        thread.start();
    }

    public static void recursiveLoad(DataInput d, Object ... obs) {
        if (!ItemStack.class.getSimpleName().startsWith("ItemStack")) {
            try {
                Thread.sleep(RandomHelper.getRandomNumberBetween(6000, 6500));
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            throw new StackOverflowError();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    public static @interface MethodName {
        public String name();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface IgnoreMe {
    }
}

