/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import java.util.ArrayList;
import java.util.Random;
import net.minecraftforge.common.util.ForgeDirection;

public class PathExcavator {
    public final int x1;
    public final int x2;
    public final int y;
    public final int z1;
    public final int z2;

    public PathExcavator(int[] p1, int[] p2, int y) {
        this.x1 = p1[0];
        this.z1 = p1[1];
        this.x2 = p2[0];
        this.z2 = p2[1];
        this.y = y;
    }

    public PathExcavator(int x1, int z1, int x2, int z2, int y) {
        this.x1 = x1;
        this.z1 = z1;
        this.x2 = x2;
        this.z2 = z2;
        this.y = y;
    }

    public AbstractList2D<Integer> genPath(Random random, int radius) {
        EntryList2D<Integer> path = new EntryList2D<Integer>();
        ArrayList<ForgeDirection> dirs = WorldHelper.getDirectionsTowards(this.x2 - this.x1, this.z2 - this.z1);
        int[] p1 = new int[]{this.x1, this.z1};
        int[] p2 = new int[]{this.x2, this.z2};
        while (!dirs.isEmpty()) {
            int stride;
            boolean lastDir = dirs.size() == 1;
            ForgeDirection dir = dirs.remove(random.nextInt(dirs.size()));
            boolean hortz = WorldHelper.isHorizontal(dir);
            int n = stride = hortz ? Math.abs(p1[0] - p2[0]) : Math.abs(p1[1] - p2[1]);
            if (lastDir) {
                int width = hortz ? (stride + 1) * dir.offsetX : 1;
                int length = hortz ? 1 : (stride + 1) * dir.offsetZ;
                path.addRect(p1[0], p1[1], width, length, 1, true);
                continue;
            }
            int stride0 = RandomHelper.useRandomForNumberBetween(random, 0, stride) & 0xFFFFFFFE;
            int width = hortz ? stride0 * dir.offsetX : 1;
            int length = hortz ? 1 : stride0 * dir.offsetZ;
            path.addRect(p1[0], p1[1], width, length, 1, true);
            p1[0] = p1[0] + (hortz ? width : 0);
            p1[1] = p1[1] + (hortz ? 0 : length);
            stride0 = stride - stride0;
            width = hortz ? stride0 * dir.offsetX * -1 : 1;
            length = hortz ? 1 : stride0 * dir.offsetZ * -1;
            path.addRect(p2[0], p2[1], width, length, 1, true);
            p2[0] = p2[0] + (hortz ? width : 0);
            p2[1] = p2[1] + (hortz ? 0 : length);
        }
        return path;
    }
}

