/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.Link2D;
import com.pixelmonmod.pixelmon.util.geom.FractalDragon;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;
import com.pixelmonmod.pixelmon.worldGeneration.WorldGenSpecificBiome;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class WorldGenDragonHills
extends WorldGenSpecificBiome {
    private static boolean debugPlacement = true;
    private static boolean generating = false;
    private int minIters;
    private int maxIters;

    public WorldGenDragonHills(BiomeGenBase user, int minIterations, int maxIterations) {
        super(user);
        this.minIters = minIterations;
        this.maxIters = maxIterations;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        if (generating) {
            return false;
        }
        int height = RandomHelper.useRandomForNumberBetween(random, 56, 64);
        AbstractList2D<Float> dragon = this.chooseDragon(random);
        int mode = random.nextInt(1);
        generating = true;
        float min = dragon.minVal().floatValue() + 0.2f;
        float max = dragon.maxVal().floatValue();
        int heightVal = world.func_72825_h(x, z);
        for (Link2D link2D : dragon) {
            int i0 = x + (mode == 0 ? link2D.x : link2D.z);
            int j0 = z + (mode == 0 ? link2D.z : link2D.x);
            int heightHere = world.func_72825_h(i0, j0);
            float scale = (float)GeometryHelper.slider(((Float)link2D.value).floatValue(), min, max);
            int heightAdjustment = Math.round(scale * (float)height);
            for (int yi = 0; yi < heightAdjustment; ++yi) {
                Block block = yi + 1 == heightAdjustment ? world.func_72807_a((int)i0, (int)j0).field_76752_A : Blocks.field_150346_d;
                world.func_147465_d(i0, yi + heightHere, j0, block, 0, 2);
            }
        }
        generating = false;
        return true;
    }

    public AbstractList2D<Float> chooseDragon(Random random) {
        int iterations = RandomHelper.useRandomForNumberBetween(random, this.minIters, this.maxIters);
        return (AbstractList2D)FractalDragon.dragonLSystem((int)iterations, (boolean)true).geometry;
    }
}

