/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration;

import com.pixelmonmod.pixelmon.blocks.BlockRotation;
import com.pixelmonmod.pixelmon.blocks.MultiBlock;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.enums.EnumEvolutionRock;
import com.pixelmonmod.pixelmon.items.ItemBlock;
import com.pixelmonmod.pixelmon.worldGeneration.battleDimension.BattleDimWorldProvider;
import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.IChunkProvider;

public class WorldGenEvolutionRock
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.field_76575_d || world.field_73011_w.field_76574_g == BattleDimWorldProvider.DimID) {
            return;
        }
        int xPos = random.nextInt(16) + chunkX * 16;
        int zPos = random.nextInt(16) + chunkZ * 16;
        int yPos = world.func_72976_f(xPos, zPos) - 1;
        BiomeGenBase biome = world.func_72807_a(xPos, zPos);
        Block block = world.func_147439_a(xPos, yPos - 1, zPos);
        if (block == Blocks.field_150349_c || block == Blocks.field_150346_d) {
            for (EnumEvolutionRock r : EnumEvolutionRock.values()) {
                for (BiomeGenBase b : r.biomes) {
                    if (b != biome || !(random.nextDouble() < 0.05)) continue;
                    boolean canSpawn = true;
                    for (int ix = -1; ix < 2; ++ix) {
                        for (int iz = -1; iz < 2; ++iz) {
                            Block block2 = world.func_147439_a(xPos + ix, yPos - 1, zPos + iz);
                            if (block2 == Blocks.field_150349_c || block2 == Blocks.field_150346_d) continue;
                            canSpawn = false;
                        }
                    }
                    if (canSpawn) {
                        if (r == EnumEvolutionRock.IcyRock) {
                            ItemBlock.setMultiBlocksWidth(xPos, yPos + 1, zPos, BlockRotation.Normal, world, (MultiBlock)PixelmonBlocks.icyRock, PixelmonBlocks.icyRock);
                        } else if (r == EnumEvolutionRock.MossyRock) {
                            ItemBlock.setMultiBlocksWidth(xPos, yPos + 1, zPos, BlockRotation.Normal, world, (MultiBlock)PixelmonBlocks.mossyRock, PixelmonBlocks.mossyRock);
                        }
                    }
                    return;
                }
            }
        }
    }
}

