/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration;

import com.google.common.eventbus.EventBus;
import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.MinimalList2D;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.worldGeneration.biome.IBiomeNeedsDraining;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.util.ForgeDirection;

public class WorldGenFloodDrain<T extends BiomeGenBase>
extends WorldGenerator {
    protected static final EventBus DAM_BUS = new EventBus();
    private static volatile MinimalList2D<Integer> drainedChunks = new MinimalList2D();
    private static volatile MinimalList2D<Integer> drainedBlocks = new MinimalList2D();
    private AbstractList2D<Object> checkedCoords = new EntryList2D<Object>();
    private boolean checkForFlood;
    private boolean isChild;
    private T user;
    private Block damBlock;
    private int xLoc;
    private int zLoc;

    public WorldGenFloodDrain(T user, Block damBlock, boolean checkForFullFlood, boolean isChild) {
        this.user = user;
        this.damBlock = damBlock;
        this.checkForFlood = checkForFullFlood;
        this.isChild = isChild;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        this.xLoc = x >> 4;
        this.zLoc = z >> 4;
        if (drainedChunks.contains(this.xLoc, this.zLoc)) {
            return false;
        }
        int[][] shape = this.detectLocalShape(world, x, z);
        this.drain(world, shape);
        drainedChunks.addValue(this.xLoc, this.zLoc, 1);
        this.drainNearbyChunks(world, shape);
        if (!this.isChild) {
            ((IBiomeNeedsDraining)this.user).onDoneDraining(world, random, x, y, z);
        }
        return true;
    }

    private void debugFillMap(int[][] shape) {
        for (int[] i : shape) {
            System.out.println(Arrays.toString(i));
        }
    }

    private void drainNearbyChunks(World world, int[][] map) {
        for (ForgeDirection dir : WorldHelper.NWSE) {
            if (this.isNeighborChunkDifferentBiome(world, dir)) {
                // empty if block
            }
            this.drainChunkOnSide(world, map, dir);
        }
    }

    private boolean isNeighborChunkDifferentBiome(World world, ForgeDirection dir) {
        BiomeGenBase biome = world.func_72807_a((this.xLoc + dir.offsetX) * 16, (this.zLoc + dir.offsetZ) * 16);
        return this.user == biome;
    }

    private void drainChunkOnSide(World world, int[][] map, ForgeDirection dir) {
        int[] strip = this.getStrip(map, dir);
        for (int i = 0; i < 16; ++i) {
            int[] localTestCoords;
            if (strip[i] != 1 || !this.isLocalCoordWaterOrIce(world, (localTestCoords = WorldHelper.forgeDirectionAndOffsetToLocalChunkCoords(dir, i))[0], localTestCoords[1]) || this.pointIsNonDrainable(world, this.xLoc * 16 + localTestCoords[0], this.zLoc * 16 + localTestCoords[1])) continue;
            int worldX = this.xLoc * 16 + localTestCoords[0];
            int worldZ = this.zLoc * 16 + localTestCoords[1];
            world.func_72807_a(worldX, worldZ);
            if (!drainedChunks.contains(worldX >> 4, worldZ >> 4)) {
                new WorldGenFloodDrain<T>(this.user, this.damBlock, false, true).func_76484_a(world, null, worldX, -1, worldZ);
                continue;
            }
            if (!drainedChunks.contains(worldX >> 4, worldZ >> 4)) continue;
            drainedChunks.remove(worldX >> 4, worldZ >> 4);
            new WorldGenFloodDrain<T>(this.user, this.damBlock, false, true).func_76484_a(world, null, worldX, -1, worldZ);
        }
    }

    private int[] getStrip(int[][] map, ForgeDirection dir) {
        int[] result = new int[16];
        for (int i = 0; i < 16; ++i) {
            int xi = (int)(dir.offsetX != 0 ? 7.5f * (float)dir.offsetX + 7.5f : (float)i);
            int zi = (int)(dir.offsetZ != 0 ? 7.5f * (float)dir.offsetZ + 7.5f : (float)i);
            result[i] = map[xi][zi];
        }
        return result;
    }

    private boolean isLocalCoordWaterOrIce(World world, int localX, int localZ) {
        return WorldHelper.isWaterOrIce(world, this.xLoc * 16 + localX, 62, this.zLoc * 16 + localZ);
    }

    private int[][] detectLocalShape(World world, int x, int z) {
        int[][] result = new int[16][16];
        if (this.isChild) {
            this.addPointRecursively(world, x, z, result);
        } else {
            this.addPointIteravely(world, result);
        }
        return result;
    }

    public void addPointRecursively(World world, int x, int z, int[][] fill) {
        if (this.checkedCoords.isntNull(x, z)) {
            return;
        }
        this.checkedCoords.addValue(x, z, CommonHelper.THING);
        int[] local = this.getLocalCoords(x, z);
        int i = local[0];
        int j = local[1];
        if (this.isInChunkBounds(i, j) && fill[i][j] == 0 && WorldHelper.isWaterOrIce(world, x, 62, z) && !this.pointIsNonDrainable(world, x, z)) {
            fill[i][j] = this.pointBordersNonDrainable(world, x, z) ? 2 : 1;
            for (ForgeDirection dir : WorldHelper.NWSE) {
                this.addPointRecursively(world, x + dir.offsetX, z + dir.offsetZ, fill);
            }
        }
    }

    public void addPointIteravely(World world, int[][] fill) {
        for (int i = 0; i < 16; ++i) {
            int x0 = this.xLoc * 16 + i;
            for (int j = 0; j < 16; ++j) {
                int z0 = this.zLoc * 16 + j;
                if (!WorldHelper.isWaterOrIce(world, x0, 62, z0) || this.pointIsNonDrainable(world, x0, z0)) continue;
                fill[i][j] = this.pointBordersNonDrainable(world, x0, z0) ? 2 : 1;
            }
        }
    }

    public void drain(World world, int[][] map) {
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                if (map[i][j] == 1) {
                    this.drainHere(world, this.xLoc * 16 + i, this.zLoc * 16 + j);
                    this.possiblyPlaceDam(world, this.xLoc * 16 + i, this.zLoc * 16 + j);
                    continue;
                }
                if (map[i][j] != 2) continue;
                this.damHere(world, this.xLoc * 16 + i, this.zLoc * 16 + j);
            }
        }
    }

    private boolean isInChunkBounds(int localX, int localZ) {
        return localX >= 0 && localX < 16 && localZ >= 0 && localZ < 16;
    }

    public int[] getLocalCoords(int x, int z) {
        return new int[]{x - this.xLoc * 16, z - this.zLoc * 16};
    }

    private void damHere(World world, int x, int z) {
        if (drainedBlocks.contains(x, z)) {
            return;
        }
        drainedBlocks.addValue(x, z, 1);
        if (WorldHelper.isWaterOrIce(world, x, 62, z)) {
            int depth = WorldHelper.getWaterDepthAt(x, z, world);
            int i = 0;
            world.func_147465_d(x, 63, z, this.damBlock, 0, 2);
            for (i = 0; i < depth; ++i) {
                world.func_147465_d(x, 62 - i, z, this.damBlock, 0, 2);
            }
            new DamGenEvent(x, z, world);
        }
    }

    private void drainHere(World world, int x, int z) {
        if (drainedBlocks.contains(x, z)) {
            return;
        }
        drainedBlocks.addValue(x, z, 1);
        if (WorldHelper.isWaterOrIce(world, x, 62, z)) {
            int depth = WorldHelper.getWaterDepthAt(x, z, world);
            int i = 0;
            for (i = 0; i < depth; ++i) {
                world.func_147468_f(x, 62 - i, z);
            }
            if (world.func_147439_a(x, 62 - i, z) != null) {
                Block surfaceBlock = world.func_72807_a((int)x, (int)z).field_76752_A;
                world.func_147465_d(x, 62 - i, z, surfaceBlock, 0, 2);
            }
        }
    }

    private boolean pointBordersNonDrainable(World world, int x, int z) {
        for (ForgeDirection dir : WorldHelper.NWSE) {
            if (!this.pointIsNonDrainable(world, x + dir.offsetX, z + dir.offsetZ)) continue;
            return true;
        }
        return false;
    }

    private void possiblyPlaceDam(World world, int x, int z) {
        for (ForgeDirection dir : WorldHelper.NWSE) {
            if (!this.pointIsNonDrainable(world, x + dir.offsetX, z + dir.offsetZ)) continue;
            this.damHere(world, x + dir.offsetX, z + dir.offsetZ);
        }
    }

    private boolean pointIsNonDrainable(World world, int x, int z) {
        BiomeGenBase biome = world.func_72807_a(x, z);
        return WorldHelper.isWateryBiome(biome);
    }

    public static void register(Object obj) {
        DAM_BUS.register(obj);
    }

    public static class DamGenEvent {
        final int worldX;
        final int worldZ;
        World world;

        protected DamGenEvent(int x, int z, World world) {
            this.worldX = x;
            this.worldZ = z;
            this.world = world;
            DAM_BUS.post((Object)this);
        }
    }
}

