/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration;

import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.storage.structure.AwarenessFogboundLake;
import com.pixelmonmod.pixelmon.storage.structure.StructureStorage;
import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.Array2D;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.Link2D;
import com.pixelmonmod.pixelmon.util.geom.ShapeHelper;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;
import com.pixelmonmod.pixelmon.worldGeneration.ICanSpawn;
import com.pixelmonmod.pixelmon.worldGeneration.WorldGenSpecificBiome;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenTrees;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class WorldGenFogboundLake
extends WorldGenSpecificBiome
implements ICanSpawn {
    public static final int HEIGHT = 40;
    public static final int LINK_HEIGHT = 12;
    public static final int THICKNESS = 4;
    protected int maxBase;
    protected int lakeSurfaceY;
    protected float xzScale = 2.5f;
    protected float yScale = 1.5f;
    protected boolean generating = false;
    public StructureBoundingBox[] parts;
    int q;
    protected static final AbstractList2D<Boolean> fittingShape = new EntryList2D<Boolean>().modifyWithShape(ShapeHelper.centeredEllipse(100.0f, 100.0f), true);

    public WorldGenFogboundLake(BiomeGenBase user) {
        super(user);
    }

    public boolean func_76484_a(World world, Random random, int i, int j, int k) {
        if (this.generating) {
            return false;
        }
        this.generating = true;
        this.q = 0;
        if (j > 90 || !this.canSpawnHere(world, i, j, k)) {
            this.generating = false;
            return false;
        }
        Object[] parts = WorldGenFogboundLake.fogboundLake(random, this.xzScale, this.yScale);
        this.maxBase = 0;
        this.placeBase(world, i, j, k, (Array2D)parts[0], (Shape)parts[1]);
        Array2D<Float> lakeDirtEdge = this.placeLake(world, i, j, k, (Array2D)parts[2]);
        this.modifySurface(world, i, j, k, lakeDirtEdge, random);
        new AwarenessFogboundLake(world, i, j, k, this);
        WorldHelper.fixLighting(world, new StructureBoundingBox(i - 50, 1, k - 50, i + 50, 2, k + 50));
        this.generating = false;
        return true;
    }

    public static Object[] fogboundLake(Random rand, float xzScale, float heightScale) {
        if (rand == null) {
            rand = new Random();
        }
        int size = (int)(40.0f * xzScale);
        Path2D circle1 = ShapeHelper.warbledCircle(size, size / 16, rand, null);
        Path2D circle2 = ShapeHelper.warbledCircle((float)size * 0.95f, (float)size * 0.95f / 16.0f, rand, null);
        Path2D circle3 = ShapeHelper.warbledCircle((float)size * 0.65f, (float)size * 0.65f / 16.0f, rand, null);
        Path2D circle4 = ShapeHelper.warbledCircle((float)size * 0.22f, (float)size * 0.22f / 16.0f, rand, null);
        Rectangle2D circleBounds = circle1.getBounds2D();
        Rectangle2D circleBounds2 = circle2.getBounds2D();
        circleBounds.add(circleBounds2);
        int w = (int)circleBounds.getWidth();
        int l = (int)circleBounds.getHeight();
        int zx = (int)circleBounds.getMinX();
        int zz = (int)circleBounds.getMinY();
        Array2D<Float> circleMap = new Array2D<Float>(Float.class, w, l).setZero(zx, zz);
        circleMap.modifyWithShape(circle1, Float.valueOf(0.04f));
        circleMap.modifyWithShape(circle2, Float.valueOf(0.4f));
        circleMap.modifyWithShape(circle3, Float.valueOf(0.63f));
        circleMap.modifyWithShape(circle4, Float.valueOf(0.75f));
        circleMap = GeometryHelper.sequencedBlur(circleMap, 2, false, true);
        circleMap = GeometryHelper.sequencedBlur(circleMap, 3, true, true);
        circleMap = Array2D.invert(circleMap);
        circleMap = Array2D.add(circleMap, (float)(-circleMap.minValue().doubleValue()));
        Array2D.mul(circleMap, heightScale);
        return new Object[]{WorldGenFogboundLake.fogboundBase(size, circle4, xzScale, heightScale, rand), circle4, circleMap};
    }

    public static Array2D<Float> fogboundBase(int size, Shape link, float xzScale, float heightScale, Random rand) {
        Path2D circleBase = ShapeHelper.warbledCircle((float)size * 0.5f, (float)size * 0.5f / 16.0f, rand, null);
        Path2D circleMid = ShapeHelper.warbledCircle((float)size * 0.3f, (float)size * 0.3f / 16.0f, rand, null);
        Rectangle2D circleBounds = link.getBounds2D();
        circleBounds.add(circleBase.getBounds2D());
        int w = (int)circleBounds.getWidth();
        int l = (int)circleBounds.getHeight();
        int zx = (int)circleBounds.getMinX();
        int zz = (int)circleBounds.getMinY();
        Array2D<Float> circleMap = new Array2D<Float>(Float.class, w, l).setZero(zx, zz);
        circleMap.modifyWithShape(circleBase, Float.valueOf(0.0f));
        circleMap.modifyWithShape(circleMid, Float.valueOf(0.1f));
        circleMap.modifyWithShape(link, Float.valueOf(0.3f));
        Array2D.mul(circleMap, heightScale);
        circleMap = GeometryHelper.sequencedBlur(circleMap, 3, true, false);
        return circleMap;
    }

    protected void placeBase(World world, int x, int y, int z, Array2D<Float> base, Shape link) {
        for (Link2D link2D : base) {
            if (link2D.value == null) continue;
            int xi = link2D.x;
            int zi = link2D.z;
            boolean flag = link.contains(xi, zi);
            int heightLevel = (int)(flag ? base.maxValue() * 40.0 + 12.0 : (double)(base.get(xi, zi).floatValue() * 40.0f));
            for (int yi = 0; yi < heightLevel; ++yi) {
                if (yi > this.maxBase) {
                    this.maxBase = yi;
                }
                int x0 = x + xi;
                int z0 = z + zi;
                world.func_147465_d(x0, y + yi, z0, Blocks.field_150346_d, 0, 2);
                ++this.q;
                Block bl = null;
                int yn = -1;
                while ((bl = world.func_147439_a(x0, y + yn, z0)) == null || !bl.func_149688_o().func_76230_c()) {
                    world.func_147465_d(x0, y + yn, z0, Blocks.field_150346_d, 0, 2);
                    ++this.q;
                    --yn;
                }
            }
        }
    }

    protected Array2D<Float> placeLake(World world, int x, int y, int z, Array2D<Float> lake) {
        Array2D<Float> lakeDirtEdge = lake.createNewWithSameZeros();
        this.lakeSurfaceY = (int)(lake.maxValue() * 40.0);
        for (Link2D link2D : lake) {
            if (link2D.value == null) continue;
            int xi = link2D.x;
            int zi = link2D.z;
            int depthValue = (int)(lake.get(xi, zi).floatValue() * 40.0f);
            for (int yi = this.lakeSurfaceY; yi >= depthValue; --yi) {
                Block block;
                int x0 = x + xi;
                int z0 = z + zi;
                boolean useWater = this.shouldUseWater(lake, xi, yi, zi);
                Block block2 = block = useWater ? Blocks.field_150355_j : Blocks.field_150346_d;
                if (yi == this.lakeSurfaceY && !useWater) {
                    lakeDirtEdge.addValue(xi, zi, Float.valueOf(1.0f));
                }
                world.func_147465_d(x0, y + this.maxBase + yi - 3, z0, block, 0, 2);
                ++this.q;
            }
        }
        return lakeDirtEdge;
    }

    protected void modifySurface(World world, int x, int y, int z, Array2D<Float> lakeDirtEdge, Random rand) {
        lakeDirtEdge = this.makeWaterfalls(world, x, y, z, lakeDirtEdge, rand);
        lakeDirtEdge = GeometryHelper.sequencedBlur(lakeDirtEdge, 3, true);
        WorldGenTrees treeGen = new WorldGenTrees(false);
        int i = 0;
        for (Link2D link2D : lakeDirtEdge) {
            if (link2D.value == null) continue;
            int xi = link2D.x;
            int zi = link2D.z;
            int bumpHeight = (int)(lakeDirtEdge.get(xi, zi).floatValue() * 7.0f);
            for (int yi = 0; yi <= bumpHeight; ++yi) {
                BlockGrass block = yi == bumpHeight ? Blocks.field_150349_c : Blocks.field_150346_d;
                world.func_147465_d(x + xi, y + yi + this.maxBase + this.lakeSurfaceY - 3, z + zi, (Block)block, 0, 2);
                ++this.q;
                if (yi == bumpHeight && i % 36 == 0) {
                    treeGen.func_76484_a(world, rand, x + xi, y + yi + this.maxBase + this.lakeSurfaceY - 2, z + zi);
                }
                ++i;
            }
        }
    }

    protected Array2D<Float> makeWaterfalls(World world, int x, int y, int z, Array2D<Float> lakeDirtEdge, Random rand) {
        Array2D modifiedDirtEdge = (Array2D)lakeDirtEdge.clone();
        int poolsMax = 0;
        int poolsMin = 128;
        for (int i = 0; i < 10; ++i) {
            AffineTransform rot = AffineTransform.getRotateInstance(Math.toRadians(36 * i));
            int j = 50;
            Point2D.Float point0 = new Point2D.Float(j, 0.0f);
            Line2D.Float intersector = new Line2D.Float(new Point2D.Float(0.0f, 0.0f), point0);
            rot.transform(point0, point0);
            while (modifiedDirtEdge.contains((int)((Point2D)point0).getX(), (int)((Point2D)point0).getY())) {
                ((Point2D)point0).setLocation(++j, 0.0);
                rot.transform(point0, point0);
            }
            ((Point2D)point0).setLocation(j += 2, 0.0);
            rot.transform(point0, point0);
            intersector.setLine(((Line2D)intersector).getP1(), point0);
            AbstractList2D<Float> lineAsPoints = new EntryList2D<Float>().addLine(intersector, Float.valueOf(1.0f));
            lineAsPoints.intersect(modifiedDirtEdge).expand(1, Float.valueOf(1.0f));
            for (Link2D link2D : lineAsPoints) {
                int xi = link2D.x;
                int zi = link2D.z;
                int y0 = y + this.maxBase + this.lakeSurfaceY - 3;
                Block block = world.func_147439_a(x + xi, y0, z + zi);
                if (!modifiedDirtEdge.contains(xi, zi) && block != null) continue;
                world.func_147465_d(x + xi, y0, z + zi, (Block)Blocks.field_150358_i, 0, 2);
                ++this.q;
                if (this.isAirBelow(world, x + xi, y0, z + zi)) {
                    --y0;
                    while (this.shouldReplaceWithWaterfall(world, x + xi, y0, z + zi)) {
                        world.func_147465_d(x + xi, y0, z + zi, (Block)Blocks.field_150358_i, 0, 2);
                        ++this.q;
                        --y0;
                    }
                    if (y0 < poolsMin) {
                        poolsMin = y0;
                    }
                    if (y0 > poolsMax) {
                        poolsMax = y0;
                    }
                }
                modifiedDirtEdge.remove(xi, zi);
            }
        }
        this.makeFallsRing(world, lakeDirtEdge, rand, x, z, poolsMin, poolsMax);
        return modifiedDirtEdge;
    }

    private void makeFallsRing(World world, Array2D<Float> lakeDirtEdge, Random random, int x, int z, int lowestWaterfallY, int highestWaterfallY) {
        lakeDirtEdge.expand(3, Float.valueOf(1.0f));
        lakeDirtEdge = GeometryHelper.sequencedBlur(lakeDirtEdge, 2, true, false, false);
        int bottomY = 61;
        for (Link2D link2D : lakeDirtEdge) {
            if (link2D.value == null) continue;
            int topY = WorldHelper.firstBlockDownwardsFromY(world, x + link2D.x, highestWaterfallY, z + link2D.z, false);
            if (topY == highestWaterfallY) {
                topY = WorldHelper.firstUncoveredUpwardsFromY(world, x + link2D.x, topY, z + link2D.z, false);
            }
            for (int y0 = (int)GeometryHelper.lineSlider(((Float)link2D.value).floatValue(), lakeDirtEdge.minValue(), lakeDirtEdge.maxValue(), topY, bottomY - 3); y0 <= topY; ++y0) {
                if (y0 < 63) {
                    world.func_147465_d(x + link2D.x, y0, z + link2D.z, Blocks.field_150355_j, 0, 2);
                } else {
                    world.func_147468_f(x + link2D.x, y0, z + link2D.z);
                }
                ++this.q;
            }
        }
    }

    protected boolean shouldReplaceWithWaterfall(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        return block == null || !block.func_149688_o().func_76230_c();
    }

    protected boolean isAirBelow(World world, int x, int y, int z) {
        return world.func_147439_a(x, y - 1, z) == null;
    }

    protected boolean shouldUseWater(Array2D<Float> lake, int x, int y, int z) {
        return (double)y == lake.maxValue() * 40.0 || this.isLakePointSurrounded(lake, x, y, z, 4);
    }

    protected boolean isLakePointSurrounded(Array2D<Float> lake, int x, int y, int z, int radius) {
        for (int i = -radius; i <= radius; ++i) {
            for (int j = -radius; j <= radius; ++j) {
                if (!lake.contains(x + i, z + j)) {
                    return false;
                }
                int compareValue = (int)(lake.get(x + i, z + j).floatValue() * 40.0f);
                if (compareValue <= y - radius) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isGenerating() {
        return this.generating;
    }

    @Override
    public boolean canSpawnHere(World world, int x, int y, int z) {
        StructureBoundingBox base = new StructureBoundingBox(x - 50, y, z - 50, x + 50, y + 69, z + 50);
        this.parts = new StructureBoundingBox[]{base};
        for (int i = 0; i < this.parts.length; ++i) {
            if (StructureStorage.canFitWithoutChunkOverlap(world, this.parts[i])) continue;
            return false;
        }
        return true;
    }
}

