/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration;

import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.storage.structure.AwarenessMysteryDungeon;
import com.pixelmonmod.pixelmon.storage.structure.StructureStorage;
import com.pixelmonmod.pixelmon.util.Array2D;
import com.pixelmonmod.pixelmon.worldGeneration.ICanSpawn;
import com.pixelmonmod.pixelmon.worldGeneration.WorldGenSpecificBiome;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.AbstractDungeonBonus;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.AbstractDungeonBuilder;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.AbstractDungeonEntrance;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.MysteryDungeonFloor;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.MysteryDungeonValues;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class WorldGenMysteryDungeon
extends WorldGenSpecificBiome
implements ICanSpawn {
    public static final int width = 65;
    public static final int length = 65;
    public final AbstractDungeonBuilder builder;
    public final AbstractDungeonEntrance entrance;
    public AbstractDungeonBonus[] extras;
    public final MysteryDungeonValues values;
    public MysteryDungeonFloor[] floors;
    public final int numFloors;
    public final boolean isDynamic;
    public final int floorHeight;
    public final boolean up;
    public final boolean ladderShaftOverwrite;
    protected static boolean generating = false;

    public WorldGenMysteryDungeon(AbstractDungeonBuilder builder, AbstractDungeonEntrance entrance, MysteryDungeonValues vals, BiomeGenBase user, int floorHeight, int floors, boolean up, boolean ladderShaftOverwrite, boolean isDynamic) {
        super(user);
        this.builder = builder;
        this.entrance = entrance;
        this.values = vals;
        this.floorHeight = floorHeight;
        this.numFloors = floors;
        this.up = up;
        this.ladderShaftOverwrite = ladderShaftOverwrite;
        this.isDynamic = isDynamic;
        this.builder.setDungeon(this);
        this.entrance.setDungeon(this);
    }

    public WorldGenMysteryDungeon setExtras(AbstractDungeonBonus ... extras) {
        this.extras = extras;
        return this;
    }

    public static Array2D<Integer>[] floorMaps(int width, int length, MysteryDungeonFloor[] floors, Random random, boolean ladderShaftOverwrite) {
        Array2D[] result = new Array2D[floors.length];
        MysteryDungeonFloor floor = new MysteryDungeonFloor(width, length, 1, random, ladderShaftOverwrite);
        for (int i = 0; i < floors.length; ++i) {
            result[i] = floor.floorMain(random, 2);
            floors[i] = floor;
            if (i + 1 == floors.length) continue;
            floor = new MysteryDungeonFloor(width, length, 1, floor.myStairsPoint(), random, ladderShaftOverwrite);
        }
        return result;
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        int[] modXYZ = this.builder.modStartingPoint(world, x, y, z);
        if (!this.canSpawnHere(world, x = modXYZ[0], y = modXYZ[1], z = modXYZ[2])) {
            return false;
        }
        generating = true;
        MysteryDungeonFloor[] floors = new MysteryDungeonFloor[this.numFloors];
        WorldGenMysteryDungeon.floorMaps(65, 65, floors, random, this.ladderShaftOverwrite);
        this.floors = floors;
        this.builder.build(world, this, floors, random, x, y, z);
        this.entrance.build(world, this, random, x, y, z);
        for (AbstractDungeonBonus extra : this.extras) {
            extra.build(world, this, floors, random, x, y, z);
        }
        new AwarenessMysteryDungeon(world, this, x, y, z);
        generating = false;
        return true;
    }

    @Override
    public boolean canSpawnHere(World world, int x, int y, int z) {
        if (generating) {
            return false;
        }
        StructureBoundingBox bbox = new StructureBoundingBox(x, y + this.builder.getMinY(), z, x + 65, y + this.builder.getMaxY(), z + 65);
        boolean canFit = StructureStorage.canFitWithoutChunkOverlap(world, bbox);
        if (canFit) {
            boolean safeDistance = StructureStorage.isSafeDistanceToNearest(world, AwarenessMysteryDungeon.class, bbox.func_78881_e(), 0, bbox.func_78891_g(), 500.0, true, true, false, true);
            return safeDistance && (this.user == null || WorldHelper.canFitWithinBiome(world, this.user, x, z, 65, 65, 0));
        }
        return false;
    }
}

