/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.biome;

import com.pixelmonmod.pixelmon.config.PixelmonGen;
import com.pixelmonmod.pixelmon.enums.EnumTreasureRarity;
import com.pixelmonmod.pixelmon.structure.StructureData;
import com.pixelmonmod.pixelmon.structure.StructureRegistry;
import com.pixelmonmod.pixelmon.structure.generation.ComplexScattered;
import com.pixelmonmod.pixelmon.structure.generation.SpecialParameters;
import com.pixelmonmod.pixelmon.structure.generation.criteria.SpawnCriteriaMinDistance;
import com.pixelmonmod.pixelmon.structure.generation.criteria.SpawnCriteriaSpecificBiome;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.worldGeneration.WorldGenFogboundLake;
import com.pixelmonmod.pixelmon.worldGeneration.WorldGenMysteryDungeon;
import com.pixelmonmod.pixelmon.worldGeneration.biome.BiomeDecoratorDenial;
import com.pixelmonmod.pixelmon.worldGeneration.biome.BiomeGenShaped;
import com.pixelmonmod.pixelmon.worldGeneration.biome.IBiomeHasShore;
import com.pixelmonmod.pixelmon.worldGeneration.biome.data.ClusterDataMysteryValley;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.DungeonBonusTreasure;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.DungeonBuilderStandard;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.DungeonEntranceStandard;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.MysteryDungeonValues;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.awt.Color;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.event.terraingen.DecorateBiomeEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;

public class BiomeGenMysteryValley
extends BiomeGenShaped<ClusterDataMysteryValley>
implements IBiomeHasShore {
    protected WorldGenFogboundLake fogboundGen;
    protected WorldGenMysteryDungeon dungeonGen;
    private final BiomeGenBase[] includedBiomes;
    private int smallIndex = 0;
    private int bigIndex = 0;
    private StructureData[] smallStructures;
    private StructureData[] bigStructures;
    private boolean blocked = false;
    public static final int GRASS_COLOR = 10405829;
    public static final int FOLIAGE_COLOR = 15000440;

    public BiomeGenMysteryValley(int par1) {
        super(par1);
        this.field_76760_I = new BiomeDecoratorDenial(this).setDenials(PopulateChunkEvent.Populate.EventType.DUNGEON).setDenials(DecorateBiomeEvent.Decorate.EventType.PUMPKIN, DecorateBiomeEvent.Decorate.EventType.SAND, DecorateBiomeEvent.Decorate.EventType.SAND_PASS2, DecorateBiomeEvent.Decorate.EventType.DEAD_BUSH);
        this.field_76760_I.field_76832_z = 2;
        this.field_76760_I.field_76799_E = 3;
        this.field_76760_I.field_76802_A = 5;
        this.field_76759_H = 65500;
        this.fogboundGen = new WorldGenFogboundLake(this);
        this.includedBiomes = new BiomeGenBase[]{PixelmonGen.mysteryValleyEdge};
        this.func_150570_a(new BiomeGenBase.Height(-0.05f, 0.2f));
    }

    public void initStructures() {
        StructureData temple = StructureRegistry.getScatteredStructureFromName("ValleyTemple");
        StructureData tower = StructureRegistry.getScatteredStructureFromName("ValleyTower");
        StructureData garden = StructureRegistry.getScatteredStructureFromName("ValleyGarden");
        StructureData houseMini = StructureRegistry.getScatteredStructureFromName("ValleyHouse_Mini");
        StructureData houseHelical = StructureRegistry.getScatteredStructureFromName("ValleyHouse_Helical");
        StructureData houseIndented = StructureRegistry.getScatteredStructureFromName("ValleyHouse_Indented");
        StructureData houseLarge = StructureRegistry.getScatteredStructureFromName("ValleyHouse_Large");
        Object[] all = new StructureData[]{temple, tower, garden, houseMini, houseHelical, houseLarge};
        System.out.println(Arrays.toString(all));
        for (Object d : all) {
            if (((StructureData)d).hasModifierOfType(SpawnCriteriaSpecificBiome.class)) continue;
            ((StructureData)d).spawnCriteria.add(new SpecialParameters("fitInBiome", new String[]{"biome = mysteryValley"}));
        }
        this.smallStructures = new StructureData[]{houseMini, houseHelical, houseIndented};
        this.bigStructures = new StructureData[]{temple, tower, garden, houseLarge};
        float[] chances = new float[]{0.1f, 0.1f, 0.1f};
    }

    public int getBiomeGrassColor() {
        return 10405829;
    }

    @SideOnly(value=Side.CLIENT)
    public int getBiomeFoliageColor() {
        return 15000440;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76731_a(float temp) {
        Color base = new Color(super.func_76731_a(temp));
        float[] rgb = base.getColorComponents(null);
        return new Color(rgb[0] * 1.2f, rgb[1], rgb[2]).getRGB();
    }

    @Override
    public void decorateImpl(World world, Random random, int x, int z) {
        if (this.blocked) {
            return;
        }
        if ((PixelmonGen.structuresBitmaskMV & 4) != 0) {
            this.doBigStructure(world, random, x, z);
            this.doSmallStructure(world, random, x, z);
        }
        if ((PixelmonGen.structuresBitmaskMV & 1) != 0) {
            this.mysteryDungeon(world, random, x, z);
        }
        this.field_76760_I.func_150512_a(world, random, (BiomeGenBase)this, x, z);
        System.out.println("!");
    }

    protected void mysteryDungeon(World world, Random rand, int x, int z) {
        if (this.blocked) {
            return;
        }
        if (rand.nextInt(20) <= 15) {
            int i = x + rand.nextInt(16);
            int j = z + rand.nextInt(16);
            int y = world.func_72825_h(i, j);
            this.block();
            this.dungeonGen = new WorldGenMysteryDungeon(new DungeonBuilderStandard(), new DungeonEntranceStandard(), MysteryDungeonValues.FANTASY, this, 6, 6, false, false, false).setExtras(new DungeonBonusTreasure(0, 5, 0.35f, 0.75f, EnumTreasureRarity.values()));
            this.dungeonGen.func_76484_a(world, rand, i, y, j);
            this.enable();
        }
    }

    protected void doSmallStructure(World world, Random rand, int x, int z) {
        if (this.blocked) {
            return;
        }
        if (rand.nextInt(40) > 5) {
            return;
        }
        this.block();
        int y = world.func_72825_h(x, z);
        ComplexScattered structure = (ComplexScattered)this.smallStructures[this.smallIndex].createStructure(rand, x, y, z, true, false);
        structure.setShouldSave(true);
        boolean success = structure.generate(world, rand);
        if (success) {
            ++this.smallIndex;
            if (this.smallIndex >= this.smallStructures.length) {
                this.smallIndex = 0;
            }
        }
        this.enable();
    }

    protected void doBigStructure(World world, Random rand, int x, int z) {
        if (this.blocked) {
            return;
        }
        if (rand.nextInt(40) > 30) {
            return;
        }
        this.block();
        int y = world.func_72825_h(x, z);
        ComplexScattered structure = (ComplexScattered)this.bigStructures[this.bigIndex].createStructure(rand, x, y, z, true, false);
        structure.setShouldSave(true);
        boolean success = structure.generate(world, rand);
        if (success || structure.statusCode == StructureRegistry.getStatusCodeFor(SpawnCriteriaMinDistance.class)) {
            ++this.bigIndex;
            if (this.bigIndex >= this.bigStructures.length) {
                this.bigIndex = 0;
            }
        }
        this.enable();
    }

    public void block() {
        this.blocked = true;
    }

    public void enable() {
        this.blocked = false;
    }

    @Override
    public BiomeGenBase getShoreBiome() {
        return PixelmonGen.mysteryValleyEdge;
    }

    @Override
    public BiomeGenBase nonAdjacentBiomeCriteria() {
        return this;
    }

    @Override
    protected ClusterDataMysteryValley newClusterDetails(World world, EntryList2D<ClusterDataMysteryValley> cluster) {
        return new ClusterDataMysteryValley();
    }

    @Override
    protected BiomeGenBase[] otherBiomesCounted() {
        return this.includedBiomes;
    }
}

