/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.biome;

import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.PixelmonDebug;
import com.pixelmonmod.pixelmon.util.testing.AbstractDrawable;
import com.pixelmonmod.pixelmon.util.testing.TestingCanvas;
import com.pixelmonmod.pixelmon.worldGeneration.biome.data.AbstractBiomeClusterData;
import java.util.AbstractMap;
import java.util.Random;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BiomeGenShaped<T extends AbstractBiomeClusterData>
extends BiomeGenBase {
    protected boolean debugLayoutPopup = false;
    protected boolean initializedOffset = false;
    int offsetX;
    int offsetY;
    protected EntryList2D<AbstractMap.SimpleEntry<EntryList2D<T>, T>> plannedLayout = new EntryList2D();
    protected AbstractMap.SimpleEntry<EntryList2D<T>, T> currentCluster;

    public BiomeGenShaped(int par1) {
        super(par1);
    }

    public final void func_76728_a(World world, Random random, int x, int z) {
        if (this.isPartOfLayout(world.getBiomeGenForCoordsBody(x, z))) {
            this.currentCluster = this.addLayout(world, random, this.getEntryAt(x >> 4, z >> 4), x >> 4, z >> 4, false);
        }
        this.decorateImpl(world, random, x, z);
    }

    protected abstract void decorateImpl(World var1, Random var2, int var3, int var4);

    protected abstract T newClusterDetails(World var1, EntryList2D<T> var2);

    protected abstract BiomeGenBase[] otherBiomesCounted();

    private AbstractMap.SimpleEntry<EntryList2D<T>, T> addLayout(World world, Random random, AbstractMap.SimpleEntry<EntryList2D<T>, T> entry, int chunkX, int chunkZ, boolean recursiveCall) {
        if (entry == null && (entry = this.plannedLayout.get(chunkX, chunkZ)) == null) {
            PixelmonDebug.printStackElements(10);
            EntryList2D cluster = new EntryList2D();
            entry = new AbstractMap.SimpleEntry(cluster, this.newClusterDetails(world, cluster));
        }
        this.recursiveAdd(world, random, entry, chunkX, chunkZ);
        if (((AbstractBiomeClusterData)entry.getValue()).needsInit) {
            ((AbstractBiomeClusterData)entry.getValue()).init(world, entry.getKey());
            if (this.debugLayoutPopup) {
                TestingCanvas tc = TestingCanvas.createSimpleScreen("BiomeGenShaped");
                if (!this.initializedOffset) {
                    this.offsetX = entry.getKey().minX();
                    this.offsetY = -entry.getKey().minZ().intValue();
                    this.initializedOffset = true;
                }
                tc.setTranslation(this.offsetX, this.offsetY);
                tc.setDrawables(new AbstractDrawable.NonNullDrawing(entry.getKey()));
            }
        }
        return entry;
    }

    private void recursiveAdd(World world, Random random, AbstractMap.SimpleEntry<EntryList2D<T>, T> entry, int chunkX, int chunkZ) {
        if (!this.plannedLayout.contains(chunkX, chunkZ)) {
            this.plannedLayout.addValue(chunkX, chunkZ, entry);
            entry.getKey().addValue(chunkX, chunkZ, entry.getValue());
            for (ForgeDirection dir : WorldHelper.NWSE) {
                int x0 = chunkX + dir.offsetX;
                int z0 = chunkZ + dir.offsetZ;
                BiomeGenBase otherBiome = world.getBiomeGenForCoordsBody(x0 << 4, z0 << 4);
                for (int i = 0; i < 4 && otherBiome == BiomeGenBase.field_76781_i; ++i) {
                    otherBiome = world.getBiomeGenForCoordsBody((x0 += dir.offsetX) << 4, (z0 += dir.offsetZ) << 4);
                }
                if (!this.isPartOfLayout(otherBiome)) continue;
                this.recursiveAdd(world, random, entry, x0, z0);
            }
        }
    }

    public AbstractMap.SimpleEntry<EntryList2D<T>, T> getEntryAt(int chunkX, int chunkZ) {
        return this.plannedLayout.get(chunkX, chunkZ);
    }

    protected boolean isPartOfLayout(BiomeGenBase compareAgainst) {
        if (compareAgainst == this) {
            return true;
        }
        BiomeGenBase[] validBiomes = this.otherBiomesCounted();
        if (validBiomes != null) {
            for (int i = 0; i < validBiomes.length; ++i) {
                if (validBiomes[i] != compareAgainst) continue;
                return true;
            }
        }
        return false;
    }

    protected void initChunkSeed(Random random, World world, int chunkX, int chunkZ) {
        long seed = world.func_72905_C();
        seed *= seed * 6364136223846793005L + 1442695040888963407L;
        seed += (long)chunkX;
        seed *= seed * 6364136223846793005L + 1442695040888963407L;
        seed += (long)chunkZ;
        seed *= seed * 6364136223846793005L + 1442695040888963407L;
        seed += (long)chunkX;
        seed *= seed * 6364136223846793005L + 1442695040888963407L;
        random.setSeed(seed += (long)chunkZ);
    }
}

