/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.biome.data;

import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.config.PixelmonGen;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.Link2D;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.worldGeneration.WorldGenFogboundLake;
import com.pixelmonmod.pixelmon.worldGeneration.biome.data.AbstractBiomeClusterData;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class ClusterDataMysteryValley
extends AbstractBiomeClusterData<ClusterDataMysteryValley> {
    public ForgeDirection entranceSide;
    public int[] fbCoords;

    @Override
    public void initImpl(World world, EntryList2D<ClusterDataMysteryValley> cluster) {
        this.entranceSide = WorldHelper.NWSE[this.constRandom.nextInt(WorldHelper.NWSE.length)];
        this.fbCoords = this.coordsForFogboundLake();
        if (this.fbCoords != null) {
            int x = this.fbCoords[0] * 16;
            int z = this.fbCoords[1] * 16;
            PixelmonGen.mysteryValley.block();
            WorldGenFogboundLake fbl = new WorldGenFogboundLake(PixelmonGen.mysteryValley);
            fbl.func_76484_a(world, this.constRandom, x, world.func_72825_h(x, z), z);
            PixelmonGen.mysteryValley.enable();
        }
    }

    private int[] coordsForFogboundLake() {
        int midChunkX = this.cluster.midX();
        int midChunkZ = this.cluster.midZ();
        ArrayList<Link2D> pointsList = new ArrayList<Link2D>();
        EntryList2D shape = (EntryList2D)new EntryList2D<Object>().modifyWithShape(new Ellipse2D.Float(-3.0f, -3.0f, 7.0f, 7.0f), CommonHelper.THING);
        for (Link2D link : this.cluster) {
            if (!this.canFogboundLakeFitHere(shape, link.x, link.z)) continue;
            pointsList.add(link);
        }
        if (pointsList.isEmpty()) {
            return null;
        }
        Link2D coords = (Link2D)pointsList.get(pointsList.size() / 2);
        return new int[]{coords.x, coords.z};
    }

    private boolean canFogboundLakeFitHere(EntryList2D shape, int x, int z) {
        return WorldHelper.canChunksFitWithinBiome(this.world, PixelmonGen.mysteryValley, x << 4, z << 4, 0, 1, shape, 0);
    }
}

