/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.layer;

import com.pixelmonmod.pixelmon.worldGeneration.layer.GenLayerAddRareBiome;
import com.pixelmonmod.pixelmon.worldGeneration.layer.GenLayerCustomShore;
import com.pixelmonmod.pixelmon.worldGeneration.layer.GenLayerInsert;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.lang.reflect.Field;
import net.minecraft.world.WorldType;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerBiome;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerRiver;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.GenLayerShore;
import net.minecraftforge.event.terraingen.WorldTypeEvent;

public class InfiltratorGenLayer {
    private static Field parentField;
    private static Field worldSeedField;
    private static Field[] riverMixParents;
    public static final InfiltratorGenLayer INSTANCE;

    @SubscribeEvent
    public void onInitBiomeGensEvent(WorldTypeEvent.InitBiomeGens event) {
        if (event.worldType != WorldType.field_77137_b) {
            return;
        }
        if (parentField == null) {
            InfiltratorGenLayer.initFields();
        }
        GenLayer[] biomeGens = event.newBiomeGens;
        GenLayerAddRareBiome rareBiomes = new GenLayerAddRareBiome(200L);
        GenLayerCustomShore customShore = new GenLayerCustomShore(200L);
        InfiltratorGenLayer.insertBelow(rareBiomes, GenLayerBiome.class, biomeGens[0], event.worldType);
        InfiltratorGenLayer.insertBelow(customShore, GenLayerShore.class, biomeGens[0], event.worldType);
    }

    public static void insertBelow(GenLayerInsert insertThis, Class<? extends GenLayer> aboveClass, GenLayer hierarchyLayer, WorldType type) {
        try {
            while (hierarchyLayer != null && InfiltratorGenLayer.getParent(hierarchyLayer) != null && !InfiltratorGenLayer.getParent(hierarchyLayer).getClass().equals(aboveClass)) {
                hierarchyLayer = InfiltratorGenLayer.getParent(hierarchyLayer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        GenLayer top = null;
        try {
            top = InfiltratorGenLayer.getParent(hierarchyLayer);
            insertThis.init(top, type);
            parentField.set(hierarchyLayer, (Object)insertThis);
            insertThis.func_75905_a(worldSeedField.getLong(hierarchyLayer));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void initFields() {
        for (Field f : GenLayer.class.getDeclaredFields()) {
            if (!f.getType().equals(GenLayer.class)) continue;
            f.setAccessible(true);
            parentField = f;
            break;
        }
        riverMixParents = new Field[2];
        int i = 0;
        for (Field f : GenLayerRiverMix.class.getDeclaredFields()) {
            if (!f.getType().equals(GenLayer.class)) continue;
            f.setAccessible(true);
            InfiltratorGenLayer.riverMixParents[i] = f;
            ++i;
        }
        InfiltratorGenLayer.initWorldSeedField();
    }

    private static void initWorldSeedField() {
        GenLayerIsland dummyLayer = new GenLayerIsland(2L);
        dummyLayer.func_75905_a(0L);
        for (Field field : GenLayer.class.getDeclaredFields()) {
            if (field.getType() != Long.TYPE) continue;
            field.setAccessible(true);
            try {
                if (field.getLong(dummyLayer) != 153980186397367576L) continue;
                worldSeedField = field;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static GenLayer getParent(GenLayer genLayer) {
        Object result = null;
        try {
            if (genLayer.getClass().equals(GenLayerRiverMix.class)) {
                if (!(InfiltratorGenLayer.getParent((GenLayer)riverMixParents[0].get(genLayer)) instanceof GenLayerRiver)) {
                    return (GenLayer)riverMixParents[0].get(genLayer);
                }
                return (GenLayer)riverMixParents[1].get(genLayer);
            }
            return (GenLayer)parentField.get(genLayer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        INSTANCE = new InfiltratorGenLayer();
    }
}

