/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon;

import com.pixelmonmod.pixelmon.worldGeneration.WorldGenMysteryDungeon;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.DungeonBuilderStandard;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.MysteryDungeonFloor;
import java.util.Random;
import net.minecraft.world.World;

public abstract class AbstractDungeonBuilder {
    protected WorldGenMysteryDungeon dungeon;
    protected Integer minY;
    protected Integer maxY;

    public void setDungeon(WorldGenMysteryDungeon d) {
        this.dungeon = d;
    }

    public void build(World world, WorldGenMysteryDungeon dungeon, MysteryDungeonFloor[] floors, Random random, int x, int y, int z) {
        int y0;
        int i;
        for (i = 0; i < floors.length; ++i) {
            y0 = y + i * (dungeon.floorHeight + 2);
            dungeon.entrance.modFloorMap(world, dungeon, floors[i], random, x, y0, z, i);
        }
        for (i = 0; i < floors.length; ++i) {
            y0 = y + i * (dungeon.floorHeight + 2);
            this.genFloor(world, floors[i], random, x, y0, z, i);
        }
        this.genOthers(world, random, x, y, z);
    }

    protected abstract void genFloor(World var1, MysteryDungeonFloor var2, Random var3, int var4, int var5, int var6, int var7);

    protected abstract void genOthers(World var1, Random var2, int var3, int var4, int var5);

    public abstract int[] modStartingPoint(World var1, int var2, int var3, int var4);

    public abstract int getMinY();

    public abstract int getMaxY();

    public static enum BuilderType {
        STANDARD(DungeonBuilderStandard.class);

        public final Class<? extends AbstractDungeonBuilder> builderClass;

        private BuilderType(Class<? extends AbstractDungeonBuilder> clazz) {
            this.builderClass = clazz;
        }
    }
}

