/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon;

import com.pixelmonmod.pixelmon.Pixelmon;
import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.config.PixelmonBlocks;
import com.pixelmonmod.pixelmon.config.PixelmonItems;
import com.pixelmonmod.pixelmon.config.PixelmonItemsTMs;
import com.pixelmonmod.pixelmon.enums.EnumApricorns;
import com.pixelmonmod.pixelmon.enums.EnumEvolutionStone;
import com.pixelmonmod.pixelmon.enums.EnumPokeballs;
import com.pixelmonmod.pixelmon.enums.EnumTreasureRarity;
import com.pixelmonmod.pixelmon.items.ArmorToolLibrary;
import com.pixelmonmod.pixelmon.util.ChancedCollection;
import com.pixelmonmod.pixelmon.util.ChancedStack;
import com.pixelmonmod.pixelmon.util.ChancedWrapper;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.AbstractDungeonBonus;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.MysteryDungeonFloor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.WeightedRandomChestContent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenDungeons;

public class DungeonBonusTreasure
extends AbstractDungeonBonus {
    private static boolean debugRegistration = false;
    private static boolean init = false;
    private static final String sayRegistration = "Registering %s with chance '%s' as %s";
    protected static HashSet<ChancedWrapper> commonItems = new HashSet();
    protected static HashSet<ChancedWrapper> uncommonItems = new HashSet();
    protected static HashSet<ChancedWrapper> semirareItems = new HashSet();
    protected static HashSet<ChancedWrapper> rareItems = new HashSet();
    protected static HashSet<ChancedWrapper> veryrareItems = new HashSet();
    protected static HashSet<ChancedWrapper> superrareItems = new HashSet();
    protected static HashSet<ChancedWrapper> ultrarareItems = new HashSet();
    protected static HashSet<ChancedWrapper> allItems = new HashSet();
    private static HashSet<ChancedWrapper>[] itemSets = new HashSet[]{commonItems, uncommonItems, semirareItems, rareItems, veryrareItems, superrareItems, ultrarareItems};
    public final int minChests;
    public final int maxChests;
    protected final float firstFloorSlotChance;
    protected final float finalFloorSlotChance;
    public final HashSet<ChancedWrapper> itemCollection = new HashSet();
    protected static Random statRandom = new Random();
    protected final Random myRandom;

    public DungeonBonusTreasure(int minChests, int maxChests, float firstFloorSlotFillChance, float finalFloorSlotFillChance, EnumTreasureRarity ... pickFrom) {
        this.minChests = minChests;
        this.maxChests = maxChests;
        this.myRandom = new Random();
        this.firstFloorSlotChance = firstFloorSlotFillChance;
        this.finalFloorSlotChance = finalFloorSlotFillChance;
        for (EnumTreasureRarity rarity : pickFrom) {
            int id = rarity.ordinal();
            if (id > 6) continue;
            this.itemCollection.addAll(itemSets[id]);
        }
    }

    public static boolean canInstantiate() {
        return Pixelmon.postInitialized();
    }

    public static void initRareItems() {
        if (init) {
            throw new IllegalStateException("DungeonExtraTreasure was already initialized!");
        }
        ArrayList<ChancedStack> apris = new ArrayList<ChancedStack>();
        ArrayList<ChancedStack> cookApris = new ArrayList<ChancedStack>();
        for (EnumApricorns apricorn : EnumApricorns.values()) {
            ChancedStack stack = new ChancedStack(new ItemStack((Item)apricorn.apricorn()), statRandom, EnumTreasureRarity.COMMON.chance, 3, 7);
            apris.add(stack);
            stack = new ChancedStack(new ItemStack((Item)apricorn.cookedApricorn()), statRandom, EnumTreasureRarity.COMMON.chance, 3, 7);
            cookApris.add(stack);
        }
        ArrayList<ChancedStack> stones = new ArrayList<ChancedStack>();
        for (EnumEvolutionStone stone : EnumEvolutionStone.values()) {
            if (stone.getItem(0) == null) continue;
            ChancedStack stack = new ChancedStack(new ItemStack((Item)stone.getItem(0)), statRandom, EnumTreasureRarity.ALWAYS.chance, 0, 1);
            stones.add(stack);
        }
        ArrayList<ChancedStack> balls = new ArrayList<ChancedStack>();
        ArrayList<ChancedStack> lids = new ArrayList<ChancedStack>();
        ArrayList<ChancedStack> discs = new ArrayList<ChancedStack>();
        for (EnumPokeballs ballType : EnumPokeballs.values()) {
            float baseRarity = EnumTreasureRarity.estimateRarity(ballType);
            int minSize = Math.max(1, ballType.quantityMade - 2);
            int maxSize = ballType == EnumPokeballs.MasterBall ? 1 : Math.max(1, ballType.quantityMade + 5);
            ItemStack stack = new ItemStack((Item)ballType.getItem());
            ChancedStack chancedStack = new ChancedStack(stack, statRandom, baseRarity, minSize, maxSize);
            balls.add(chancedStack);
            if (ballType.getDisc() == null) continue;
            stack = new ItemStack((Item)ballType.getDisc());
            chancedStack = new ChancedStack(stack, statRandom, baseRarity, minSize, maxSize);
            discs.add(chancedStack);
            stack = new ItemStack((Item)ballType.getLid());
            chancedStack = new ChancedStack(stack, statRandom, baseRarity, minSize, maxSize);
            lids.add(chancedStack);
        }
        ArrayList<ChancedStack> diamondArmors = new ArrayList<ChancedStack>();
        for (ItemArmor.ArmorMaterial armorMat : ArmorToolLibrary.ARMOR.keySet()) {
            if (armorMat != ItemArmor.ArmorMaterial.DIAMOND) continue;
            for (ItemArmor armor : ArmorToolLibrary.ARMOR.get((Object)armorMat)) {
                if (armor == null) continue;
                ChancedStack cstack = new ChancedStack(new ItemStack((Item)armor), statRandom, EnumTreasureRarity.COMMON.chance, 0, 1);
                diamondArmors.add(cstack);
            }
        }
        ArrayList<ChancedStack> diamondTools = new ArrayList<ChancedStack>();
        for (Item.ToolMaterial toolMat : ArmorToolLibrary.TOOLS.keySet()) {
            if (toolMat != Item.ToolMaterial.EMERALD) continue;
            for (ItemTool tool : ArmorToolLibrary.TOOLS.get((Object)toolMat)) {
                ChancedStack cstack = new ChancedStack(new ItemStack((Item)tool), statRandom, EnumTreasureRarity.UNCOMMON.chance, 0, 1);
                diamondTools.add(cstack);
            }
        }
        ArrayList<ChancedStack> tms = new ArrayList<ChancedStack>();
        for (Item tm : PixelmonItemsTMs.TMs) {
            ChancedStack cstack = new ChancedStack(new ItemStack(tm), statRandom, EnumTreasureRarity.UNCOMMON.average(EnumTreasureRarity.COMMON), 1, 1);
            tms.add(cstack);
        }
        ArrayList<ChancedStack> vanillaStuff = new ArrayList<ChancedStack>();
        for (WeightedRandomChestContent defaultTreasure : WorldGenDungeons.field_111189_a) {
            float rarity = (float)(GeometryHelper.slider(defaultTreasure.field_76292_a, 0.0, 10.0) * (double)EnumTreasureRarity.COMMON.chance);
            ChancedStack cstack = new ChancedStack(defaultTreasure.field_76297_b, statRandom, rarity, defaultTreasure.field_76295_d, defaultTreasure.field_76296_e);
            vanillaStuff.add(cstack);
        }
        vanillaStuff.add(new ChancedStack(new ItemStack(Items.field_151045_i), statRandom, EnumTreasureRarity.RARE.average(EnumTreasureRarity.VERY_RARE), 1, 5));
        vanillaStuff.add(new ChancedStack(new ItemStack(Items.field_151166_bC), statRandom, EnumTreasureRarity.VERY_RARE.chance, 1, 5));
        DungeonBonusTreasure.registerRareItem(new ItemStack(PixelmonBlocks.fossil), EnumTreasureRarity.RARE.chance, 0, 2);
        DungeonBonusTreasure.registerRareItem(new ItemStack(PixelmonItems.superRod), EnumTreasureRarity.RARE.chance, 0, 1);
        DungeonBonusTreasure.registerRareCategory(apris, EnumTreasureRarity.COMMON.chance);
        DungeonBonusTreasure.registerRareCategory(cookApris, EnumTreasureRarity.COMMON.average(EnumTreasureRarity.COMMON.average(EnumTreasureRarity.UNCOMMON)));
        DungeonBonusTreasure.registerRareCategory(discs, EnumTreasureRarity.COMMON.average(EnumTreasureRarity.UNCOMMON));
        DungeonBonusTreasure.registerRareCategory(lids, EnumTreasureRarity.UNCOMMON.chance);
        DungeonBonusTreasure.registerRareCategory(balls, EnumTreasureRarity.UNCOMMON.average(EnumTreasureRarity.UNLIKELY));
        DungeonBonusTreasure.registerRareCategory(stones, EnumTreasureRarity.UNLIKELY.chance);
        DungeonBonusTreasure.registerRareCategory(tms, EnumTreasureRarity.RARE.average(EnumTreasureRarity.SEMI_RARE));
        DungeonBonusTreasure.registerRareCategory(diamondArmors, EnumTreasureRarity.RARE.average(EnumTreasureRarity.VERY_RARE));
        DungeonBonusTreasure.registerRareCategory(diamondTools, EnumTreasureRarity.RARE.average(EnumTreasureRarity.VERY_RARE));
        DungeonBonusTreasure.registerRareCategory(vanillaStuff, EnumTreasureRarity.COMMON.chance);
        init = true;
    }

    public static ChancedStack registerRareItem(ItemStack stack, EnumTreasureRarity rarity, int minStack, int maxStack) {
        ChancedStack content = new ChancedStack(stack, statRandom, rarity.chance, minStack, maxStack);
        HashSet<ChancedWrapper> set = itemSets[rarity.ordinal()];
        DungeonBonusTreasure.addRareItem(set, content);
        return content;
    }

    public static ChancedStack registerRareItem(ItemStack stack, float chance, int minStack, int maxStack) {
        ChancedStack content = new ChancedStack(stack, statRandom, chance, minStack, maxStack);
        EnumTreasureRarity rarity = EnumTreasureRarity.round(chance);
        HashSet<ChancedWrapper> set = itemSets[rarity.ordinal()];
        DungeonBonusTreasure.addRareItem(set, content);
        return content;
    }

    public static ChancedWrapper registerRareCategory(Collection<ChancedStack> itemCategory, float chance) {
        ChancedCollection<ChancedStack> content = new ChancedCollection<ChancedStack>(itemCategory, chance);
        EnumTreasureRarity rarity = EnumTreasureRarity.round(chance);
        HashSet<ChancedWrapper> set = itemSets[rarity.ordinal()];
        set.add(content);
        allItems.add(content);
        return content;
    }

    protected static void addRareItem(Set<ChancedWrapper> set, ChancedStack content) {
        set.add(content);
        allItems.add(content);
    }

    public static TreeSet<ChancedWrapper> getEverything() {
        return new TreeSet<ChancedWrapper>(allItems);
    }

    @Override
    protected void genFloor(World world, MysteryDungeonFloor floor, Random random, int x, int y, int z, int floorIndex) {
        ++y;
        int chestsAmt = RandomHelper.useRandomForNumberBetween(random, this.minChests, this.maxChests);
        for (int i = 0; i < chestsAmt; ++i) {
            float slotFillChance;
            int[] chestPoint = floor.randomPoint(random, true);
            floor.theMap.set(chestPoint[0], chestPoint[1], -8);
            int x0 = x + chestPoint[0];
            int z0 = z + chestPoint[1];
            world.func_147465_d(x0, y, z0, (Block)Blocks.field_150486_ae, 0, 2);
            TileEntityChest chest = (TileEntityChest)world.func_147438_o(x0, y, z0);
            if (this.finalFloorSlotChance == this.firstFloorSlotChance) {
                slotFillChance = this.firstFloorSlotChance;
            } else {
                float floorValue = (float)GeometryHelper.slider(floorIndex, 0.0, this.dungeon.numFloors - 1);
                slotFillChance = (float)(this.dungeon.up ? GeometryHelper.inverseSlider(floorValue, this.firstFloorSlotChance, this.finalFloorSlotChance) : GeometryHelper.inverseSlider(floorValue, this.finalFloorSlotChance, this.firstFloorSlotChance));
            }
            for (int j = 0; j < chest.func_70302_i_(); ++j) {
                Collection stacks;
                ChancedStack cStack;
                ChancedWrapper stack;
                if (!ChancedWrapper.chosen(slotFillChance, this.myRandom) || (stack = ChancedWrapper.weightedChoice(this.itemCollection, this.myRandom, true)) == null) continue;
                ItemStack newStack = null;
                if (stack instanceof ChancedStack) {
                    newStack = ((ChancedStack)stack).newStack(random);
                } else if (stack instanceof ChancedCollection && (cStack = (ChancedStack)ChancedWrapper.weightedChoice(stacks = (Collection)stack.object, this.myRandom, true)) != null) {
                    newStack = cStack.newStack(random);
                }
                if (newStack == null || newStack.field_77994_a == 0) continue;
                chest.func_70299_a(j, newStack);
            }
        }
    }

    @Override
    protected void genOthers(World world, Random random, int x, int y, int z) {
    }
}

