/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon;

import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.util.Link2D;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.AbstractDungeonBuilder;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.MysteryDungeonFloor;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DungeonBuilderStandard
extends AbstractDungeonBuilder {
    @Override
    protected void genFloor(World world, MysteryDungeonFloor floor, Random random, int x, int y, int z, int floorIndex) {
        this.initYs();
        for (Link2D link2D : floor.theMap) {
            Object[] objectArray;
            int i = link2D.x;
            int j = link2D.z;
            if (MysteryDungeonFloor.isDangerBlock(i, j)) {
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = Blocks.field_150357_h;
                objectArray = objectArray2;
                objectArray2[1] = 0;
            } else {
                Object[] objectArray3 = new Object[2];
                objectArray3[0] = this.dungeon.values.wallID;
                objectArray = objectArray3;
                objectArray3[1] = this.dungeon.values.wallMeta;
            }
            Object[] danger = objectArray;
            world.func_147465_d(x + i, y - 1, z + j, (Block)danger[0], ((Integer)danger[1]).intValue(), 2);
            if ((Integer)link2D.value == -6 && floorIndex + 1 == this.dungeon.numFloors) {
                floor.theMap.set(i, j, -1);
            }
            this.genStripAt(world, x + i, y, z + j, floor.theMap.get(i, j), floorIndex);
        }
        this.genLadder(world, floor, x, y, z, floorIndex);
    }

    @Override
    protected void genOthers(World world, Random random, int x, int y, int z) {
        this.genRoofAndFoundation(world, x, y, z);
    }

    protected void genStripAt(World world, int x, int y, int z, int id, int floorIndex) {
        block6: for (int n = 0; n <= this.dungeon.floorHeight; ++n) {
            switch (id) {
                case -3: {
                    world.func_147465_d(x, y + n, z, this.dungeon.values.wallID, this.dungeon.values.wallMeta, 2);
                    continue block6;
                }
                case -2: 
                case -1: {
                    this.hollowPart(world, x, y, z, n);
                    continue block6;
                }
                case -6: {
                    if (floorIndex + 1 == this.dungeon.numFloors) {
                        this.hollowPart(world, x, y, z, n);
                        continue block6;
                    }
                    if (n == 0) {
                        world.func_147465_d(x, y, z, this.dungeon.values.floorID, this.dungeon.values.floorMeta, 2);
                        continue block6;
                    }
                    if (n == this.dungeon.floorHeight) {
                        world.func_147465_d(x, y + n, z, this.dungeon.values.ceilingID, this.dungeon.values.ceilingMeta, 2);
                        continue block6;
                    }
                    world.func_147465_d(x, y + n, z, this.dungeon.values.shaftID, this.dungeon.values.shaftMeta, 2);
                    continue block6;
                }
                case -7: {
                    world.func_147465_d(x, y + n, z, Blocks.field_150357_h, 0, 2);
                }
            }
        }
    }

    private void hollowPart(World world, int x, int y, int z, int n) {
        if (n == 0) {
            world.func_147465_d(x, y, z, this.dungeon.values.floorID, this.dungeon.values.floorMeta, 2);
        } else if (n == this.dungeon.floorHeight) {
            world.func_147465_d(x, y + n, z, this.dungeon.values.ceilingID, this.dungeon.values.ceilingMeta, 2);
        } else {
            world.func_147468_f(x, y + n, z);
        }
    }

    private void genLadder(World world, MysteryDungeonFloor floor, int x, int y, int z, int floorIndex) {
        int[] ladder = floor.myStairsPoint();
        int x0 = x + ladder[0];
        int z0 = z + ladder[1];
        int ladderMeta = ladder[2];
        int[] ensuredLadder = floor.ensureStairsPoint();
        boolean stackedLadder = ensuredLadder != null && ensuredLadder[0] == ladder[0] && ensuredLadder[1] == ladder[1];
        for (int n = 0; n <= this.dungeon.floorHeight; ++n) {
            if (n == 0) {
                if (!stackedLadder) {
                    world.func_147465_d(x0, y, z0, this.dungeon.values.floorID, this.dungeon.values.floorMeta, 2);
                }
            } else if (floorIndex + 1 == this.dungeon.numFloors) {
                if (n == this.dungeon.floorHeight) {
                    world.func_147465_d(x0, y + n, z0, this.dungeon.values.ceilingID, this.dungeon.values.ceilingMeta, 2);
                } else {
                    world.func_147468_f(x0, y + n, z0);
                }
            } else {
                world.func_147465_d(x0, y + n, z0, Blocks.field_150468_ap, ladderMeta, 2);
            }
            if (ensuredLadder == null) continue;
            if (n == 0) {
                world.func_147465_d(x + ensuredLadder[0], y, z + ensuredLadder[1], Blocks.field_150468_ap, ensuredLadder[2], 2);
                world.func_147465_d(x + ensuredLadder[0], y - 1, z + ensuredLadder[1], Blocks.field_150468_ap, ensuredLadder[2], 2);
                for (ForgeDirection dir : WorldHelper.NWSE) {
                    world.func_147465_d(x + ensuredLadder[0] + dir.offsetX, y - 1, z + ensuredLadder[1] + dir.offsetZ, this.dungeon.values.wallID, this.dungeon.values.wallMeta, 2);
                }
                continue;
            }
            if (n == this.dungeon.floorHeight) {
                if (stackedLadder) continue;
                world.func_147465_d(x + ensuredLadder[0], y + this.dungeon.floorHeight, z + ensuredLadder[1], this.dungeon.values.ceilingID, this.dungeon.values.ceilingMeta, 2);
                continue;
            }
            if (stackedLadder) continue;
            world.func_147468_f(x + ensuredLadder[0], y + n, z + ensuredLadder[1]);
        }
        if (ensuredLadder != null) {
            world.func_147465_d(x + ensuredLadder[0], y, z + ensuredLadder[1], Blocks.field_150468_ap, ensuredLadder[2], 2);
            if (!stackedLadder) {
                world.func_147465_d(x + ensuredLadder[0], y + this.dungeon.floorHeight, z + ensuredLadder[1], this.dungeon.values.ceilingID, this.dungeon.values.ceilingMeta, 2);
            }
        }
        if (floorIndex + 1 == this.dungeon.numFloors) {
            floor.theMap.set(ladder[0], ladder[1], -1);
        }
    }

    private void genDangerStripAt(World world, int x, int y, int z) {
        for (int n = 0; n <= this.dungeon.floorHeight; ++n) {
            world.func_147465_d(x, y + n, z, Blocks.field_150357_h, 0, 2);
        }
    }

    private void genRoofAndFoundation(World world, int x, int y, int z) {
        int ry = y + this.dungeon.numFloors * (this.dungeon.floorHeight + 2) - 1;
        int fy = y - 1;
        for (int i : MysteryDungeonFloor.outerLayer.xList()) {
            for (int j : MysteryDungeonFloor.outerLayer.zList(i)) {
                world.func_147465_d(x + i, ry, z + j, Blocks.field_150357_h, 0, 2);
                world.func_147465_d(x + i, fy, z + j, Blocks.field_150357_h, 0, 2);
            }
        }
        int i = 0;
        while (true) {
            if (i > 65) break;
            int j = 0;
            while (true) {
                if (j > 65) break;
                world.func_147465_d(x + i, ry, z + j, Blocks.field_150357_h, 0, 2);
                world.func_147465_d(x + i, fy, z + j, Blocks.field_150357_h, 0, 2);
                ++j;
            }
            ++i;
        }
    }

    protected void initYs() {
    }

    @Override
    public int getMinY() {
        return -1;
    }

    @Override
    public int getMaxY() {
        return this.dungeon.numFloors * (this.dungeon.floorHeight + 2);
    }

    @Override
    public int[] modStartingPoint(World world, int x, int y, int z) {
        int[] nArray;
        if (this.dungeon.up) {
            int[] nArray2 = new int[3];
            nArray2[0] = x;
            nArray2[1] = y;
            nArray = nArray2;
            nArray2[2] = z;
        } else {
            int[] nArray3 = new int[3];
            nArray3[0] = x;
            nArray3[1] = Math.max(y - this.getMaxY() - 3, 1);
            nArray = nArray3;
            nArray3[2] = z;
        }
        return nArray;
    }
}

