/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.Array2D;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.Link2D;
import com.pixelmonmod.pixelmon.util.geom.ShapeHelper;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;
import com.pixelmonmod.pixelmon.worldGeneration.WorldGenMysteryDungeon;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.AbstractDungeonEntrance;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.MysteryDungeonFloor;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.RoomMarker;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.Random;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class DungeonEntranceStandard
extends AbstractDungeonEntrance {
    @Override
    public void modFloorMap(World world, WorldGenMysteryDungeon dungeon, MysteryDungeonFloor floor, Random random, int x, int y, int z, int floorIteration) {
        if (dungeon.up && floorIteration == 0) {
            DungeonEntranceStandard.entrancesOn4Sides(floor, floor.theMap, random);
        }
    }

    @Override
    public void build(World world, WorldGenMysteryDungeon dungeon, Random random, int x, int y, int z) {
        this.buildTopEntrance(world, dungeon, dungeon.floors[dungeon.numFloors - 1], random, x, y + dungeon.builder.getMaxY(), z);
    }

    protected void buildTopEntrance(World world, WorldGenMysteryDungeon dungeon, MysteryDungeonFloor floor, Random random, int x, int y, int z) {
        y -= 2;
        RoomMarker room = floor.randomRoom(random);
        int width = MathHelper.func_76125_a((int)(room.width - 4), (int)3, (int)7);
        int length = MathHelper.func_76125_a((int)(room.length - 4), (int)3, (int)7);
        Path2D ceilingLink = ShapeHelper.warbledEllipse(width, length, 0.25f, random, null);
        Path2D terrainLink = ShapeHelper.warbledEllipse((float)width * 1.3f, (float)length * 1.3f, 0.325f, random, null);
        AffineTransform roomShift = AffineTransform.getTranslateInstance(room.x + room.width / 2 + 1, room.z + room.length / 2 + 1);
        ceilingLink.transform(roomShift);
        terrainLink.transform(roomShift);
        EntryList2D ceilingL2D = (EntryList2D)new EntryList2D<Float>().modifyWithShape(ceilingLink, Float.valueOf(0.0f));
        AbstractList2D<Float> excavation = new EntryList2D<Float>().modifyWithShape(terrainLink, Float.valueOf(1.0f));
        excavation.combine(ceilingL2D, true, new Float[0]);
        floor.theMap.combine(ceilingL2D, -9, true, (Integer[])new Integer[]{-4, -5, -6, -8});
        int groundY = WorldHelper.getHighestPointInLayout(world, x, z, excavation);
        for (Link2D link2D : excavation) {
            for (int startY = (int)GeometryHelper.lineSlider(((Float)link2D.value).floatValue(), excavation.minVal(), excavation.maxVal(), y, groundY); startY <= groundY + 1; ++startY) {
                world.func_147468_f(x + link2D.x, startY, z + link2D.z);
            }
        }
    }

    public static Array2D<Integer> entrancesOn4Sides(MysteryDungeonFloor floor, Array2D<Integer> map, Random random) {
        for (ForgeDirection dir : WorldHelper.NWSE) {
            boolean hortz = WorldHelper.isHorizontal(dir);
            boolean negative = WorldHelper.isNegative(dir);
            RoomMarker room = floor.randomOuterMostRoom(random, dir);
            AbstractList2D<Integer> strip = room.getEdgePointsOnSide(dir, false);
            int u1 = hortz ? strip.minZ() : strip.minX();
            int u2 = hortz ? strip.maxZ() : strip.maxX();
            int stripLength = u2 - u1 + 1;
            int stride = Math.min(8, stripLength);
            int x0 = strip.minX() + (hortz ? 0 : RandomHelper.useRandomForNumberBetween(random, 0, stripLength - stride));
            int z0 = strip.minZ() + (hortz ? RandomHelper.useRandomForNumberBetween(random, 0, stripLength - stride) : 0);
            int hall = hortz ? (negative ? -x0 - 2 : floor.width - x0 + 2) : (negative ? -z0 - 2 : floor.length - z0 + 2);
            int width = hortz ? hall : stride;
            int length = hortz ? stride : hall;
            map.setRect(x0, z0, width, length, -1, true);
            if (hortz) {
                int cx = negative ? MysteryDungeonFloor.antiCheatRing.minX() : MysteryDungeonFloor.antiCheatRing.maxX();
                int cz = z0 + length;
                map.set(cx, z0 - 1, -3);
                map.set(cx, cz, -3);
                continue;
            }
            int cz = negative ? MysteryDungeonFloor.antiCheatRing.minZ() : MysteryDungeonFloor.antiCheatRing.maxZ();
            int cx = x0 + width;
            map.set(x0 - 1, cz, -3);
            map.set(cx, cz, -3);
        }
        return map;
    }
}

