/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.Array2D;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.AbstractFloorPart;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.MysteryDungeonFloor;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.RoomMarker;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.WallMarker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Random;
import net.minecraftforge.common.util.ForgeDirection;

public class HallMarker
extends AbstractFloorPart {
    protected int x1;
    protected int z1;
    protected int x2;
    protected int z2;
    public RoomMarker part1;
    public RoomMarker part2;
    protected ForgeDirection mainDir;
    public AbstractList2D<ForgeDirection> path = new EntryList2D<ForgeDirection>();
    protected ForgeDirection[] instructions;
    protected AbstractList2D<ForgeDirection> endPoints = new EntryList2D<ForgeDirection>();
    protected AbstractList2D<ForgeDirection> extendPoints = new EntryList2D<ForgeDirection>();

    public HallMarker(RoomMarker p1, RoomMarker p2, Random rand, ForgeDirection ... dir) {
        this.part1 = p1;
        this.x1 = p1.xBase;
        this.z1 = p1.zBase;
        this.part2 = p2;
        this.x2 = p2.xBase;
        this.z2 = p2.zBase;
        this.mainDir = dir[rand.nextInt(dir.length)];
    }

    public void hallStart(Array2D<RoomMarker> rooms, Array2D<AbstractFloorPart> floorMap, Random random, int widthBase, int lengthBase, int borderWidth) {
        ForgeDirection dir2;
        ForgeDirection dir1;
        String legalDirs = HallMarker.getLegalLinkDirsAbbrev(this.part1, rooms);
        boolean chance = random.nextInt(20) < 4;
        ForgeDirection forgeDirection = dir1 = chance ? WorldHelper.randomAdjacent(this.mainDir, random) : this.mainDir;
        if (!legalDirs.contains("" + WorldHelper.abbreviate(dir1))) {
            dir1 = this.mainDir;
        }
        if (!legalDirs.contains("" + WorldHelper.abbreviate(dir1))) {
            dir1 = WorldHelper.toDirection(legalDirs.charAt(random.nextInt(legalDirs.length())));
        }
        legalDirs = HallMarker.getLegalLinkDirsAbbrev(this.part2, rooms);
        chance = random.nextInt(20) < 4;
        ForgeDirection forgeDirection2 = dir2 = chance ? WorldHelper.randomAdjacent(this.mainDir.getOpposite(), random) : this.mainDir.getOpposite();
        if (!legalDirs.contains("" + WorldHelper.abbreviate(dir2))) {
            dir2 = this.mainDir.getOpposite();
        }
        if (!legalDirs.contains("" + WorldHelper.abbreviate(dir2))) {
            dir2 = WorldHelper.toDirection(legalDirs.charAt(random.nextInt(legalDirs.length())));
        }
        int[] point1 = this.part1.getRandomEdgePoint(random, dir1, true);
        int[] point2 = this.part2.getRandomEdgePoint(random, dir2, true);
        this.makePath(rooms, floorMap, random, point1, dir1, point2, dir2, widthBase, lengthBase, borderWidth);
    }

    public void makePath(Array2D<RoomMarker> rooms, Array2D<AbstractFloorPart> floorMap, Random random, int[] point1, ForgeDirection dir1, int[] point2, ForgeDirection dir2, int widthBase, int lengthBase, int borderWidth) {
        boolean hortz1 = WorldHelper.isHorizontal(dir1);
        boolean hortz2 = WorldHelper.isHorizontal(dir2);
        int maxStride1 = Math.min(hortz1 ? widthBase : lengthBase, this.maxStride(point1, dir1, floorMap)) + 1;
        int maxStride2 = Math.min(hortz2 ? widthBase : lengthBase, this.maxStride(point2, dir2, floorMap)) + 1;
        int stride1 = -1;
        int stride2 = -1;
        try {
            stride1 = RandomHelper.useRandomForNumberBetween(random, 2, maxStride1) & 0xFFFFFFFE;
            stride2 = RandomHelper.useRandomForNumberBetween(random, 2, maxStride2) & 0xFFFFFFFE;
        }
        catch (Exception e) {
            e.printStackTrace();
            System.err.println(MysteryDungeonFloor.describeLayout(rooms.valueSet()));
        }
        int width = stride1 * dir1.offsetX;
        int length = stride1 * dir1.offsetZ;
        int w = width + (hortz1 ? dir1.offsetX : 1);
        int l = length + (hortz1 ? 1 : dir1.offsetZ);
        this.addHall(floorMap, point1[0], point1[1], w, l);
        point1[0] = point1[0] + width;
        point1[1] = point1[1] + length;
        this.endPoints.addValue(point1[0], point1[1], dir1);
        width = stride2 * dir2.offsetX;
        length = stride2 * dir2.offsetZ;
        w = width + (hortz2 ? dir2.offsetX : 1);
        l = length + (hortz2 ? 1 : dir2.offsetX);
        this.addHall(floorMap, point2[0], point2[1], w, l);
        point2[0] = point2[0] + width;
        point2[1] = point2[1] + length;
        this.endPoints.addValue(point2[0], point2[1], dir2);
        this.finishPath(rooms, floorMap, random, point1, point2, widthBase, lengthBase);
    }

    private void finishPath(Array2D<RoomMarker> rooms, Array2D<AbstractFloorPart> floorMap, Random random, int[] point1, int[] point2, int widthBase, int lengthBase) {
        int distX = point2[0] - point1[0];
        int distZ = point2[1] - point1[1];
        ArrayList<ForgeDirection> towards = WorldHelper.getDirectionsTowards(distX, distZ);
        distX = Math.abs(distX);
        distZ = Math.abs(distZ);
        while (!towards.isEmpty()) {
            ForgeDirection dir = towards.remove(random.nextInt(towards.size()));
            boolean hortz = WorldHelper.isHorizontal(dir);
            this.extendPoints.addValue(point1[0], point1[1], dir);
            int width = distX == 0 ? 0 : random.nextInt(distX) & 0xFFFFFFFE;
            int length = distZ == 0 ? 0 : random.nextInt(distZ) & 0xFFFFFFFE;
            int w = width * dir.offsetX + (hortz ? dir.offsetX : 1);
            int l = length * dir.offsetZ + (hortz ? 1 : dir.offsetZ);
            this.addHall(floorMap, point1[0], point1[1], w, l);
            point1[0] = point1[0] + width * dir.offsetX;
            point1[1] = point1[1] + length * dir.offsetZ;
            this.extendPoints.addValue(point1[0], point1[1], dir.getOpposite());
            dir = dir.getOpposite();
            this.extendPoints.addValue(point2[0], point2[1], dir);
            width = distX - width;
            length = distZ - length;
            w = width * dir.offsetX + (hortz ? dir.offsetX : 1);
            l = length * dir.offsetZ + (hortz ? 1 : dir.offsetZ);
            this.addHall(floorMap, point2[0], point2[1], w, l);
            point2[0] = point2[0] + width * dir.offsetX;
            point2[1] = point2[1] + length * dir.offsetZ;
            this.extendPoints.addValue(point2[0], point2[1], dir.getOpposite());
        }
    }

    private void addHall(Array2D<AbstractFloorPart> floorMap, int x, int z, int width, int length) {
        int dx = Integer.signum(width);
        int dz = Integer.signum(length);
        for (int i = 0; i != width; i += dx) {
            for (int j = 0; j != length; j += dz) {
                AbstractFloorPart part = floorMap.get(x + i, z + j);
                if (part != null) {
                    this.joinWith(part);
                }
                if (part instanceof RoomMarker) continue;
                floorMap.set(x + i, z + j, this);
            }
        }
    }

    private void checkFlip(int i, int j, ForgeDirection newDir, Array2D<AbstractFloorPart> floorMap, Random random) {
        ForgeDirection pathDir = this.endPoints.get(i, j);
        if (pathDir != null && pathDir.getOpposite() == newDir) {
            Object[] typeAndStride = this.maxStrideUntilCollision(i, j, pathDir, floorMap);
            int stride = (Integer)typeAndStride[1];
            stride = typeAndStride[0] == null ? (RandomHelper.useRandomForNumberBetween(random, stride / 5, stride / 2) & 0xFFFFFFFE) + 1 : stride;
            boolean hortz = WorldHelper.isHorizontal(pathDir);
            int width = hortz ? stride * pathDir.offsetX : 1;
            int length = hortz ? 1 : stride * pathDir.offsetZ;
            this.addHall(floorMap, i, j, width, length);
        }
    }

    public void touchup(Array2D<AbstractFloorPart> floorMap, Random random) {
        for (int i : this.endPoints.xList()) {
            for (int j : this.endPoints.zList(i)) {
                ForgeDirection extendDir = this.extendPoints.get(i, j);
                if (extendDir == null) continue;
                this.checkFlip(i, j, extendDir, floorMap, random);
            }
        }
    }

    private void closeEnough(AbstractList2D<AbstractFloorPart> floorMap, int i, int j, ForgeDirection dir) {
        AbstractFloorPart value = floorMap.get(i + dir.offsetX * 2, j + dir.offsetZ * 2);
        if (value != null && value instanceof RoomMarker) {
            int n = 0;
            for (ForgeDirection dir0 : WorldHelper.NWSE) {
                if (floorMap.get(i + dir0.offsetX, j + dir0.offsetZ) instanceof WallMarker || ++n <= 1) continue;
                return;
            }
            floorMap.addValue(i + dir.offsetX, j + dir.offsetZ, this);
        }
    }

    private boolean coordsAreEvensOnly(int[] coords) {
        return (coords[0] & 1) == 0 && (coords[1] & 1) == 0;
    }

    public int maxStride(int[] point, ForgeDirection dir, Array2D<AbstractFloorPart> floorMap) {
        int i = 0;
        AbstractFloorPart value = null;
        while ((value = floorMap.get(point[0] + dir.offsetX * (i + 1), point[1] + dir.offsetZ * (i + 1))) != null && !(value instanceof RoomMarker)) {
            ++i;
        }
        return i;
    }

    public Object[] maxStrideUntilCollision(int i, int j, ForgeDirection dir, Array2D<AbstractFloorPart> floorMap) {
        int n = 0;
        AbstractFloorPart part = null;
        while (true) {
            int x;
            if ((x = i + (n + 1) * dir.offsetX) < 2 || x > floorMap.width() - 3) {
                part = null;
                break;
            }
            int z = j + (n + 1) * dir.offsetZ;
            if (z < 2 || z > floorMap.length() - 3) {
                part = null;
                break;
            }
            part = floorMap.get(x, z);
            if (part == null || !(part instanceof WallMarker)) break;
            ++n;
        }
        return new Object[]{part, n + 1};
    }

    @Override
    public ForgeDirection getRandomEdgePoint(Random random, int[] store, boolean evensOnly) {
        int[] temp = this.path.randomPoint(random);
        store[0] = temp[0];
        store[1] = temp[1];
        return this.path.get(store[0], store[1]);
    }

    @Override
    public AbstractList2D<ForgeDirection> getAllEdgePoints(boolean evensOnly) {
        return this.path;
    }

    public static AbstractList2D<Integer> testingMap(Collection<HallMarker> halls) {
        EntryList2D<Integer> result = new EntryList2D<Integer>();
        int b = 0;
        for (HallMarker hall : halls) {
            int width;
            int x0 = hall.part1.x + (WorldHelper.isHorizontal(hall.mainDir) ? (WorldHelper.isNegative(hall.mainDir) ? 0 : hall.part1.width) : hall.part1.width / 2);
            int z0 = hall.part1.z + (!WorldHelper.isHorizontal(hall.mainDir) ? (WorldHelper.isNegative(hall.mainDir) ? 0 : hall.part1.length) : hall.part1.length / 2);
            int n = !WorldHelper.isHorizontal(hall.mainDir) ? 1 : (width = hall.part2.x + (WorldHelper.isNegative(hall.mainDir) ? hall.part2.width : 0) - x0);
            int length = WorldHelper.isHorizontal(hall.mainDir) ? 1 : hall.part2.z + (WorldHelper.isNegative(hall.mainDir) ? hall.part2.length : 0) - z0;
            result.addRect(x0, z0, width, length, b++, true);
        }
        return result;
    }

    public static String getLegalLinkDirsAbbrev(RoomMarker room, Array2D<RoomMarker> rooms) {
        String result = "NWSE";
        if (room.xBase == 0) {
            result = result.replace("W", "");
        }
        if (room.zBase == 0) {
            result = result.replace("N", "");
        }
        if (room.xBase + room.xUnits >= rooms.length()) {
            result = result.replace("E", "");
        }
        if (room.zBase + room.zUnits >= rooms.width()) {
            result = result.replace("S", "");
        }
        return result;
    }

    public static ForgeDirection[] getLegalLinkDirs(RoomMarker room, Array2D<RoomMarker> rooms) {
        ArrayList<ForgeDirection> legalDirs = new ArrayList<ForgeDirection>(Arrays.asList(WorldHelper.NWSE));
        if (room.xBase == 0) {
            legalDirs.remove(ForgeDirection.WEST);
        }
        if (room.zBase == 0) {
            legalDirs.remove(ForgeDirection.NORTH);
        }
        if (room.xBase + room.xUnits >= rooms.width()) {
            legalDirs.remove(ForgeDirection.EAST);
        }
        if (room.zBase + room.zUnits >= rooms.length()) {
            legalDirs.remove(ForgeDirection.SOUTH);
        }
        return legalDirs.toArray(new ForgeDirection[legalDirs.size()]);
    }

    @Override
    public void joinWith(AbstractFloorPart other) {
        this.part1.joinWith(other);
    }
}

