/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon;

import com.pixelmonmod.pixelmon.RandomHelper;
import com.pixelmonmod.pixelmon.WorldHelper;
import com.pixelmonmod.pixelmon.util.AbstractList2D;
import com.pixelmonmod.pixelmon.util.Array2D;
import com.pixelmonmod.pixelmon.util.EntryList2D;
import com.pixelmonmod.pixelmon.util.Link2D;
import com.pixelmonmod.pixelmon.util.helpers.CommonHelper;
import com.pixelmonmod.pixelmon.util.helpers.GeometryHelper;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.AbstractFloorPart;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.HallMarker;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.RoomMarker;
import com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon.WallMarker;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.minecraftforge.common.util.ForgeDirection;

public class MysteryDungeonFloor {
    public static final String STRING_0 = "[0,0,1,1, 0,1,1,1, 1,0,2,2, 3,0,1,1, 3,1,1,1]";
    public static final byte B0 = 0;
    public static final byte B1 = 1;
    public static final byte B2 = 2;
    public static final byte B3 = 3;
    public static final byte B4 = 4;
    public static final byte B5 = 5;
    public static final byte B6 = 6;
    public static final Number[] VALID_2 = new Number[]{null, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, (byte)0, (byte)0, (byte)0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, null, null};
    public static final Number[] VALID_3 = new Number[]{null, null, null, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, (byte)0, (byte)0, (byte)0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, (byte)1, (byte)1, (byte)1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, null, null, null, null};
    public static final Number[] VALID_4 = new Number[]{null, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, (byte)0, (byte)0, (byte)0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, (byte)1, (byte)1, (byte)1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, (byte)2, (byte)2, (byte)2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, null, null};
    public static final Number[] VALID_COMMON = new Integer[]{null, null, null, null, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, null, null, null, 1, 1, 1, null, null, null, 2, 2, 2, 2, 2, 2, 2, null, null, null, 3, 3, 3, 3, 3, 3, 3, null, null, null, 4, 4, 4, null, null, null, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, null, null, null, null};
    public static final Number[] MAXWIDTHS = new Number[]{null, null, 29, 17, 13};
    public static final Number[][] VALID_LOOKUP = new Number[][]{null, null, VALID_2, VALID_3, VALID_4};
    public static final int[][] BOUNDS_LOOKUP = new int[][]{null, null, {2, 62}, {4, 60}, {2, 62}};
    public static final int[] BOUNDS_COMMON = new int[]{2, 62};
    public static final int ID_ROOM = -1;
    public static final int ID_HALL = -2;
    public static final int ID_WALL = -3;
    public static final int ID_LADDERSHAFT_UP = -4;
    public static final int ID_LADDERSHAFT_DOWN = -5;
    public static final int ID_LADDERSIDE = -6;
    public static final int ID_ANTICHEAT = -7;
    public static final int ID_TREASURE = -8;
    public static final int ID_PASSAGEWAY = -9;
    private static final int[] OFFSETS = new int[]{-1, 1};
    public static final EntryList2D<Integer> antiCheatRing = (EntryList2D)new RoomMarker(0, 0, 66, 66, 0, false).getAllEdgePoints(false).replace(-7);
    public static final EntryList2D<Integer> outerLayer = (EntryList2D)new RoomMarker(-1, -1, 68, 68, 0, false).getAllEdgePoints(false).replace(-3);
    protected Array2D<RoomMarker> layout;
    public Array2D<Integer> theMap;
    protected AbstractList2D<Object> choosables = new EntryList2D<Object>();
    public final int width;
    public final int length;
    public final int borderWidth;
    protected int columns;
    protected int rows;
    protected final boolean ladderShaftOverwrite;
    protected final int[] ensureStairs;
    protected final int[] myStairs = new int[3];
    protected Integer numRooms;

    public MysteryDungeonFloor(int width, int length, int borderWidth, Random random, boolean ladderShaftOverwrite) {
        this.width = width;
        this.length = length;
        this.borderWidth = borderWidth;
        this.columns = RandomHelper.useRandomForNumberBetween(random, 2, 4);
        this.rows = RandomHelper.useRandomForNumberBetween(random, 2, 4);
        this.layout = new Array2D<RoomMarker>(RoomMarker.class, this.columns, this.rows, RoomMarker.BLANK);
        this.ensureStairs = null;
        this.ladderShaftOverwrite = ladderShaftOverwrite;
    }

    public MysteryDungeonFloor(int width, int length, int borderWidth, int[] ensureStairs, Random random, boolean ladderShaftOverwrite) {
        this.width = width;
        this.length = length;
        this.borderWidth = borderWidth;
        this.ensureStairs = ensureStairs;
        this.ladderShaftOverwrite = ladderShaftOverwrite;
        this.ensureColRow(random);
        this.initStairsRoom(random);
    }

    protected void ensureColRow(Random random) {
        int stairsX = this.ensureStairs[0];
        int stairsZ = this.ensureStairs[1];
        ArrayList<Integer> validColumns = new ArrayList<Integer>();
        ArrayList<Integer> validRows = new ArrayList<Integer>();
        for (int i = 2; i <= 4; ++i) {
            if (this.isInBounds(stairsX, i)) {
                validColumns.add(i);
            }
            if (!this.isInBounds(stairsZ, i)) continue;
            validRows.add(i);
        }
        this.columns = (Integer)validColumns.get(random.nextInt(validColumns.size()));
        this.rows = (Integer)validRows.get(random.nextInt(validRows.size()));
        this.layout = new Array2D<RoomMarker>(RoomMarker.class, this.columns, this.rows, RoomMarker.BLANK);
    }

    protected int[] ensureStairs0(int storyHeight, Random random) {
        int stairsX = 0;
        int stairsZ = 0;
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>(Arrays.asList(WorldHelper.NWSE));
        while (!dirs.isEmpty()) {
            ForgeDirection dir = dirs.remove(random.nextInt(dirs.size()));
            stairsX = this.ensureStairs[0] + dir.offsetX * (storyHeight - 1);
            stairsZ = this.ensureStairs[1] + dir.offsetZ * (storyHeight - 1);
            if (!this.isInCommonBounds(stairsX, stairsZ)) continue;
            ArrayList<Integer> validColumns = new ArrayList<Integer>();
            ArrayList<Integer> validRows = new ArrayList<Integer>();
            for (int i = 2; i <= 4; ++i) {
                if (this.isInBounds(stairsX, i)) {
                    validColumns.add(i);
                }
                if (!this.isInBounds(stairsZ, i)) continue;
                validRows.add(i);
            }
            this.columns = (Integer)validColumns.get(random.nextInt(validColumns.size()));
            this.rows = (Integer)validRows.get(random.nextInt(validRows.size()));
            return new int[]{stairsX, stairsZ};
        }
        System.out.println("UH OH, " + Arrays.toString(this.ensureStairs));
        return null;
    }

    protected boolean isInBounds(int i, int lookup) {
        return i >= BOUNDS_LOOKUP[lookup][0] && i <= BOUNDS_LOOKUP[lookup][1];
    }

    protected boolean isInBounds(int i, int j, int lookup) {
        return this.isInBounds(i, j, BOUNDS_LOOKUP[lookup]);
    }

    protected boolean isInCommonBounds(int i, int j) {
        return this.isInBounds(i, j, BOUNDS_COMMON);
    }

    private boolean isInBounds(int i, int j, int[] bounds) {
        return i >= bounds[0] && i <= bounds[1] && j >= bounds[0] && j <= bounds[1];
    }

    protected void initStairsRoom(Random random) {
        int roomL;
        int roomW;
        int xBase = VALID_LOOKUP[this.columns][this.ensureStairs[0]].intValue();
        int zBase = VALID_LOOKUP[this.rows][this.ensureStairs[1]].intValue();
        int xUnits = this.isStandardPoint(this.ensureStairs[0], VALID_LOOKUP[this.columns]) ? 1 : 2;
        int zUnits = this.isStandardPoint(this.ensureStairs[1], VALID_LOOKUP[this.rows]) ? 1 : 2;
        int wBase = this.width / (this.columns * 2);
        int lBase = this.length / (this.rows * 2);
        int midPushX = (this.width - (this.columns * 2 - 1) * wBase) / 2;
        int midPushZ = (this.length - (this.rows * 2 - 1) * lBase) / 2;
        int xMul = wBase * 2;
        int zMul = lBase * 2;
        int minX = xBase == 0 && wBase / 2 > midPushX ? -midPushX + 1 : -wBase / 2 + 1;
        int maxX = xBase == this.columns - 1 && wBase / 2 > midPushX ? midPushX - 1 : wBase / 2 - 1;
        int minZ = zBase == 0 && lBase / 2 > midPushZ ? -midPushZ + 1 : -lBase / 2 + 1;
        int maxZ = zBase == this.rows - 1 && lBase / 2 > midPushZ ? midPushZ - 1 : lBase / 2 - 1;
        int xOffset = RandomHelper.useRandomForNumberBetween(random, minX, maxX);
        int zOffset = RandomHelper.useRandomForNumberBetween(random, minZ, maxZ);
        int maxW = maxX - xOffset;
        int maxL = maxZ - zOffset;
        int widthOffset = RandomHelper.useRandomForNumberBetween(random, 0, maxW);
        int lengthOffset = RandomHelper.useRandomForNumberBetween(random, 0, maxL);
        int x0 = 1 + xMul * xBase + midPushX + xOffset & 0xFFFFFFFE;
        int z0 = 1 + zMul * zBase + midPushZ + zOffset & 0xFFFFFFFE;
        if (x0 <= 0) {
            x0 = 2;
        }
        if (x0 > this.ensureStairs[0]) {
            x0 = this.ensureStairs[0] & 0xFFFFFFFE;
        }
        if (z0 <= 0) {
            z0 = 2;
        }
        if (z0 > this.ensureStairs[1]) {
            z0 = this.ensureStairs[1] & 0xFFFFFFFE;
        }
        if (x0 + (roomW = -1 + (wBase * (xUnits + xUnits / 2) + widthOffset & 0xFFFFFFFE)) < this.ensureStairs[0]) {
            roomW = 1 + (this.ensureStairs[0] - x0 & 0xFFFFFFFE);
        }
        if (z0 + (roomL = -1 + (lBase * (zUnits + zUnits / 2) + lengthOffset & 0xFFFFFFFE)) < this.ensureStairs[1]) {
            roomL = 1 + (this.ensureStairs[1] - z0 & 0xFFFFFFFE);
        }
        RoomMarker stairsRoom = new RoomMarker(xBase, zBase, xUnits, zUnits, 0, false).refactor(x0, z0, roomW, roomL);
        this.layout.setRect(xBase, zBase, xUnits, zUnits, stairsRoom, true);
    }

    public static boolean isRoomContents(int id) {
        switch (id) {
            case -9: 
            case -8: 
            case -6: 
            case -5: 
            case -4: 
            case -1: {
                return true;
            }
        }
        return false;
    }

    protected boolean isStandardPoint(int i, Number[] strip) {
        return strip[i] instanceof Integer;
    }

    public Array2D<Integer> floorMain(Random random, int maxRoomSizeMultiplier) {
        Array2D<AbstractFloorPart> semifinal = new Array2D<WallMarker>(AbstractFloorPart.class, this.width + 2 * this.borderWidth + 1, this.length + 2 * this.borderWidth + 1, WallMarker.MARK).setZero(-1, -1);
        this.startRooms(random, this.columns, this.rows, maxRoomSizeMultiplier);
        this.layout.removeAll(RoomMarker.BLANK);
        int wBase = this.width / (this.columns * 2);
        int lBase = this.length / (this.rows * 2);
        this.applyRooms(semifinal, this.columns, this.rows, wBase, lBase, random);
        this.initChoosables();
        int[] tempLadder = this.randomPoint(random, true);
        System.arraycopy(tempLadder, 0, this.myStairs, 0, 2);
        Collection<HallMarker> halls = this.linkAllRooms(random);
        for (HallMarker hall : halls) {
            hall.hallStart(this.layout, semifinal, random, wBase, lBase, this.borderWidth);
        }
        for (HallMarker hall : halls) {
            hall.touchup(semifinal, random);
        }
        Array2D<Integer> floorMap = MysteryDungeonFloor.convertMap(semifinal);
        this.applyLadder(floorMap, random);
        this.theMap = floorMap.combine(antiCheatRing, true, (Integer[])new Integer[0]).combine(outerLayer, true, (Integer[])new Integer[0]);
        return this.theMap;
    }

    protected static Array2D<Integer> convertMap(Array2D<AbstractFloorPart> floorMap) {
        Array2D<Integer> result = new Array2D<Integer>(Integer.TYPE, floorMap.width(), floorMap.length()).setZero(-1, -1);
        for (Link2D link2D : floorMap) {
            int id = link2D.value instanceof RoomMarker ? -1 : (link2D.value instanceof HallMarker ? -2 : -3);
            result.set(link2D.x, link2D.z, id);
        }
        return result;
    }

    public void startRooms(Random random, int columns, int rows, int maxSize) {
        this.initRooms(random, columns, rows);
        this.enlargeRooms(random, maxSize, columns - 1, rows - 1);
    }

    public void initRooms(Random random, int columns, int rows) {
        ArrayList<Integer> tickets = new ArrayList<Integer>(columns * rows);
        for (int i = 0; i < columns * rows; ++i) {
            tickets.add(i, i);
        }
        int roomCounter = RandomHelper.useRandomForNumberBetween(random, columns * rows / 2, columns * rows);
        if (this.ensureStairs != null) {
            --roomCounter;
        }
        int roomID = 0;
        while (roomCounter > 0) {
            int i = (Integer)tickets.remove(random.nextInt(tickets.size()));
            int xi = i / rows;
            int zi = i % rows;
            if (this.layout.get((int)xi, (int)zi).canModify) {
                this.layout.set(xi, zi, new RoomMarker(xi, zi, 1, 1, roomID++, true));
            }
            --roomCounter;
        }
    }

    public void enlargeRooms(Random random, int maxSize, int maxX, int maxZ) {
        for (Link2D link2D : this.layout) {
            RoomMarker room = (RoomMarker)link2D.value;
            if (room == RoomMarker.BLANK || room.used) continue;
            this.attemptExpansion(this.layout, link2D.x, link2D.z, random, room, maxSize, maxX, maxZ);
        }
    }

    private void attemptExpansion(Array2D<RoomMarker> rooms, int i, int j, Random random, RoomMarker room, int maxSize, int maxX, int maxZ) {
        for (ForgeDirection dir : WorldHelper.NWSE) {
            if (random.nextInt(11) != 0 || !room.canExpand(rooms, i, j, dir, maxSize, maxX, maxZ)) continue;
            room.expand(rooms, i, j, dir);
        }
    }

    private void applyRooms(Array2D<AbstractFloorPart> floorMap, int columns, int rows, int wBase, int lBase, Random random) {
        int midPushX = (this.width - (columns * 2 - 1) * wBase) / 2;
        int midPushZ = (this.length - (rows * 2 - 1) * lBase) / 2;
        int xMul = wBase * 2;
        int zMul = lBase * 2;
        HashSet<RoomMarker> roomMarkers = this.layout.valueSet();
        this.numRooms = roomMarkers.size();
        for (RoomMarker marker : roomMarkers) {
            if (marker == null) continue;
            if (marker.canModify) {
                int minX = marker.xBase == 0 && wBase / 2 > midPushX ? -midPushX + 1 : -wBase / 2 + 1;
                int maxX = marker.xBase == columns - 1 && wBase / 2 > midPushX ? midPushX - 1 : wBase / 2 - 1;
                int minZ = marker.zBase == 0 && lBase / 2 > midPushZ ? -midPushZ + 1 : -lBase / 2 + 1;
                int maxZ = marker.zBase == rows - 1 && lBase / 2 > midPushZ ? midPushZ - 1 : lBase / 2 - 1;
                int xOffset = RandomHelper.useRandomForNumberBetween(random, minX, maxX);
                int zOffset = RandomHelper.useRandomForNumberBetween(random, minZ, maxZ);
                int maxW = maxX - xOffset;
                int maxL = maxZ - zOffset;
                int widthOffset = RandomHelper.useRandomForNumberBetween(random, 0, maxW);
                int lengthOffset = RandomHelper.useRandomForNumberBetween(random, 0, maxL);
                int x0 = 1 + xMul * marker.xBase + midPushX + xOffset & 0xFFFFFFFE;
                int z0 = 1 + zMul * marker.zBase + midPushZ + zOffset & 0xFFFFFFFE;
                if (x0 <= 0) {
                    x0 = 2;
                }
                if (z0 <= 0) {
                    z0 = 2;
                }
                int roomW = -1 + (wBase * (marker.xUnits + marker.xUnits / 2) + widthOffset & 0xFFFFFFFE);
                int roomL = -1 + (lBase * (marker.zUnits + marker.zUnits / 2) + lengthOffset & 0xFFFFFFFE);
                marker.refactor(x0, z0, roomW, roomL);
            }
            floorMap.setRect(marker.x, marker.z, marker.width, marker.length, marker, true);
        }
    }

    private void applyLadder(Array2D<Integer> floorMap, Random random) {
        floorMap.set(this.myStairs[0], this.myStairs[1], -4);
        int[] shaftSide = this.chooseValidShaftSide(this.myStairs, floorMap, random);
        if (this.ladderShaftOverwrite || floorMap.get(shaftSide[0], shaftSide[1]) != -3) {
            floorMap.set(shaftSide[0], shaftSide[1], -6);
        }
        if (this.ensureStairs != null) {
            floorMap.set(this.ensureStairs[0], this.ensureStairs[1], -5);
        }
    }

    private int[] chooseValidShaftSide(int[] point, Array2D<Integer> floorMap, Random random) {
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>();
        for (ForgeDirection dir : WorldHelper.NWSE) {
            Integer candidate = floorMap.get(point[0] + dir.offsetX, point[1] + dir.offsetZ);
            if (candidate != -3 && candidate != -1 && candidate != -6) continue;
            dirs.add(dir);
        }
        ForgeDirection side = (ForgeDirection)dirs.get(random.nextInt(dirs.size()));
        point[2] = side.getOpposite().ordinal();
        return new int[]{point[0] + side.offsetX, point[1] + side.offsetZ};
    }

    public static String encodeValidStrip(int length, int colrow) {
        Map<Integer, Boolean> strip = MysteryDungeonFloor.getValid1x1RoomStrip(length, colrow);
        Object[] temp = new Integer[length];
        int n = -1;
        Boolean last = null;
        for (int i = 0; i < length; ++i) {
            Boolean value = strip.get(i);
            if (last == null && value != null) {
                ++n;
            }
            temp[i] = value == null ? null : Integer.valueOf(n);
            last = value;
        }
        return Arrays.toString(temp).replace('[', '{').replace(']', '}');
    }

    public static String encodeCommon(int length, int ... ints) {
        Map[] maps = new Map[ints.length];
        for (int i = 0; i < ints.length; ++i) {
            maps[i] = MysteryDungeonFloor.getValid1x1RoomStrip(length, ints[i]);
        }
        TreeMap<Integer, Boolean> common = new TreeMap<Integer, Boolean>();
        for (int i = 0; i < length; ++i) {
            for (int j = 0; j < ints.length && maps[j].containsKey(i); ++j) {
                if (j != ints.length - 1) continue;
                common.put(i, true);
            }
        }
        Object[] temp = new Integer[length];
        int n = -1;
        Object last = null;
        for (int i = 0; i < length; ++i) {
            Object value = common.get(i);
            if (last == null && value != null) {
                ++n;
            }
            temp[i] = value == null ? null : Integer.valueOf(n);
            last = value;
        }
        return Arrays.toString(temp).replace('[', '{').replace(']', '}');
    }

    public static Map<Integer, Boolean> getValid1x1RoomStrip(int length, int colrow) {
        TreeMap<Integer, Boolean> result = new TreeMap<Integer, Boolean>();
        int base = length / (colrow * 2);
        int mul = base * 2;
        int midPush = (length - (colrow * 2 - 1) * base) / 2;
        for (int i = 0; i < colrow; ++i) {
            int min = i == 0 && base / 2 > midPush ? -midPush + 1 : -base / 2 + 1;
            int max = i == colrow - 1 && base / 2 > midPush ? midPush - 1 : base / 2 - 1;
            int length0 = max - min;
            int x0 = 1 + (mul * i + midPush) + min & 0xFFFFFFFE;
            int l0 = -1 + (base + length0 & 0xFFFFFFFE);
            for (int j = 0; j < l0; ++j) {
                result.put(x0 + j, true);
            }
        }
        return result;
    }

    public static AbstractList2D<Integer> getValid1x1RoomAreas(int width, int length, int columns, int rows) {
        EntryList2D<Integer> result = new EntryList2D<Integer>();
        int wBase = width / (columns * 2);
        int lBase = length / (rows * 2);
        int xMul = wBase * 2;
        int zMul = lBase * 2;
        int midPushX = (width - (columns * 2 - 1) * wBase) / 2;
        int midPushZ = (length - (rows * 2 - 1) * lBase) / 2;
        for (int i = 0; i < columns; ++i) {
            for (int j = 0; j < rows; ++j) {
                int minX = i == 0 && wBase / 2 > midPushX ? -midPushX + 1 : -wBase / 2 + 1;
                int maxX = i == columns - 1 && wBase / 2 > midPushX ? midPushX - 1 : wBase / 2 - 1;
                int minZ = j == 0 && lBase / 2 > midPushZ ? -midPushZ + 1 : -lBase / 2 + 1;
                int maxZ = j == rows - 1 && lBase / 2 > midPushZ ? midPushZ - 1 : lBase / 2 - 1;
                int width0 = maxX - minX;
                int length0 = maxZ - minZ;
                int x0 = 1 + (xMul * i + midPushX) + minX & 0xFFFFFFFE;
                int z0 = 1 + (zMul * j + midPushZ) + minZ & 0xFFFFFFFE;
                int w0 = -1 + (wBase + width0 & 0xFFFFFFFE);
                int l0 = -1 + (lBase + length0 & 0xFFFFFFFE);
                result.addRect(x0, z0, w0, l0, 1, true);
            }
        }
        return result;
    }

    private static void link2Rooms(RoomMarker room1, RoomMarker room2, Collection<HallMarker> halls, Random random, ForgeDirection ... hallDirs) {
        room2.joinWith(room1);
        halls.add(new HallMarker(room1, room2, random, hallDirs));
    }

    public Collection<HallMarker> linkAllRooms(Random random) {
        ArrayList<HallMarker> halls = new ArrayList<HallMarker>();
        HashSet<RoomMarker> roomsList = this.layout.valueSet();
        for (RoomMarker rm : roomsList) {
            if (rm == null) continue;
            rm.reset();
        }
        for (RoomMarker room : roomsList) {
            ForgeDirection[] legalDirs;
            if (room == null) continue;
            for (ForgeDirection dir : legalDirs = HallMarker.getLegalLinkDirs(room, this.layout)) {
                RoomMarker linkee = MysteryDungeonFloor.getFirstRoomInDirection(room, this.layout, dir);
                if (linkee == null || linkee.used || random.nextInt(20) >= 17) continue;
                MysteryDungeonFloor.link2Rooms(room, linkee, halls, random, dir);
            }
            room.used = true;
        }
        this.ensureConnections(roomsList, halls, random);
        return halls;
    }

    private void ensureConnections(Collection<RoomMarker> roomsList, Collection<HallMarker> halls, Random random) {
        Object groupObject = null;
        for (RoomMarker room : roomsList) {
            if (room == null) continue;
            if (groupObject == null) {
                groupObject = room.sharedObj;
                continue;
            }
            if (room.sharedObj == groupObject || MysteryDungeonFloor.planB(room, roomsList, halls, random)) continue;
            this.planC(room, halls, random);
        }
    }

    protected static boolean planB(RoomMarker room, Collection<RoomMarker> roomsList, Collection<HallMarker> halls, Random random) {
        RoomMarker linkee = null;
        float distance = 0.0f;
        for (RoomMarker marker : roomsList) {
            float tempDist;
            if (linkee == null) {
                if (marker == room || !room.canLinkTo(marker)) continue;
                linkee = marker;
                distance = (float)GeometryHelper.dist(room.xBase, room.zBase, marker.xBase, marker.zBase);
                continue;
            }
            if (marker == room || !room.canLinkTo(marker) || room.isAlignedWith(marker) || !((tempDist = (float)GeometryHelper.dist(room.xBase, room.zBase, marker.xBase, marker.zBase)) < distance)) continue;
            linkee = marker;
            distance = tempDist;
        }
        if (linkee == null) {
            return false;
        }
        int xDist = linkee.xBase - room.xBase;
        int zDist = linkee.zBase - room.zBase;
        ForgeDirection[] dirs = WorldHelper.dirsFromOffsets(xDist, zDist);
        MysteryDungeonFloor.link2Rooms(room, linkee, halls, random, dirs);
        return true;
    }

    protected boolean planC(RoomMarker room, Collection<HallMarker> halls, Random random) {
        RoomMarker linkee = null;
        int dist = -1;
        ForgeDirection hallDir = null;
        for (ForgeDirection dir : WorldHelper.NWSE) {
            RoomMarker marker = MysteryDungeonFloor.getFirstRoomInDirection(room, this.layout, dir);
            if (marker == null || !room.canLinkTo(marker)) continue;
            if (linkee == null) {
                dist = room.getAlignedDistance(marker);
                linkee = marker;
                hallDir = dir;
                continue;
            }
            int tempDist = room.getAlignedDistance(marker);
            if (tempDist >= dist && (tempDist != dist || random.nextInt(4) != 0)) continue;
            dist = tempDist;
            linkee = marker;
            hallDir = dir;
        }
        if (linkee == null) {
            return false;
        }
        MysteryDungeonFloor.link2Rooms(room, linkee, halls, random, hallDir);
        return true;
    }

    private static RoomMarker getFirstRoomInDirection(RoomMarker room, Array2D<RoomMarker> rooms, ForgeDirection dir) {
        int i = 1;
        int z0;
        int x0;
        while (rooms.isInBounds(x0 = room.xBase + i * dir.offsetX, z0 = room.zBase + i * dir.offsetZ)) {
            RoomMarker other = rooms.get(x0, z0);
            if (other != null && other != room) {
                return other;
            }
            ++i;
        }
        return null;
    }

    public int roomCount() {
        if (this.numRooms == null) {
            HashSet<RoomMarker> roomSet = this.layout.valueSet();
            this.numRooms = roomSet.size();
        }
        return this.numRooms;
    }

    public int[] myStairsPoint() {
        return this.myStairs;
    }

    public int[] ensureStairsPoint() {
        return this.ensureStairs;
    }

    public TreeSet<String> describeLayout() {
        return MysteryDungeonFloor.describeLayout(this.layout.valueSet());
    }

    public Set<RoomMarker> getRooms() {
        return this.layout.valueSet();
    }

    public static TreeSet<String> describeLayout(Set<RoomMarker> roomSet) {
        TreeSet<String> result = new TreeSet<String>();
        for (RoomMarker room : roomSet) {
            if (room == null) continue;
            String description = String.format("%s,%s,%s,%s", room.xBase, room.zBase, room.xUnits, room.zUnits);
            result.add(description);
        }
        return result;
    }

    public RoomMarker randomOuterMostRoom(Random random, ForgeDirection side) {
        ArrayList roomList = new ArrayList();
        HashSet<RoomMarker> set = this.layout.firstNonEmptyStrip(side);
        ArrayList<RoomMarker> list = new ArrayList<RoomMarker>(set);
        try {
            return list.get(random.nextInt(list.size()));
        }
        catch (IllegalArgumentException e) {
            System.err.println(this.layout.toString());
            throw e;
        }
    }

    public RoomMarker randomRoom(Random random) {
        ArrayList<RoomMarker> roomList = new ArrayList<RoomMarker>(this.layout.valueSet());
        return roomList.get(random.nextInt(roomList.size()));
    }

    protected void initChoosables() {
        HashSet<RoomMarker> roomSet = this.layout.valueSet();
        boolean flag = this.func_asdf();
        for (RoomMarker room : roomSet) {
            if (room == null || flag && room.xUnits == 2) continue;
            for (int i = 2; i <= room.width - 2; i += 2) {
                for (int j = 2; j <= room.length - 2; j += 2) {
                    this.choosables.addValue(i + room.x, j + room.z, CommonHelper.THING);
                }
            }
        }
        if (this.ensureStairs != null) {
            this.choosables.remove(this.ensureStairs[0], this.ensureStairs[1]);
        }
    }

    public int[] randomPoint(Random random, boolean remove) {
        int[] point = this.choosables.randomPoint(random);
        if (remove) {
            this.choosables.remove(point[0], point[1]);
        }
        return point;
    }

    public AbstractList2D getChoosablePoints() {
        return this.choosables;
    }

    public int[] randomRoomEdgePoint(Random random, boolean evensOnly) {
        ArrayList<RoomMarker> roomList = new ArrayList<RoomMarker>(this.layout.valueSet());
        RoomMarker room = roomList.get(random.nextInt(roomList.size()));
        int[] result = new int[2];
        room.getRandomEdgePoint(random, result, true);
        return result;
    }

    public boolean matchesLayout(Set<RoomMarker> compare) {
        String describeThis = MysteryDungeonFloor.describeLayout(this.layout.valueSet()).toString();
        String describeThat = MysteryDungeonFloor.describeLayout(compare).toString();
        return describeThis.equals(describeThat);
    }

    public static boolean isDangerBlock(int x, int z) {
        return !outerLayer.contains(x, z);
    }

    public static boolean func_jkl(Set<RoomMarker> asdf) {
        return MysteryDungeonFloor.describeLayout(asdf).toString().equals(STRING_0);
    }

    public boolean func_asdf() {
        return this.describeLayout().toString().equals(STRING_0);
    }
}

