/*
 * Decompiled with CFR 0.152.
 */
package com.pixelmonmod.pixelmon.worldGeneration.mysteryDungeon;

import com.pixelmonmod.pixelmon.util.PixelmonDebug;
import com.pixelmonmod.pixelmon.util.helpers.BlockHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;

public class MysteryDungeonValues {
    public final Block wallID;
    public final Block floorID;
    public final Block ceilingID;
    public final Block shaftID;
    public final int wallMeta;
    public final int floorMeta;
    public final int ceilingMeta;
    public final int shaftMeta;
    public static final MysteryDungeonValues SIMPLE_BRICK = new MysteryDungeonValues(new Object[]{Blocks.field_150405_ch, 12}, Blocks.field_150336_V, Blocks.field_150417_aV, Blocks.field_150334_T);
    public static final MysteryDungeonValues FANTASY = new MysteryDungeonValues(new Object[]{Blocks.field_150325_L, 9}, Blocks.field_150484_ah, Blocks.field_150344_f, Blocks.field_150379_bu);

    public MysteryDungeonValues(Object floorParam, Object wallParam, Object ceilingParam, Object ladderParam) {
        Object[][] blockValues = this.parseBlocks(floorParam, wallParam, ceilingParam, ladderParam);
        this.floorID = (Block)blockValues[0][0];
        this.wallID = (Block)blockValues[0][1];
        this.ceilingID = (Block)blockValues[0][2];
        this.shaftID = (Block)blockValues[0][3];
        this.floorMeta = (Integer)blockValues[1][0];
        this.wallMeta = (Integer)blockValues[1][1];
        this.ceilingMeta = (Integer)blockValues[1][2];
        this.shaftMeta = (Integer)blockValues[1][3];
    }

    private Object[][] parseBlocks(Object ... blocks) {
        Block[] blx = new Block[4];
        Integer[] metas = new Integer[]{0, 0, 0, 0};
        for (int i = 0; i < 4; ++i) {
            if (blocks[i] == null) {
                blx[i] = null;
                continue;
            }
            if (blocks[i] instanceof Object[]) {
                Object[] obs = (Object[])blocks[i];
                try {
                    blx[i] = (Block)obs[0];
                }
                catch (ClassCastException e) {
                    throw MysteryDungeonValues.incorrectArrayFormat(obs[0], Block.class, 0);
                }
                try {
                    metas[i] = (Integer)obs[1];
                    continue;
                }
                catch (ClassCastException e) {
                    throw MysteryDungeonValues.incorrectArrayFormat(obs[1], Integer.class, 1);
                }
            }
            if (blocks[i] instanceof Block) {
                blx[i] = (Block)blocks[i];
                continue;
            }
            throw MysteryDungeonValues.notEvenClose(blocks[i]);
        }
        if (!BlockHelper.isBlockNormalCube(blx[3])) {
            throw new IllegalArgumentException("The block specified for the ladder shaft Id MUST be a solid block! The block specified was " + blx[3].func_149732_F());
        }
        return new Object[][]{blx, metas};
    }

    private static IllegalArgumentException incorrectArrayFormat(Object o, Class expected, int index) {
        String className;
        String message = "An Object[] was passed-in to the MysteryDungeonValues constructor; element " + index + " was expected to be a " + expected.getName() + ", but was instead ";
        String string = className = o == null ? "null" : o.getClass().getSimpleName();
        if (className.equals("null")) {
            message = message + "null";
        } else {
            boolean vowel = PixelmonDebug.startsWithVowel(className);
            message = message + (vowel ? "an " : "a ") + className;
        }
        return new IllegalArgumentException(message);
    }

    private static IllegalArgumentException notEvenClose(Object o) {
        String message = "Alright, what do we have here? You were given instructions on how to do this. It's not rocket-science! Look, the valid parameter types for the MysteryDungeonValues constructor are Block and Object[]. You know what you shoved in there? ";
        String className = o == null ? "null" : o.getClass().getSimpleName();
        className = PixelmonDebug.upperCaseFirstChar(className);
        String indef = o == null ? "" : (PixelmonDebug.startsWithVowel(className) ? "an" : "a");
        message = message + System.lineSeparator() + className + ". YOU GAVE IT " + indef.toUpperCase() + className.toUpperCase() + "!";
        if (o == null) {
            message = message + System.lineSeparator() + "NULL, as in YOU GAVE IT A BLANK VALUE! Go back and think about what you've done.";
        }
        return new IllegalArgumentException(message);
    }
}

